/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.recipe;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import derekahedron.invexp.bundle.BundleContents;
import derekahedron.invexp.bundle.BundleContentsComponent;
import derekahedron.invexp.recipe.InvExpRecipes;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class DyeBundleRecipe
implements CraftingRecipe {
    public final ResourceLocation id;
    public final String group;
    public final CraftingBookCategory category;
    public final Ingredient input;
    public final Ingredient material;
    public final ItemStack result;

    public DyeBundleRecipe(ResourceLocation id, String group, CraftingBookCategory category, Ingredient input, Ingredient material, ItemStack result) {
        this.id = id;
        this.group = group;
        this.category = category;
        this.input = input;
        this.material = material;
        this.result = result;
    }

    public boolean matches(CraftingContainer craftingContainer, Level level) {
        ItemStack baseBundle = null;
        ItemStack dye = null;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack stack = craftingContainer.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.input.test(stack)) {
                if (baseBundle != null) {
                    return false;
                }
                baseBundle = stack;
                if (!baseBundle.m_150930_(this.result.m_41720_())) continue;
                return false;
            }
            if (this.material.test(stack)) {
                if (dye != null) {
                    return false;
                }
                dye = stack;
                continue;
            }
            return false;
        }
        return baseBundle != null && dye != null;
    }

    public ItemStack assemble(CraftingContainer craftingContainer, RegistryAccess registryAccess) {
        BundleContents contents;
        BundleContentsComponent component;
        ItemStack baseBundle = null;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack stack = craftingContainer.m_8020_(i);
            if (stack.m_41619_() || !this.input.test(stack)) continue;
            baseBundle = stack;
            break;
        }
        if ((component = BundleContentsComponent.getComponent(baseBundle)) == null) {
            return ItemStack.f_41583_;
        }
        ItemStack resultBundle = this.result.m_41777_();
        component.setComponent(resultBundle);
        if (component.selectedIndex != -1 && (contents = BundleContents.of(resultBundle)) != null && !contents.isEmpty()) {
            contents.setSelectedIndex(-1);
        }
        return resultBundle;
    }

    public boolean m_8004_(int x, int y) {
        return x * y >= 2;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)InvExpRecipes.DYE_BUNDLE_RECIPE.get();
    }

    public CraftingBookCategory m_245232_() {
        return this.category;
    }

    public static class Builder
    extends CraftingRecipeBuilder
    implements RecipeBuilder {
        public final RecipeCategory category;
        public final Item result;
        public final Ingredient input;
        public final Ingredient material;
        public final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
        public final Advancement.Builder advancement = Advancement.Builder.m_285878_();
        @Nullable
        public String group;

        public Builder(RecipeCategory category, ItemLike result, Ingredient input, Ingredient material) {
            this.category = category;
            this.result = result.m_5456_();
            this.input = input;
            this.material = material;
        }

        public Builder unlockedBy(String p_126133_, CriterionTriggerInstance p_126134_) {
            this.advancement.m_138386_(p_126133_, p_126134_);
            return this;
        }

        public Builder group(@Nullable String group) {
            this.group = group;
            return this;
        }

        public Item m_142372_() {
            return this.result;
        }

        public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
            this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
            consumer.accept((FinishedRecipe)new Result(id, this.result, this.group == null ? "" : this.group, Builder.m_245179_((RecipeCategory)this.category), this.input, this.material, this.advancement, id.m_246208_("recipes/" + this.category.m_247710_() + "/")));
        }

        public static class Result
        extends CraftingRecipeBuilder.CraftingResult {
            private final ResourceLocation id;
            private final Item result;
            private final String group;
            public final Ingredient input;
            public final Ingredient material;
            private final Advancement.Builder advancement;
            private final ResourceLocation advancementId;

            public Result(ResourceLocation id, Item result, String group, CraftingBookCategory category, Ingredient input, Ingredient material, Advancement.Builder advancement, ResourceLocation advancementId) {
                super(category);
                this.id = id;
                this.result = result;
                this.group = group;
                this.input = input;
                this.material = material;
                this.advancement = advancement;
                this.advancementId = advancementId;
            }

            public void m_7917_(JsonObject json) {
                super.m_7917_(json);
                if (!this.group.isEmpty()) {
                    json.addProperty("group", this.group);
                }
                json.add("input", this.input.m_43942_());
                json.add("material", this.material.m_43942_());
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result)).toString());
                json.add("result", (JsonElement)resultJson);
            }

            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)InvExpRecipes.DYE_BUNDLE_RECIPE.get();
            }

            public ResourceLocation m_6445_() {
                return this.id;
            }

            @Nullable
            public JsonObject m_5860_() {
                return this.advancement.m_138400_();
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return this.advancementId;
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<DyeBundleRecipe> {
        public DyeBundleRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Ingredient input = Ingredient.m_288218_((JsonElement)json.get("input"), (boolean)false);
            Ingredient material = Ingredient.m_288218_((JsonElement)json.get("material"), (boolean)false);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new DyeBundleRecipe(id, group, category, input, material, result);
        }

        public DyeBundleRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            String group = buf.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Ingredient material = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack result = buf.m_130267_();
            return new DyeBundleRecipe(id, group, category, input, material, result);
        }

        public void toNetwork(FriendlyByteBuf buf, DyeBundleRecipe recipe) {
            buf.m_130070_(recipe.group);
            buf.m_130068_((Enum)recipe.category);
            recipe.input.m_43923_(buf);
            recipe.material.m_43923_(buf);
            buf.m_130055_(recipe.result);
        }
    }
}

