/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.sack;

import com.google.common.collect.Lists;
import derekahedron.invexp.entity.player.PlayerEntityDuck;
import derekahedron.invexp.registry.InvExpRegistryKeys;
import derekahedron.invexp.sack.ImmutableSackContents;
import derekahedron.invexp.sack.SackContentsComponent;
import derekahedron.invexp.sack.SackContentsReader;
import derekahedron.invexp.sack.SackType;
import derekahedron.invexp.sack.SackUsage;
import derekahedron.invexp.sack.SacksHelper;
import derekahedron.invexp.util.ContainerItemContents;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;

public class SackContents
extends ContainerItemContents
implements SackContentsReader {
    public final ItemStack sackStack;
    public SackContentsComponent component;
    public final Registry<SackType> sackTypeRegistry;

    private SackContents(ItemStack sackStack, SackContentsComponent component, Registry<SackType> sackTypeRegistry) {
        this.sackStack = sackStack;
        this.component = component;
        this.sackTypeRegistry = sackTypeRegistry;
    }

    @Nullable
    public static SackContentsReader of(@Nullable ItemStack sackStack) {
        return ImmutableSackContents.of(sackStack);
    }

    @Nullable
    public static SackContents of(@Nullable ItemStack sackStack, Level level) {
        SackContentsComponent component = SackContentsComponent.getComponent(sackStack);
        return component == null ? null : new SackContents(sackStack, component, (Registry<SackType>)level.m_9598_().m_175515_(InvExpRegistryKeys.SACK_TYPE));
    }

    public static ItemStack selectedStackOf(ItemStack sackStack) {
        SackContentsReader contents = SackContents.of(sackStack);
        if (contents != null && !contents.isEmpty()) {
            return contents.getSelectedStack();
        }
        return sackStack;
    }

    public static ItemStack selectedStackOf(@Nullable LivingEntity user, ItemStack sackStack) {
        Player player;
        SackUsage usage;
        if (user instanceof Player && (usage = ((PlayerEntityDuck)(player = (Player)user)).invexp_$getUsageForSackStack(sackStack)) != null) {
            SackContentsReader contents = SackContents.of(usage.sackStack);
            if (contents != null && !contents.isEmpty()) {
                ItemStack selectedStack = contents.getSelectedStack();
                if (ItemStack.m_41728_((ItemStack)usage.selectedStack, (ItemStack)selectedStack)) {
                    return usage.selectedStack;
                }
                return selectedStack;
            }
            return usage.sackStack;
        }
        return SackContents.selectedStackOf(sackStack);
    }

    public boolean isValid() {
        if (!this.component.isValid()) {
            return false;
        }
        return this.getSackTypes().size() <= this.getMaxSackTypes() && this.getTotalWeight().compareTo(this.getMaxSackWeight()) <= 0 && this.getStacks().size() <= this.getMaxSackStacks();
    }

    public void validate(Player player) {
        if (this.isValid()) {
            return;
        }
        ArrayList<ItemStack> removedStacks = new ArrayList<ItemStack>(this.getStacks().size());
        SackContents newContents = new SackContents(this.sackStack, new SackContentsComponent(), this.sackTypeRegistry);
        Builder builder = newContents.getBuilder();
        for (int i = this.getStacks().size() - 1; i >= 0; --i) {
            ItemStack stack = this.getStacks().get(i).m_41777_();
            builder.add(stack, 0);
            if (stack.m_41619_()) continue;
            removedStacks.add(stack);
        }
        builder.selectedIndex = builder.nextSelectedIndex(this.getSelectedStack(), this.getSelectedIndex());
        builder.apply();
        this.component = newContents.component;
        for (ItemStack stack : removedStacks) {
            if (player.m_150109_().m_36054_(stack)) continue;
            player.m_36176_(stack, false);
        }
    }

    @Override
    public List<ItemStack> getStacks() {
        return this.component.getStacks();
    }

    @Override
    public int getSelectedIndex() {
        return this.component.selectedIndex;
    }

    @Override
    public ItemStack getSackStack() {
        return this.sackStack;
    }

    @Override
    public List<String> getSackTypes() {
        return this.component.getSackTypes();
    }

    @Override
    public Fraction getTotalWeight() {
        return this.component.getTotalWeight();
    }

    @Override
    public Builder getBuilder() {
        return new Builder();
    }

    public static boolean attemptPickup(ItemStack sackStack, ItemStack stack, Entity entity) {
        SackContents contents = SackContents.of(sackStack, entity.m_9236_());
        if (contents == null) {
            return false;
        }
        String sackType = SacksHelper.getSackType(stack);
        if (sackType == null || !contents.isInTypes(sackType)) {
            return false;
        }
        contents.add(stack);
        return stack.m_41619_();
    }

    public class Builder
    extends ContainerItemContents.Builder
    implements SackContentsReader {
        public final List<String> sackTypes;
        public final List<ItemStack> stacks;
        public int selectedIndex;
        public Fraction totalWeight;

        public Builder() {
            this.sackTypes = new ArrayList<String>(SackContents.this.component.getSackTypes());
            this.stacks = new ArrayList<ItemStack>(SackContents.this.component.getStacks());
            this.selectedIndex = SackContents.this.component.selectedIndex;
            this.totalWeight = SackContents.this.component.getTotalWeight();
        }

        @Override
        public void apply() {
            SackContents.this.component = new SackContentsComponent(List.copyOf(this.sackTypes), List.copyOf(this.stacks), this.clampIndex(this.selectedIndex));
            SackContents.this.component.setComponent(SackContents.this.sackStack);
        }

        @Override
        public int add(ItemStack stack, int insertAt) {
            if (!this.canTryInsert(stack)) {
                return 0;
            }
            Fraction weight = SacksHelper.getSackWeight(stack);
            int added = 0;
            int toAdd = Math.min(stack.m_41613_(), this.getMaxAllowedByWeight(stack));
            if (toAdd > 0) {
                for (int i = 0; i < this.stacks.size(); ++i) {
                    ItemStack nestedStack = this.stacks.get(i);
                    if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)nestedStack)) continue;
                    int amount = Math.min(toAdd, nestedStack.m_41741_() - nestedStack.m_41613_());
                    if (amount > 0) {
                        this.stacks.set(i, nestedStack.m_255036_(nestedStack.m_41613_() + amount));
                        stack.m_41774_(amount);
                        toAdd -= amount;
                        added += amount;
                        this.totalWeight = this.totalWeight.add(weight.multiplyBy(Fraction.getFraction((double)amount)));
                    }
                    if (toAdd > 0) continue;
                    return added;
                }
                if (this.canAddStack()) {
                    if (insertAt <= this.selectedIndex) {
                        ++this.selectedIndex;
                    }
                    this.totalWeight = this.totalWeight.add(weight.multiplyBy(Fraction.getFraction((double)toAdd)));
                    this.tryAddType(SacksHelper.getSackType(stack));
                    this.stacks.add(insertAt, stack.m_41620_(toAdd));
                    return added += toAdd;
                }
            }
            return added;
        }

        @Override
        public int remove(ItemStack stack, int toRemove) {
            if (this.stacks.isEmpty() || stack.m_41619_() || toRemove <= 0) {
                return 0;
            }
            int removed = 0;
            Fraction weight2 = SacksHelper.getSackWeight(stack);
            boolean removedSelected = false;
            for (int i = 0; i < this.stacks.size() && toRemove > 0; ++i) {
                ItemStack nestedStack = this.stacks.get(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)nestedStack)) continue;
                if (toRemove >= nestedStack.m_41613_()) {
                    removed += nestedStack.m_41613_();
                    toRemove -= nestedStack.m_41613_();
                    this.totalWeight = this.totalWeight.subtract(weight2.multiplyBy(Fraction.getFraction((double)nestedStack.m_41613_())));
                    this.stacks.remove(i);
                    if (i < this.selectedIndex) {
                        --this.selectedIndex;
                    } else if (i == this.selectedIndex) {
                        removedSelected = true;
                    }
                    --i;
                    continue;
                }
                removed += toRemove;
                this.totalWeight = this.totalWeight.subtract(weight2.multiplyBy(Fraction.getFraction((double)toRemove)));
                this.stacks.set(i, nestedStack.m_255036_(nestedStack.m_41613_() - toRemove));
                toRemove = 0;
            }
            if (removedSelected) {
                this.selectedIndex = this.nextSelectedIndex(stack, this.selectedIndex);
            }
            if (removed > 0) {
                this.tryRemoveType(SacksHelper.getSackType(stack));
            }
            return removed;
        }

        @Override
        public ItemStack popSelectedStack() {
            if (this.isEmpty()) {
                return ItemStack.f_41583_;
            }
            ItemStack selectedStack = this.stacks.remove(this.selectedIndex).m_41777_();
            this.selectedIndex = this.nextSelectedIndex(selectedStack, this.selectedIndex);
            this.totalWeight = this.totalWeight.subtract(SacksHelper.getSackWeightOfStack(selectedStack));
            this.tryRemoveType(SacksHelper.getSackType(selectedStack));
            return selectedStack;
        }

        @Override
        public List<ItemStack> popAllStacks() {
            List copies = Lists.transform(this.stacks, ItemStack::m_41777_);
            this.stacks.clear();
            this.selectedIndex = -1;
            this.sackTypes.clear();
            this.totalWeight = Fraction.ZERO;
            return copies;
        }

        @Override
        public ItemStack getSackStack() {
            return SackContents.this.sackStack;
        }

        @Override
        public List<String> getSackTypes() {
            return this.sackTypes;
        }

        @Override
        public List<ItemStack> getStacks() {
            return this.stacks;
        }

        @Override
        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        @Override
        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }

        @Override
        public Fraction getTotalWeight() {
            return this.totalWeight;
        }

        public void tryAddType(@Nullable String sackType) {
            if (sackType != null && !this.isInTypes(sackType) && SackContents.this.sackTypeRegistry.m_7745_(new ResourceLocation(sackType)) != null) {
                this.sackTypes.add(sackType);
            }
        }

        public void tryRemoveType(@Nullable String sackType) {
            if (sackType == null || !this.isInTypes(sackType)) {
                return;
            }
            for (ItemStack nestedStack : this.getStacks()) {
                if (!sackType.equals(SacksHelper.getSackType(nestedStack))) continue;
                return;
            }
            for (int i = 0; i < this.sackTypes.size(); ++i) {
                if (!sackType.equals(this.sackTypes.get(i))) continue;
                this.sackTypes.remove(i);
                --i;
            }
        }
    }
}

