/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.sack;

import derekahedron.invexp.item.SackItem;
import derekahedron.invexp.sack.SackDefaultManager;
import derekahedron.invexp.sack.SacksHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public class SackContentsComponent {
    public static final String COMPOUND_KEY = "InvExpSackContents";
    public static final String TYPES_KEY = "Types";
    public static final String ITEMS_KEY = "Items";
    public static final String SELECTED_INDEX_KEY = "SelectedIndex";
    public static final String TOTAL_WEIGHT_KEY = "TotalWeight";
    public static final String NUMERATOR_KEY = "Numerator";
    public static final String DENOMINATOR_KEY = "Denominator";
    public final List<String> sackTypes;
    public final List<ItemStack> stacks;
    public final int selectedIndex;
    public final Fraction totalWeight;

    public SackContentsComponent(List<String> sackTypes, List<ItemStack> stacks, int selectedIndex) {
        this(sackTypes, stacks, selectedIndex, SackContentsComponent.calculateTotalWeight(stacks));
    }

    public SackContentsComponent(List<String> sackTypes, List<ItemStack> stacks, int selectedIndex, Fraction totalWeight) {
        this.sackTypes = sackTypes;
        this.stacks = stacks;
        this.selectedIndex = selectedIndex;
        this.totalWeight = totalWeight;
    }

    public SackContentsComponent() {
        this(List.of(), List.of(), -1);
    }

    public List<String> getSackTypes() {
        return this.sackTypes;
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Fraction getTotalWeight() {
        return this.totalWeight;
    }

    public boolean isValid() {
        if (SackDefaultManager.getInstance() == null) {
            return false;
        }
        if (this.totalWeight.compareTo(SackContentsComponent.calculateTotalWeight(this.getStacks())) != 0) {
            return false;
        }
        HashSet<String> sackTypesInSack = new HashSet<String>();
        HashSet<String> sackTypes = new HashSet<String>(this.getSackTypes());
        for (ItemStack stack : this.stacks) {
            if (!stack.m_41720_().m_142095_()) {
                return false;
            }
            String sackType = SacksHelper.getSackType(stack);
            if (sackType != null) {
                if (!sackTypes.contains(sackType)) {
                    return false;
                }
                sackTypesInSack.add(sackType);
                continue;
            }
            return false;
        }
        return sackTypes.equals(sackTypesInSack);
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public ItemStack getSelectedStack() {
        if (this.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return this.stacks.get(this.selectedIndex);
    }

    public void setComponent(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!this.isEmpty()) {
            CompoundTag sackContents = new CompoundTag();
            ListTag typesTag = new ListTag();
            for (String string : this.getSackTypes()) {
                typesTag.add((Object)StringTag.m_129297_((String)string));
            }
            sackContents.m_128365_(TYPES_KEY, (Tag)typesTag);
            ListTag contentsTag = new ListTag();
            for (ItemStack nestedStack : this.getStacks()) {
                CompoundTag itemTag = new CompoundTag();
                nestedStack.m_41739_(itemTag);
                contentsTag.add((Object)itemTag);
            }
            sackContents.m_128365_(ITEMS_KEY, (Tag)contentsTag);
            sackContents.m_128405_(SELECTED_INDEX_KEY, this.getSelectedIndex());
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_(NUMERATOR_KEY, this.totalWeight.getNumerator());
            compoundTag.m_128405_(DENOMINATOR_KEY, this.totalWeight.getDenominator());
            sackContents.m_128365_(TOTAL_WEIGHT_KEY, (Tag)compoundTag);
            tag.m_128365_(COMPOUND_KEY, (Tag)sackContents);
        } else {
            tag.m_128473_(COMPOUND_KEY);
        }
    }

    @Nullable
    public static SackContentsComponent getComponent(@Nullable ItemStack stack) {
        if (stack != null && !stack.m_41619_() && stack.m_41720_() instanceof SackItem) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_(COMPOUND_KEY)) {
                CompoundTag sackContents = tag.m_128469_(COMPOUND_KEY);
                ListTag typesTag = sackContents.m_128437_(TYPES_KEY, 8);
                ArrayList<String> sackTypes = new ArrayList<String>(typesTag.size());
                for (int i = 0; i < typesTag.size(); ++i) {
                    sackTypes.add(typesTag.m_128778_(i));
                }
                ListTag contentsTag = sackContents.m_128437_(ITEMS_KEY, 10);
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(contentsTag.size());
                for (int i = 0; i < contentsTag.size(); ++i) {
                    stacks.add(ItemStack.m_41712_((CompoundTag)contentsTag.m_128728_(i)));
                }
                int selectedIndex = sackContents.m_128451_(SELECTED_INDEX_KEY);
                if (sackContents.m_128425_(TOTAL_WEIGHT_KEY, 10)) {
                    CompoundTag totalWeightTag = sackContents.m_128469_(TOTAL_WEIGHT_KEY);
                    Fraction totalWeight = Fraction.getFraction((int)totalWeightTag.m_128451_(NUMERATOR_KEY), (int)totalWeightTag.m_128451_(DENOMINATOR_KEY));
                    return new SackContentsComponent(sackTypes, stacks, selectedIndex, totalWeight);
                }
                return new SackContentsComponent(sackTypes, stacks, selectedIndex);
            }
            return new SackContentsComponent();
        }
        return null;
    }

    public static Fraction calculateTotalWeight(List<ItemStack> stacks) {
        Fraction totalWeight = Fraction.ZERO;
        for (ItemStack stack : stacks) {
            totalWeight = totalWeight.add(SacksHelper.getSackWeightOfStack(stack));
        }
        return totalWeight;
    }
}

