/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.sack;

import derekahedron.invexp.item.SackItem;
import derekahedron.invexp.sack.SacksHelper;
import derekahedron.invexp.util.ContainerItemContentsReader;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public interface SackContentsReader
extends ContainerItemContentsReader {
    public ItemStack getSackStack();

    public List<String> getSackTypes();

    public Fraction getTotalWeight();

    @Override
    default public boolean isFull() {
        return this.getTotalWeight().compareTo(this.getMaxSackWeight()) >= 0 || this.getStacks().size() >= this.getMaxSackStacks();
    }

    @Override
    default public Fraction getFillFraction() {
        if (this.isFull()) {
            return Fraction.ONE;
        }
        return this.getTotalWeight().divideBy(this.getMaxSackWeight());
    }

    @Override
    default public boolean canTryInsert(ItemStack stack) {
        if (!stack.m_41720_().m_142095_()) {
            return false;
        }
        String sackType = SacksHelper.getSackType(stack);
        if (sackType == null) {
            return false;
        }
        return this.canAddType() || this.isInTypes(sackType);
    }

    @Override
    default public int getMaxAllowed(ItemStack stack) {
        if (!this.canTryInsert(stack)) {
            return 0;
        }
        int maxAllowedByWeight = this.getMaxAllowedByWeight(stack);
        if (maxAllowedByWeight == 0) {
            return 0;
        }
        if (this.canAddStack()) {
            return maxAllowedByWeight;
        }
        int maxAllowed = 0;
        for (ItemStack nestedStack : this.getStacks()) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)nestedStack) || (maxAllowed += nestedStack.m_41741_() - nestedStack.m_41613_()) < maxAllowedByWeight) continue;
            return maxAllowedByWeight;
        }
        return maxAllowed;
    }

    default public int getMaxAllowedByWeight(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        Fraction weight = SacksHelper.getSackWeight(stack);
        if (weight.compareTo(Fraction.ZERO) > 0) {
            Fraction openWeight = this.getMaxSackWeight().subtract(this.getTotalWeight());
            return Math.max(openWeight.divideBy(weight).intValue(), 0);
        }
        return stack.m_41613_();
    }

    default public boolean isInTypes(@Nullable String sackType) {
        if (sackType == null) {
            return false;
        }
        for (String nestedType : this.getSackTypes()) {
            if (!sackType.equals(nestedType)) continue;
            return true;
        }
        return false;
    }

    default public boolean canAddType() {
        return this.getSackTypes().size() < this.getMaxSackTypes();
    }

    @Override
    default public boolean canAddStack() {
        return this.getStacks().size() < this.getMaxSackStacks();
    }

    default public int getMaxSackStacks() {
        Item item = this.getSackStack().m_41720_();
        if (item instanceof SackItem) {
            SackItem sackItem = (SackItem)item;
            return sackItem.getMaxSackStacks();
        }
        return 0;
    }

    default public int getMaxSackTypes() {
        Item item = this.getSackStack().m_41720_();
        if (item instanceof SackItem) {
            SackItem sackItem = (SackItem)item;
            return sackItem.getMaxSackTypes();
        }
        return 0;
    }

    default public Fraction getMaxSackWeight() {
        Item item = this.getSackStack().m_41720_();
        if (item instanceof SackItem) {
            SackItem sackItem = (SackItem)item;
            return sackItem.getMaxSackWeight();
        }
        return Fraction.ZERO;
    }
}

