/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.sack;

import derekahedron.invexp.InventoryExpansion;
import derekahedron.invexp.item.ItemDuck;
import derekahedron.invexp.registry.InvExpRegistryKeys;
import derekahedron.invexp.sack.SackType;
import derekahedron.invexp.sack.SackTypeDefault;
import derekahedron.invexp.sack.SackTypes;
import derekahedron.invexp.sack.SackWeightDefault;
import derekahedron.invexp.sack.SacksHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.math.Fraction;

public class SackDefaultManager {
    @Nullable
    private static SackDefaultManager INSTANCE;
    private int syncId;
    private final List<Holder.Reference<SackTypeDefault>> typeDefaults;
    private final List<Holder.Reference<SackTypeDefault>> globalTypeDefaults;
    private final List<Holder.Reference<SackWeightDefault>> weightDefaults;
    private final List<Holder.Reference<SackWeightDefault>> globalWeightDefaults;

    public SackDefaultManager(RegistryAccess registryAccess) {
        this.syncId = INSTANCE != null ? SackDefaultManager.INSTANCE.syncId : 0;
        ArrayList types = new ArrayList(registryAccess.m_175515_(InvExpRegistryKeys.SACK_TYPE_DEFAULT).m_203611_().sorted(SackDefaultManager::compareTypes).toList());
        Collections.reverse(types);
        ArrayList weights = new ArrayList(registryAccess.m_175515_(InvExpRegistryKeys.SACK_WEIGHT_DEFAULT).m_203611_().sorted(SackDefaultManager::compareWeights).toList());
        Collections.reverse(weights);
        this.typeDefaults = types.stream().filter(type -> ((SackTypeDefault)type.m_203334_()).items().isPresent()).toList();
        this.globalTypeDefaults = types.stream().filter(type -> ((SackTypeDefault)type.m_203334_()).items().isEmpty()).toList();
        this.weightDefaults = weights.stream().filter(weight -> ((SackWeightDefault)weight.m_203334_()).items().isPresent()).toList();
        this.globalWeightDefaults = weights.stream().filter(weight -> ((SackWeightDefault)weight.m_203334_()).items().isEmpty()).toList();
        this.updateSackDefaults();
    }

    public void updateSackDefaults() {
        ++this.syncId;
        for (Holder.Reference<SackTypeDefault> reference : this.typeDefaults) {
            ((SackTypeDefault)reference.m_203334_()).items().ifPresent(items -> {
                for (ItemStack itemStack : items.m_43908_()) {
                    this.getOrCreateSackDefaults((Item)itemStack.m_41720_()).typeDefaults.add(typeDefault);
                }
            });
        }
        for (Holder.Reference reference : this.weightDefaults) {
            ((SackWeightDefault)reference.m_203334_()).items().ifPresent(items -> {
                for (ItemStack itemStack : items.m_43908_()) {
                    this.getOrCreateSackDefaults((Item)itemStack.m_41720_()).weightDefaults.add((Holder.Reference<SackWeightDefault>)weightDefault);
                }
            });
        }
    }

    @Nullable
    public ResourceKey<SackType> getType(ItemStack stack) {
        SackDefaults defaults = this.getSackDefaults(stack.m_41720_());
        List<Object> itemTypeDefaults = defaults != null ? defaults.typeDefaults : List.of();
        int i = 0;
        int j = 0;
        while (i < this.globalTypeDefaults.size() || j < itemTypeDefaults.size()) {
            SackTypeDefault typeDefault;
            if (i < this.globalTypeDefaults.size() && (j >= itemTypeDefaults.size() || SackDefaultManager.compareTypes(this.globalTypeDefaults.get(i), (Holder.Reference<SackTypeDefault>)((Holder.Reference)itemTypeDefaults.get(j))) > 0)) {
                typeDefault = (SackTypeDefault)this.globalTypeDefaults.get(i).m_203334_();
                ++i;
            } else {
                typeDefault = (SackTypeDefault)((Holder.Reference)itemTypeDefaults.get(j)).m_203334_();
                ++j;
            }
            if (!typeDefault.test(stack)) continue;
            return typeDefault.sackType().isPresent() ? (ResourceKey)typeDefault.sackType().get().m_203543_().orElse(null) : null;
        }
        if (stack.m_41720_() instanceof SpawnEggItem) {
            return SackTypes.SPAWN_EGG;
        }
        if (stack.m_41720_() instanceof BucketItem) {
            return SackTypes.BUCKET;
        }
        return null;
    }

    public Fraction getWeight(ItemStack stack) {
        BucketItem bucketItem;
        SackDefaults defaults = this.getSackDefaults(stack.m_41720_());
        List<Object> itemWeightDefaults = defaults != null ? defaults.weightDefaults : List.of();
        int i = 0;
        int j = 0;
        while (i < this.globalWeightDefaults.size() || j < itemWeightDefaults.size()) {
            SackWeightDefault weightDefault;
            if (i < this.globalWeightDefaults.size() && (j >= itemWeightDefaults.size() || SackDefaultManager.compareWeights(this.globalWeightDefaults.get(i), (Holder.Reference<SackWeightDefault>)((Holder.Reference)itemWeightDefaults.get(j))) > 0)) {
                weightDefault = (SackWeightDefault)this.globalWeightDefaults.get(i).m_203334_();
                ++i;
            } else {
                weightDefault = (SackWeightDefault)((Holder.Reference)itemWeightDefaults.get(j)).m_203334_();
                ++j;
            }
            if (!weightDefault.test(stack)) continue;
            return weightDefault.sackWeight().orElse(SacksHelper.DEFAULT_SACK_WEIGHT);
        }
        Item item = stack.m_41720_();
        if (item instanceof BucketItem && !(bucketItem = (BucketItem)item).getFluid().m_6212_(Fluids.f_76191_)) {
            return Fraction.ONE_QUARTER;
        }
        return SacksHelper.DEFAULT_SACK_WEIGHT;
    }

    @Nullable
    public SackDefaults getSackDefaults(Item item) {
        SackDefaults defaults = ((ItemDuck)item).invexp$getSackDefaults();
        return defaults != null && defaults.syncId == this.syncId ? defaults : null;
    }

    public SackDefaults getOrCreateSackDefaults(Item item) {
        SackDefaults defaults = this.getSackDefaults(item);
        if (defaults == null) {
            defaults = new SackDefaults(new ArrayList<Holder.Reference<SackTypeDefault>>(), new ArrayList<Holder.Reference<SackWeightDefault>>(), this.syncId);
            ((ItemDuck)item).invexp$setSackDefaults(defaults);
        }
        return defaults;
    }

    @Nullable
    public static SackDefaultManager getInstance() {
        return INSTANCE;
    }

    public static void updateInstanceSackDefaults() {
        if (INSTANCE != null) {
            INSTANCE.updateSackDefaults();
        } else {
            InventoryExpansion.LOGGER.warn("Sack Defaults were updated before insertable manager instance created!");
        }
    }

    private static void setInstance(@Nullable SackDefaultManager instance) {
        INSTANCE = instance;
    }

    public static void createNewInstance(RegistryAccess registryAccess) {
        SackDefaultManager.setInstance(new SackDefaultManager(registryAccess));
    }

    private static int compareTypes(Holder.Reference<SackTypeDefault> left, Holder.Reference<SackTypeDefault> right) {
        int compareResult = ((SackTypeDefault)left.m_203334_()).compareTo((SackTypeDefault)right.m_203334_());
        return compareResult != 0 ? compareResult : left.m_205785_().m_135782_().compareTo(right.m_205785_().m_135782_());
    }

    private static int compareWeights(Holder.Reference<SackWeightDefault> left, Holder.Reference<SackWeightDefault> right) {
        int compareResult = ((SackWeightDefault)left.m_203334_()).compareTo((SackWeightDefault)right.m_203334_());
        return compareResult != 0 ? compareResult : left.m_205785_().m_135782_().compareTo(right.m_205785_().m_135782_());
    }

    public record SackDefaults(List<Holder.Reference<SackTypeDefault>> typeDefaults, List<Holder.Reference<SackWeightDefault>> weightDefaults, int syncId) {
    }
}

