/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.sack;

import derekahedron.invexp.InventoryExpansion;
import derekahedron.invexp.sack.SackContents;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SackUsage {
    public final ItemStack sackStack;
    public ItemStack selectedStack;
    public ItemStack originalSelectedStack;

    public SackUsage(SackContents contents) {
        this(contents, null);
    }

    public SackUsage(SackContents contents, @Nullable ItemStack previousSelectedStack) {
        this.sackStack = contents.sackStack;
        this.selectedStack = contents.copySelectedStack(previousSelectedStack);
        this.originalSelectedStack = this.selectedStack.m_41777_();
    }

    public void update(Level level, Consumer<ItemStack> leftoverStackConsumer) {
        ItemStack leftoverStack = ItemStack.f_41583_;
        SackContents contents = SackContents.of(this.sackStack, level);
        if (contents == null) {
            InventoryExpansion.LOGGER.warn("Contents of {} is invalid when updating usage!", (Object)this.sackStack);
            return;
        }
        if (this.originalSelectedStack.m_41619_()) {
            SackContents.Builder builder;
            if (!this.selectedStack.m_41619_() && (builder = contents.getBuilder()).add(leftoverStack = this.selectedStack.m_41777_(), 0) > 0) {
                builder.apply();
            }
        } else if (this.selectedStack.m_41619_()) {
            SackContents.Builder builder = contents.getBuilder();
            if (builder.remove(this.originalSelectedStack) != this.originalSelectedStack.m_41613_()) {
                InventoryExpansion.LOGGER.warn("ItemStack {} not fully removed.", (Object)this.originalSelectedStack);
            }
            builder.apply();
        } else if (ItemStack.m_150942_((ItemStack)this.originalSelectedStack, (ItemStack)this.selectedStack)) {
            int countDiff = this.selectedStack.m_41613_() - this.originalSelectedStack.m_41613_();
            if (countDiff > 0) {
                SackContents.Builder builder = contents.getBuilder();
                if (builder.add(leftoverStack = this.selectedStack.m_255036_(countDiff), 0) > 0) {
                    builder.apply();
                }
            } else if (countDiff < 0) {
                SackContents.Builder builder = contents.getBuilder();
                if (builder.remove(this.originalSelectedStack, -countDiff) != -countDiff) {
                    InventoryExpansion.LOGGER.warn("Count difference ({}) for {} not fully removed", (Object)(-countDiff), (Object)this.originalSelectedStack);
                }
                builder.apply();
            }
        } else {
            SackContents.Builder builder = contents.getBuilder();
            if (builder.replaceSelectedStack(leftoverStack = this.selectedStack.m_41777_(), this.originalSelectedStack.m_41613_())) {
                builder.apply();
            }
        }
        this.selectedStack = contents.copySelectedStack(this.selectedStack);
        this.originalSelectedStack = this.selectedStack.m_41777_();
        if (!leftoverStack.m_41619_()) {
            leftoverStackConsumer.accept(leftoverStack);
        }
    }
}

