/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.util;

import derekahedron.invexp.InventoryExpansion;
import derekahedron.invexp.quiver.QuiverContents;
import derekahedron.invexp.sack.SackContents;
import derekahedron.invexp.util.ContainerItemContentsReader;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class ContainerItemContents
implements ContainerItemContentsReader {
    @Nullable
    public static ContainerItemContentsReader of(@Nullable ItemStack stack) {
        ContainerItemContentsReader contents = SackContents.of(stack);
        if (contents != null) {
            return contents;
        }
        contents = QuiverContents.of(stack);
        if (contents != null) {
            return contents;
        }
        return null;
    }

    @Nullable
    public static ContainerItemContents of(@Nullable ItemStack stack, Level level) {
        ContainerItemContents contents = SackContents.of(stack, level);
        if (contents != null) {
            return contents;
        }
        contents = QuiverContents.of(stack);
        if (contents != null) {
            return contents;
        }
        return null;
    }

    public ItemStack copySelectedStack() {
        return this.copySelectedStack(null);
    }

    public ItemStack copySelectedStack(@Nullable ItemStack currentSelectedStack) {
        if (this.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack selectedStack = this.getSelectedStack();
        if (currentSelectedStack != null && ItemStack.m_150942_((ItemStack)selectedStack, (ItemStack)currentSelectedStack)) {
            currentSelectedStack.m_41764_(selectedStack.m_41613_());
            return currentSelectedStack;
        }
        return selectedStack.m_41777_();
    }

    public int add(ItemStack stack) {
        if (this.getMaxAllowed(stack) > 0) {
            Builder builder = this.getBuilder();
            int added = builder.add(stack, 0);
            if (added > 0) {
                builder.apply();
            }
            return added;
        }
        return 0;
    }

    public int add(Slot slot, Player player) {
        return this.add(Stream.of(slot), player);
    }

    public int add(Stream<Slot> slots, Player player) {
        Builder builder = null;
        ContainerItemContentsReader checker = this;
        int added = 0;
        for (Slot slot : slots.toList()) {
            ItemStack stack = slot.m_7993_();
            int maxAllowed = checker.getMaxAllowed(stack);
            if (maxAllowed <= 0 || (stack = slot.m_150647_(stack.m_41613_(), maxAllowed, player)).m_41619_()) continue;
            if (builder == null) {
                builder = this.getBuilder();
                checker = builder;
            }
            added += builder.add(stack);
        }
        if (added > 0) {
            builder.apply();
        }
        return added;
    }

    public int remove(ItemStack stack) {
        if (this.isEmpty() || stack.m_41619_()) {
            return 0;
        }
        Builder builder = this.getBuilder();
        int removed = builder.remove(stack);
        if (removed == stack.m_41613_()) {
            builder.apply();
            return removed;
        }
        return 0;
    }

    public ItemStack popSelectedItem() {
        if (this.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack selectedStack = this.getSelectedStack();
        if (selectedStack.m_41613_() == 1) {
            return this.popSelectedStack();
        }
        Builder builder = this.getBuilder();
        if (builder.remove(selectedStack = selectedStack.m_255036_(1)) > 0) {
            builder.apply();
            return selectedStack;
        }
        InventoryExpansion.LOGGER.warn("ItemStack {} not removed", (Object)selectedStack);
        return ItemStack.f_41583_;
    }

    public ItemStack popSelectedStack() {
        if (this.isEmpty()) {
            return ItemStack.f_41583_;
        }
        Builder builder = this.getBuilder();
        ItemStack stack = builder.popSelectedStack();
        if (!stack.m_41619_()) {
            builder.apply();
        }
        return stack;
    }

    public boolean popSelectedStack(Slot slot) {
        if (this.isEmpty()) {
            return false;
        }
        ItemStack selectedStack = this.getSelectedStack();
        int toRemove = selectedStack.m_41613_() - slot.m_150659_(selectedStack.m_41777_()).m_41613_();
        if (toRemove == 0) {
            return false;
        }
        if (toRemove == selectedStack.m_41613_()) {
            this.popSelectedStack();
            return true;
        }
        Builder builder = this.getBuilder();
        if (builder.remove(selectedStack, toRemove) > 0) {
            builder.apply();
            return true;
        }
        InventoryExpansion.LOGGER.warn("ItemStack {} not removed. Potential duplicate in slot {}", (Object)selectedStack, (Object)slot);
        return false;
    }

    public List<ItemStack> popAllStacks() {
        if (this.isEmpty()) {
            return List.of();
        }
        Builder builder = this.getBuilder();
        List<ItemStack> stacks = builder.popAllStacks();
        builder.apply();
        return stacks;
    }

    public void setSelectedIndex(int selectedIndex) {
        if ((selectedIndex = this.clampIndex(selectedIndex)) != this.getSelectedIndex()) {
            Builder builder = this.getBuilder();
            builder.setSelectedIndex(selectedIndex);
            builder.apply();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateSelectedStack(ItemStack selectedStack, Consumer<ItemStack> leftoverStackConsumer) {
        ItemStack leftoverStack = ItemStack.f_41583_;
        if (this.isEmpty()) {
            if (selectedStack.m_41619_()) {
                return;
            }
            Builder builder = this.getBuilder();
            if (builder.add(leftoverStack = selectedStack.m_41777_(), 0) > 0) {
                builder.apply();
            }
        } else {
            ItemStack oldStack = this.getSelectedStack();
            if (selectedStack.m_41619_()) {
                Builder builder = this.getBuilder();
                if (builder.remove(oldStack) != oldStack.m_41613_()) {
                    InventoryExpansion.LOGGER.warn("ItemStack {} not fully removed.", (Object)oldStack);
                }
                builder.apply();
            } else if (ItemStack.m_150942_((ItemStack)oldStack, (ItemStack)selectedStack)) {
                int countDiff = selectedStack.m_41613_() - oldStack.m_41613_();
                if (countDiff > 0) {
                    Builder builder = this.getBuilder();
                    if (builder.add(leftoverStack = selectedStack.m_255036_(countDiff), 0) > 0) {
                        builder.apply();
                    }
                } else {
                    if (countDiff >= 0) return;
                    Builder builder = this.getBuilder();
                    if (builder.remove(oldStack, -countDiff) != -countDiff) {
                        InventoryExpansion.LOGGER.warn("Count difference ({}) for {} not fully removed", (Object)(-countDiff), (Object)oldStack);
                    }
                    builder.apply();
                }
            } else {
                Builder builder = this.getBuilder();
                if (builder.replaceSelectedStack(leftoverStack = selectedStack.m_41777_())) {
                    builder.apply();
                }
            }
        }
        if (!leftoverStack.m_41619_()) {
            leftoverStackConsumer.accept(leftoverStack);
        }
        this.copySelectedStack(selectedStack);
    }

    public abstract Builder getBuilder();

    public static abstract class Builder
    implements ContainerItemContentsReader {
        public abstract void apply();

        public abstract int add(ItemStack var1, int var2);

        public abstract int remove(ItemStack var1, int var2);

        public abstract ItemStack popSelectedStack();

        public abstract List<ItemStack> popAllStacks();

        public abstract void setSelectedIndex(int var1);

        public int add(ItemStack stack) {
            return this.add(stack, 0);
        }

        public int remove(ItemStack stack) {
            return this.remove(stack, stack.m_41613_());
        }

        public boolean replaceSelectedStack(ItemStack stack) {
            return this.replaceSelectedStack(stack, this.getSelectedStack().m_41613_());
        }

        public boolean replaceSelectedStack(ItemStack stack, int count) {
            ItemStack backupPick;
            ItemStack firstPick;
            int insertAt;
            if (this.isEmpty()) {
                return false;
            }
            ItemStack selectedStack = this.getSelectedStack();
            if (count > selectedStack.m_41613_()) {
                InventoryExpansion.LOGGER.warn("Cannot remove {} from selected stack {}", (Object)count, (Object)selectedStack);
                return false;
            }
            if (count < selectedStack.m_41613_()) {
                if (this.remove(selectedStack, count) != count) {
                    InventoryExpansion.LOGGER.warn("Selected Stack {} not fully replaced!", (Object)selectedStack);
                }
                insertAt = this.getSelectedIndex() + 1;
            } else {
                insertAt = this.getSelectedIndex();
                this.popSelectedStack();
            }
            if (ItemStack.m_41656_((ItemStack)stack, (ItemStack)selectedStack)) {
                firstPick = stack.m_41777_();
                backupPick = selectedStack;
            } else {
                firstPick = selectedStack;
                backupPick = stack.m_41777_();
            }
            this.add(stack, insertAt);
            this.setSelectedIndex(this.nextSelectedIndex(firstPick, backupPick, insertAt));
            return true;
        }

        public int nextSelectedIndex(ItemStack stack, int startingIndex) {
            return this.nextSelectedIndex(stack, null, startingIndex);
        }

        public int nextSelectedIndex(ItemStack stack, @Nullable ItemStack backupStack, int startingIndex) {
            if (this.isEmpty()) {
                return -1;
            }
            int newIndex = this.indexOf(stack, startingIndex);
            if (newIndex != -1) {
                return newIndex;
            }
            if (backupStack != null && (newIndex = this.indexOf(backupStack, startingIndex)) != -1) {
                return newIndex;
            }
            return this.clampIndex(startingIndex);
        }
    }
}

