/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.math.Fraction;

public class InvExpCodecs {
    public static final Codec<Fraction> FRACTION = new Codec<Fraction>(){
        public static final Codec<Fraction> NUMERATOR_DENOMINATOR_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("numerator").forGetter(Fraction::getNumerator), (App)Codec.INT.fieldOf("denominator").forGetter(Fraction::getDenominator)).apply((Applicative)instance, Fraction::getFraction));

        public <T> DataResult<Pair<Fraction, T>> decode(DynamicOps<T> ops, T input) {
            DataResult result;
            try {
                result = Codec.DOUBLE.map(Fraction::getFraction).decode(ops, input);
                if (result.result().isPresent()) {
                    return result;
                }
            }
            catch (Exception e) {
                return DataResult.error(e::getMessage);
            }
            try {
                result = Codec.INT.map(Fraction::getFraction).decode(ops, input);
                if (result.result().isPresent()) {
                    return result;
                }
            }
            catch (Exception e) {
                return DataResult.error(e::getMessage);
            }
            try {
                result = Codec.STRING.map(Fraction::getFraction).decode(ops, input);
                if (result.result().isPresent()) {
                    return result;
                }
            }
            catch (Exception e) {
                return DataResult.error(e::getMessage);
            }
            try {
                result = NUMERATOR_DENOMINATOR_CODEC.decode(ops, input);
                if (result.result().isPresent()) {
                    return result;
                }
            }
            catch (Exception e) {
                return DataResult.error(e::getMessage);
            }
            return DataResult.error(() -> "Not a fraction: " + String.valueOf(input));
        }

        public <T> DataResult<T> encode(Fraction fraction, DynamicOps<T> ops, T prefix) {
            if (fraction.getDenominator() == 1) {
                return Codec.INT.comap(Fraction::getNumerator).encode((Object)fraction, ops, prefix);
            }
            return NUMERATOR_DENOMINATOR_CODEC.encode((Object)fraction, ops, prefix);
        }
    };
    public static final Codec<Ingredient> INGREDIENT = ExtraCodecs.f_252400_.xmap(Ingredient::m_43917_, Ingredient::m_43942_);
    public static final Codec<ItemPredicate> ITEM_PREDICATE = ExtraCodecs.f_252400_.xmap(ItemPredicate::m_45051_, itemPredicate -> {
        JsonElement json = itemPredicate.m_45048_();
        if (json instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)json;
            if (jsonObject.get("count").isJsonNull()) {
                jsonObject.remove("count");
            }
            if (jsonObject.get("durability").isJsonNull()) {
                jsonObject.remove("durability");
            }
            if (jsonObject.get("nbt").isJsonNull()) {
                jsonObject.remove("nbt");
            }
        }
        return json;
    });
}

