/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Client.Screen.RoboSurgeon;

import com.Maxwell.cyber_ware_port.Client.Screen.RoboSurgeon.InstalledCyberwareScreen;
import com.Maxwell.cyber_ware_port.Common.Block.Robosurgeon.RobosurgeonBlockEntity;
import com.Maxwell.cyber_ware_port.Common.Capability.CyberwareCapabilityProvider;
import com.Maxwell.cyber_ware_port.Common.Capability.CyberwareUserData;
import com.Maxwell.cyber_ware_port.Common.Container.RobosurgeonMenu;
import com.Maxwell.cyber_ware_port.Common.Entity.PlayerPartsModel.PlayerInternalPartsModel;
import com.Maxwell.cyber_ware_port.Common.Item.Base.ICyberware;
import com.Maxwell.cyber_ware_port.Common.Network.A_PacketHandler;
import com.Maxwell.cyber_ware_port.Common.Network.SurgeryGhostTogglePacket;
import com.Maxwell.cyber_ware_port.Common.Risk.SurgeryAlert;
import com.Maxwell.cyber_ware_port.Common.Risk.SurgeryAnalyzer;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class RobosurgeonScreen
extends AbstractContainerScreen<RobosurgeonMenu> {
    private static final ResourceLocation INTERNAL_PARTS_TEXTURE = new ResourceLocation("cyber_ware_port", "textures/gui/player_internal_part.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("cyber_ware_port", "textures/gui/surgery.png");
    private static final ResourceLocation MARKER_TEXTURE = new ResourceLocation("cyber_ware_port", "textures/gui/marker.png");
    private static final ResourceLocation RED_SLOT_TEXTURE = new ResourceLocation("cyber_ware_port", "textures/gui/red_slot.png");
    private static final ResourceLocation BLUE_SLOT_TEXTURE = new ResourceLocation("cyber_ware_port", "textures/gui/blue_slot.png");
    private static final ResourceLocation ALERT_ICON = new ResourceLocation("cyber_ware_port", "textures/gui/risk_icons.png");
    private static final float ANIMATION_DURATION = 2000.0f;
    private static final int SLOT_SIZE = 18;
    private static final int SLOT_SPACING = 2;
    private static final int GUI_WIDTH = 175;
    private static final int TOP_HEIGHT = 131;
    private static final int BOTTOM_HEIGHT = 91;
    private static final int TEXTURE_INVENTORY_START_Y = 131;
    private static final float BASE_SCALE = 45.0f;
    private PlayerInternalPartsModel internalPartsModel;
    private BodyPart selectedPart = BodyPart.NONE;
    private TargetMarker selectedMarker = null;
    private Skeleton dummySkeleton;
    private boolean isDraggingModel = false;
    private float viewRotation = 0.0f;
    private double dragStartX = 0.0;
    private float rotationStart = 0.0f;
    private boolean potentialDrag = false;
    private long startTime;
    private AbstractWidget installedListButton;
    private float currentScale = 45.0f;
    private float currentOffsetX = 0.0f;
    private float currentOffsetY = 0.0f;
    private boolean hideName = false;

    public RobosurgeonScreen(RobosurgeonMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 175;
        this.f_97727_ = 222;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97729_ = 6;
    }

    public static void renderEntityWithRotation(GuiGraphics pGuiGraphics, int pX, int pY, int pScale, float rotationYaw, LivingEntity pEntity) {
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)pX, (float)pY, 50.0f);
        pGuiGraphics.m_280168_().m_252931_(new Matrix4f().scaling((float)pScale, (float)pScale, (float)(-pScale)));
        Quaternionf quaternionf = Axis.f_252403_.m_252977_(180.0f);
        Quaternionf rotation = Axis.f_252436_.m_252977_(rotationYaw + 180.0f);
        quaternionf.mul((Quaternionfc)rotation);
        pGuiGraphics.m_280168_().m_252781_(quaternionf);
        float f2 = pEntity.f_20883_;
        float f3 = pEntity.m_146908_();
        float f4 = pEntity.m_146909_();
        float f5 = pEntity.f_20886_;
        float f6 = pEntity.f_20885_;
        pEntity.f_20883_ = 0.0f;
        pEntity.m_146922_(0.0f);
        pEntity.m_146926_(0.0f);
        pEntity.f_20885_ = 0.0f;
        pEntity.f_20886_ = 0.0f;
        float originalLimbSwing = pEntity.f_267362_.m_267756_();
        float originalLimbSwingAmount = pEntity.f_267362_.m_267731_();
        float originalAttackAnim = pEntity.f_20921_;
        pEntity.f_267362_.m_267771_(0.0f);
        pEntity.f_20921_ = 0.0f;
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        rotation.conjugate();
        entityrenderdispatcher.m_252923_(rotation);
        entityrenderdispatcher.m_114468_(false);
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.m_114384_((Entity)pEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, pGuiGraphics.m_280168_(), (MultiBufferSource)pGuiGraphics.m_280091_(), 0xF000F0));
        pGuiGraphics.m_280262_();
        entityrenderdispatcher.m_114468_(true);
        pEntity.f_20883_ = f2;
        pEntity.m_146922_(f3);
        pEntity.m_146926_(f4);
        pEntity.f_20886_ = f5;
        pEntity.f_20885_ = f6;
        pEntity.f_267362_.m_267771_(originalLimbSwingAmount);
        pEntity.f_20921_ = originalAttackAnim;
        pGuiGraphics.m_280168_().m_85849_();
        Lighting.m_84931_();
    }

    private static int[] slots(int start) {
        int[] slots = new int[9];
        for (int i = 0; i < 9; ++i) {
            slots[i] = start + i;
        }
        return slots;
    }

    public static void renderCustomModel(GuiGraphics pGuiGraphics, int pX, int pY, int pScale, float rotationYaw, Model pModel) {
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)pX, (float)pY, 50.0f);
        pGuiGraphics.m_280168_().m_252931_(new Matrix4f().scaling((float)pScale, (float)pScale, (float)(-pScale)));
        Quaternionf quaternionf = Axis.f_252403_.m_252977_(180.0f);
        Quaternionf rotation = Axis.f_252436_.m_252977_(rotationYaw + 180.0f);
        quaternionf.mul((Quaternionfc)rotation);
        pGuiGraphics.m_280168_().m_252781_(quaternionf);
        Lighting.m_166384_();
        VertexConsumer vertexConsumer = pGuiGraphics.m_280091_().m_6299_(pModel.m_103119_(INTERNAL_PARTS_TEXTURE));
        pModel.m_7695_(pGuiGraphics.m_280168_(), vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pGuiGraphics.m_280262_();
        pGuiGraphics.m_280168_().m_85849_();
        Lighting.m_84931_();
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            this.dummySkeleton = new Skeleton(EntityType.f_20524_, (Level)this.f_96541_.f_91073_);
            this.internalPartsModel = new PlayerInternalPartsModel(this.f_96541_.m_167973_().m_171103_(PlayerInternalPartsModel.LAYER_LOCATION));
        }
        this.startTime = System.currentTimeMillis();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        int listBtnX = x + 158;
        int listBtnY = y + 4;
        this.installedListButton = new AbstractWidget(listBtnX, listBtnY, 10, 10, (Component)Component.m_237119_()){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.m_280411_(TEXTURE, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 176.0f, 122.0f, 10, 10, 256, 256);
                if (this.m_274382_()) {
                    guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, 0x50FFFFFF);
                    guiGraphics.m_280557_(RobosurgeonScreen.this.f_96547_, (Component)Component.m_237115_((String)"gui.cyber_ware_port.button.view_installed"), mouseX, mouseY);
                }
            }

            public void m_5716_(double mouseX, double mouseY) {
                Minecraft.m_91087_().m_91152_((Screen)new InstalledCyberwareScreen((Screen)RobosurgeonScreen.this));
            }

            protected void m_168797_(NarrationElementOutput narrationElementOutput) {
                this.m_168802_(narrationElementOutput);
            }
        };
        this.installedListButton.f_93624_ = true;
        this.m_142416_((GuiEventListener)this.installedListButton);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        if ((float)elapsedTime < 2000.0f) {
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        this.updateSlotPositions();
        if (!((RobosurgeonMenu)this.f_97732_).m_142621_().m_41619_()) {
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        if ((pButton == 0 || pButton == 1) && this.selectedMarker != null) {
            Slot hoveredSlot = null;
            for (Slot slot : ((RobosurgeonMenu)this.f_97732_).f_38839_) {
                if (slot.f_40220_ > 10000 || slot.f_40221_ > 10000) continue;
                int slotLeft = this.f_97735_ + slot.f_40220_;
                int slotTop = this.f_97736_ + slot.f_40221_;
                if (!(pMouseX >= (double)slotLeft) || !(pMouseX < (double)(slotLeft + 16)) || !(pMouseY >= (double)slotTop) || !(pMouseY < (double)(slotTop + 16))) continue;
                hoveredSlot = slot;
                break;
            }
            if (hoveredSlot != null && hoveredSlot.f_40219_ < RobosurgeonBlockEntity.TOTAL_SLOTS) {
                if (hoveredSlot.m_6657_()) {
                    ItemStack stack = hoveredSlot.m_7993_();
                    if (stack.m_41782_() && stack.m_41783_().m_128471_("cyberware_ghost")) {
                        A_PacketHandler.INSTANCE.sendToServer((Object)new SurgeryGhostTogglePacket(((RobosurgeonMenu)this.f_97732_).blockEntity.m_58899_(), hoveredSlot.f_40219_));
                        hoveredSlot.m_5852_(ItemStack.f_41583_);
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                        return true;
                    }
                } else {
                    A_PacketHandler.INSTANCE.sendToServer((Object)new SurgeryGhostTogglePacket(((RobosurgeonMenu)this.f_97732_).blockEntity.m_58899_(), hoveredSlot.f_40219_));
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                    return true;
                }
            }
        }
        if (pButton == 0) {
            if (this.selectedPart != BodyPart.NONE && this.selectedMarker == null) {
                int modelCenterX = (int)((float)(this.f_97735_ + 88) + this.currentOffsetX);
                int modelCenterY = (int)((float)(this.f_97736_ + 131 - 15) + this.currentOffsetY);
                if (this.selectedPart == BodyPart.INTERNAL) {
                    modelCenterX -= 48;
                    modelCenterY += 26;
                }
                float radRot = (float)Math.toRadians(this.viewRotation);
                float sin = (float)Math.sin(radRot);
                float cos = (float)Math.cos(radRot);
                float scaleFactor = this.currentScale * 0.065f;
                for (TargetMarker marker : this.selectedPart.markers) {
                    float modelX = marker.modelX();
                    float modelY = marker.modelY();
                    float modelZ = marker.modelZ();
                    float screenOffsetX = modelX * cos - modelZ * sin;
                    float screenOffsetY = modelY;
                    int markerX = modelCenterX + (int)(screenOffsetX * scaleFactor) - 8;
                    int markerY = modelCenterY - (int)(screenOffsetY * scaleFactor) - 8;
                    if (!(pMouseX >= (double)markerX) || !(pMouseX < (double)(markerX + 16)) || !(pMouseY >= (double)markerY) || !(pMouseY < (double)(markerY + 16))) continue;
                    this.selectedMarker = marker;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.2f));
                    return true;
                }
            }
            if (this.selectedPart == BodyPart.NONE) {
                int x = (this.f_96543_ - this.f_97726_) / 2;
                int y = (this.f_96544_ - this.f_97727_) / 2;
                int subBaseX = x + 40;
                int subBaseY = y + 131 + 11;
                int boxWidth = 37;
                int boxHeight = 37;
                int boxOffsetY = -30;
                int boxCenterY = subBaseY - boxHeight / 2 + boxOffsetY;
                double minX = (double)subBaseX - (double)boxWidth / 2.0;
                double maxX = (double)subBaseX + (double)boxWidth / 2.0;
                double minY = (double)boxCenterY - (double)boxHeight / 2.0;
                double maxY = (double)boxCenterY + (double)boxHeight / 2.0;
                if (pMouseX >= minX && pMouseX <= maxX && pMouseY >= minY && pMouseY <= maxY) {
                    this.selectedPart = BodyPart.INTERNAL;
                    this.hideName = true;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                    return true;
                }
            }
            Slot slot = this.getSlotUnderMouse();
            if (((RobosurgeonMenu)this.f_97732_).m_142621_().m_41619_() && slot == null) {
                boolean inModelArea;
                boolean bl = inModelArea = pMouseX >= (double)this.f_97735_ && pMouseX < (double)(this.f_97735_ + this.f_97726_) && pMouseY >= (double)this.f_97736_ && pMouseY < (double)(this.f_97736_ + 131);
                if (inModelArea) {
                    this.potentialDrag = true;
                    this.dragStartX = pMouseX;
                    return true;
                }
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.updateSlotPositions();
        if (this.potentialDrag && pButton == 0) {
            if (!this.isDraggingModel) {
                this.isDraggingModel = true;
                this.rotationStart = this.viewRotation;
            }
            this.viewRotation = this.rotationStart + (float)(pMouseX - this.dragStartX);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.updateSlotPositions();
        if (pButton != 0) {
            return super.m_6348_(pMouseX, pMouseY, pButton);
        }
        if (this.isDraggingModel) {
            this.isDraggingModel = false;
            this.potentialDrag = false;
            return true;
        }
        if (this.potentialDrag) {
            boolean partClicked = false;
            if (this.selectedPart == BodyPart.NONE) {
                int entityX = this.f_97735_ + 88;
                int entityY = this.f_97736_ + 131 - 15;
                for (BodyPart part : BodyPart.values()) {
                    if (part == BodyPart.NONE) continue;
                    double minX = (double)(entityX + part.hitX) - (double)part.hitW / 2.0;
                    double maxX = (double)(entityX + part.hitX) + (double)part.hitW / 2.0;
                    double minY = (double)(entityY + part.hitY) - (double)part.hitH / 2.0;
                    double maxY = (double)(entityY + part.hitY) + (double)part.hitH / 2.0;
                    if (!(pMouseX >= minX) || !(pMouseX <= maxX) || !(pMouseY >= minY) || !(pMouseY <= maxY)) continue;
                    this.selectedPart = part;
                    this.hideName = true;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                    partClicked = true;
                    break;
                }
            }
            if (!partClicked && this.selectedPart != BodyPart.NONE) {
                this.selectedPart = BodyPart.NONE;
                this.selectedMarker = null;
                this.hideName = false;
            }
            this.potentialDrag = false;
            return true;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int uiWidth;
        int slotCount;
        float scaleFactor;
        float cos;
        float sin;
        float radRot;
        int modelCenterY;
        int modelCenterX;
        this.updateSlotPositions();
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        int maxTolerance = 100;
        SurgeryAlert alert = SurgeryAnalyzer.check((List<Slot>)((RobosurgeonMenu)this.f_97732_).f_38839_, maxTolerance);
        if (alert != null) {
            int iconX = this.f_97735_ + 155;
            int iconY = this.f_97736_ + 20;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ALERT_ICON);
            RenderSystem.enableBlend();
            pGuiGraphics.m_280163_(ALERT_ICON, iconX, iconY, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.disableBlend();
            if (pMouseX >= iconX && pMouseX < iconX + 16 && pMouseY >= iconY && pMouseY < iconY + 16) {
                pGuiGraphics.m_280557_(this.f_96547_, alert.message(), pMouseX, pMouseY);
            }
        }
        if (this.selectedPart != BodyPart.NONE && this.selectedMarker == null) {
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            modelCenterX = (int)((float)(this.f_97735_ + 88) + this.currentOffsetX);
            modelCenterY = (int)((float)(this.f_97736_ + 131 - 15) + this.currentOffsetY);
            if (this.selectedPart == BodyPart.INTERNAL) {
                modelCenterX -= 48;
                modelCenterY += 26;
            }
            radRot = (float)Math.toRadians(this.viewRotation);
            sin = (float)Math.sin(radRot);
            cos = (float)Math.cos(radRot);
            scaleFactor = this.currentScale * 0.065f;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            for (TargetMarker marker : this.selectedPart.markers) {
                float modelX = marker.modelX();
                float modelY = marker.modelY();
                float modelZ = marker.modelZ();
                float screenOffsetX = modelX * cos - modelZ * sin;
                float screenOffsetY = modelY;
                int markerX = modelCenterX + (int)(screenOffsetX * scaleFactor) - 8;
                int markerY = modelCenterY - (int)(screenOffsetY * scaleFactor) - 8;
                pGuiGraphics.m_280163_(MARKER_TEXTURE, markerX, markerY, 0.0f, 0.0f, 16, 16, 16, 16);
                if (pMouseX < markerX || pMouseX >= markerX + 16 || pMouseY < markerY || pMouseY >= markerY + 16) continue;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                pGuiGraphics.m_280557_(this.f_96547_, marker.name(), pMouseX, pMouseY);
                pGuiGraphics.m_280509_(markerX, markerY, markerX + 16, markerY + 16, 0x50FFFFFF);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            pGuiGraphics.m_280168_().m_85849_();
        }
        if (this.selectedMarker != null) {
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            slotCount = this.selectedMarker.relatedSlots().length;
            uiWidth = 18 * slotCount + 2 * (slotCount - 1);
            int uiX = this.f_97735_ + (this.f_97726_ - uiWidth) / 2;
            int installedY = this.f_97736_ + 80;
            int stagingY = this.f_97736_ + 105;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            for (int i = 0; i < slotCount; ++i) {
                int slotX = uiX + i * 20;
                pGuiGraphics.m_280163_(BLUE_SLOT_TEXTURE, slotX - 1, stagingY - 1, 0.0f, 0.0f, 18, 18, 18, 18);
                pGuiGraphics.m_280163_(RED_SLOT_TEXTURE, slotX - 1, installedY - 1, 0.0f, 0.0f, 18, 18, 18, 18);
            }
            RenderSystem.disableBlend();
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(cyberware -> {
                    ItemStackHandler installed = cyberware.getInstalledCyberware();
                    for (int i = 0; i < slotCount; ++i) {
                        int slotId = this.selectedMarker.relatedSlots()[i];
                        int itemX = uiX + i * 20;
                        if (slotId >= installed.getSlots()) continue;
                        ItemStack installedStack = installed.getStackInSlot(slotId);
                        pGuiGraphics.m_280480_(installedStack, itemX, installedY);
                        pGuiGraphics.m_280370_(this.f_96547_, installedStack, itemX, installedY);
                        if (!((RobosurgeonMenu)this.f_97732_).m_38853_(slotId).m_7993_().m_41619_() || installedStack.m_41619_()) continue;
                        pGuiGraphics.m_280168_().m_85836_();
                        pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 150.0f);
                        pGuiGraphics.m_280480_(installedStack, itemX, stagingY);
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        pGuiGraphics.m_280509_(itemX, stagingY, itemX + 16, stagingY + 16, Integer.MIN_VALUE);
                        RenderSystem.disableBlend();
                        pGuiGraphics.m_280168_().m_85849_();
                    }
                });
            }
        }
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
        if (this.selectedPart != BodyPart.NONE && this.selectedMarker == null) {
            modelCenterX = (int)((float)(this.f_97735_ + 88) + this.currentOffsetX);
            modelCenterY = (int)((float)(this.f_97736_ + 131 - 15) + this.currentOffsetY);
            radRot = (float)Math.toRadians(this.viewRotation);
            sin = (float)Math.sin(radRot);
            cos = (float)Math.cos(radRot);
            scaleFactor = this.currentScale * 0.065f;
            for (TargetMarker marker : this.selectedPart.markers) {
                float screenOffsetX = marker.modelX() * cos - marker.modelZ() * sin;
                float screenOffsetY = marker.modelY();
                int markerX = modelCenterX + (int)(screenOffsetX * scaleFactor) - 8;
                int markerY = modelCenterY - (int)(screenOffsetY * scaleFactor) - 8;
                if (pMouseX < markerX || pMouseX >= markerX + 16 || pMouseY < markerY || pMouseY >= markerY + 16) continue;
                pGuiGraphics.m_280557_(this.f_96547_, marker.name(), pMouseX, pMouseY);
            }
        }
        if (this.selectedMarker != null) {
            slotCount = this.selectedMarker.relatedSlots().length;
            uiWidth = 18 * slotCount + 2 * (slotCount - 1);
            int uiX = this.f_97735_ + (this.f_97726_ - uiWidth) / 2;
            int installedY = this.f_97736_ + 80;
            int stagingY = this.f_97736_ + 105;
            this.renderGhostConflict(pGuiGraphics, slotCount, uiX, stagingY, installedY);
            for (int i = 0; i < slotCount; ++i) {
                ItemStack stack;
                int slotX = uiX + i * 20;
                int targetSlotId = this.selectedMarker.relatedSlots()[i];
                if (pMouseX >= slotX && pMouseX < slotX + 18 && pMouseY >= stagingY && pMouseY < stagingY + 18 && targetSlotId < RobosurgeonBlockEntity.TOTAL_SLOTS && !(stack = ((RobosurgeonMenu)this.f_97732_).m_38853_(targetSlotId).m_7993_()).m_41619_()) {
                    pGuiGraphics.m_280153_(this.f_96547_, stack, pMouseX, pMouseY);
                }
                if (pMouseX < slotX || pMouseX >= slotX + 18 || pMouseY < installedY || pMouseY >= installedY + 18 || this.f_96541_ == null || this.f_96541_.f_91074_ == null) continue;
                this.f_96541_.f_91074_.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(cyberware -> {
                    ItemStack stack;
                    ItemStackHandler installed = cyberware.getInstalledCyberware();
                    if (targetSlotId < installed.getSlots() && !(stack = installed.getStackInSlot(targetSlotId)).m_41619_()) {
                        pGuiGraphics.m_280153_(this.f_96547_, stack, pMouseX, pMouseY);
                    }
                });
            }
        }
    }

    protected void m_7286_(GuiGraphics g, float partial, int mouseX, int mouseY) {
        boolean isMainZoomed;
        float currentRotation;
        long elapsed;
        LazyOptional cap;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        g.m_280218_(TEXTURE, x, y, 0, 0, 175, 131);
        g.m_280218_(TEXTURE, x, y + 131, 0, 131, 175, 91);
        int maxEssence = 100;
        int currentEssence = 0;
        if (this.f_96541_.f_91074_ != null && (cap = this.f_96541_.f_91074_.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY)).isPresent()) {
            currentEssence = ((CyberwareUserData)cap.resolve().get()).getTolerance();
        }
        int projectedCost = 0;
        for (int i = 0; i < RobosurgeonBlockEntity.TOTAL_SLOTS && i < ((RobosurgeonMenu)this.f_97732_).f_38839_.size(); ++i) {
            Item item;
            ItemStack stack = ((RobosurgeonMenu)this.f_97732_).m_38853_(i).m_7993_();
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ICyberware)) continue;
            ICyberware cw = (ICyberware)item;
            projectedCost += cw.getEssenceCost(stack) * stack.m_41613_();
        }
        int projectedEssence = maxEssence - projectedCost;
        int barX = x + 5;
        int barY = y + 4;
        int barW = 8;
        int barH = 48;
        g.m_280411_(TEXTURE, barX, barY, barW, barH, 211.0f, 61.0f, barW, barH, 256, 256);
        this.drawEssenceBar(g, projectedEssence, maxEssence, barX, barY, barW, barH);
        if (currentEssence > projectedEssence) {
            float time = (float)(System.currentTimeMillis() % 1000L) / 1000.0f;
            float alpha = 0.45f + 0.25f * (float)Math.sin((double)(time * 2.0f) * Math.PI);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.drawEssenceBar(g, currentEssence, maxEssence, barX, barY, barW, barH);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        float tScale = this.selectedPart == BodyPart.NONE ? 45.0f : this.selectedPart.zoomScale;
        float tOffX = this.selectedPart == BodyPart.NONE ? 0.0f : (float)this.selectedPart.zoomOffsetX;
        float tOffY = this.selectedPart == BodyPart.NONE ? 0.0f : (float)this.selectedPart.zoomOffsetY;
        float spd = 0.05f;
        this.currentScale += (tScale - this.currentScale) * spd;
        this.currentOffsetX += (tOffX - this.currentOffsetX) * spd;
        this.currentOffsetY += (tOffY - this.currentOffsetY) * spd;
        int baseX = x + 88;
        int baseY = y + 131 - 15;
        int drawX = (int)((float)baseX + this.currentOffsetX);
        int drawY = (int)((float)baseY + this.currentOffsetY);
        int drawScale = (int)this.currentScale;
        int scaleBoost = 5;
        int raiseAmount = 0;
        if (!this.hideName && this.f_96541_.f_91074_ != null) {
            String name = "_" + this.f_96541_.f_91074_.m_7755_().getString().toUpperCase();
            int w = this.f_96547_.m_92895_(name);
            g.m_280056_(this.f_96547_, name, drawX - w / 2, drawY, 65535, true);
        }
        boolean isAnimating = (float)(elapsed = System.currentTimeMillis() - this.startTime) < 2000.0f;
        float ease = 0.0f;
        if (isAnimating) {
            float r = Math.min((float)elapsed / 2000.0f, 1.0f);
            ease = 1.0f - (float)Math.pow(1.0f - r, 3.0);
            currentRotation = ease * 360.0f;
        } else {
            currentRotation = this.viewRotation;
            ease = 1.0f;
        }
        boolean isOverview = this.selectedPart == BodyPart.NONE;
        boolean isInternalZoomed = this.selectedPart == BodyPart.INTERNAL;
        boolean bl = isMainZoomed = !isOverview && !isInternalZoomed;
        if (this.internalPartsModel != null && !isMainZoomed) {
            int subScale;
            int subY;
            int subX;
            if (isInternalZoomed) {
                subX = drawX - 48;
                subY = drawY;
                subScale = drawScale;
            } else {
                subX = x + 40;
                subY = y + 131 + 11;
                subScale = 40;
            }
            if (isOverview) {
                int boxWidth = 37;
                int boxHeight = 37;
                int boxOffsetY = -34;
                int boxCenterX = subX;
                int boxCenterY = subY - boxHeight / 2 + boxOffsetY;
                int boxLeft = boxCenterX - boxWidth / 2;
                int boxRight = boxCenterX + boxWidth / 2;
                int boxTop = boxCenterY - boxHeight / 2;
                int boxBottom = boxCenterY + boxHeight / 2;
                int cyanColor = -16711681;
                int lineWidth = 1;
                g.m_280509_(boxLeft, boxTop, boxRight, boxTop + lineWidth, cyanColor);
                g.m_280509_(boxLeft, boxBottom, boxRight, boxBottom + lineWidth, cyanColor);
                g.m_280509_(boxLeft, boxTop, boxLeft + lineWidth, boxBottom, cyanColor);
                g.m_280509_(boxRight - lineWidth, boxTop, boxRight, boxBottom, cyanColor);
                int lineStartX = boxCenterX + 10;
                int lineUpHeight = 20;
                int lineStartY = boxTop;
                int cornerY = boxTop - lineUpHeight;
                int lineEndX = drawX;
                g.m_280509_(lineStartX, cornerY, lineStartX + lineWidth, lineStartY, cyanColor);
                g.m_280509_(lineStartX, cornerY, lineEndX, cornerY + lineWidth, cyanColor);
            }
            this.internalPartsModel.setVisibleLayer(0);
            RobosurgeonScreen.renderCustomModel(g, subX, subY, subScale, currentRotation, this.internalPartsModel);
            this.internalPartsModel.setVisibleLayer(1);
            RobosurgeonScreen.renderCustomModel(g, subX, subY, subScale, currentRotation, this.internalPartsModel);
            this.internalPartsModel.setVisibleLayer(2);
            RobosurgeonScreen.renderCustomModel(g, subX, subY, subScale, currentRotation, this.internalPartsModel);
        }
        int Pscale = 45 + scaleBoost;
        int Sscale = 42 + scaleBoost;
        int modelH = 115;
        int scan = (int)((float)modelH * ease);
        if (!isInternalZoomed) {
            double guiScale = this.f_96541_.m_91268_().m_85449_();
            if (!isAnimating) {
                if (this.dummySkeleton != null) {
                    scX = (int)((double)(x + 5) * guiScale);
                    int scY = (int)((double)(this.f_96544_ - (y + 131)) * guiScale);
                    int scW = (int)(165.0 * guiScale);
                    int scH = (int)(121.0 * guiScale);
                    float skeletonBaseSize = 42.0f;
                    float playerBaseSize = 45.0f;
                    float ratio = skeletonBaseSize / playerBaseSize;
                    int adjustedScale = (int)(this.currentScale * ratio) + scaleBoost;
                    RenderSystem.enableScissor((int)scX, (int)scY, (int)scW, (int)scH);
                    RobosurgeonScreen.renderEntityWithRotation(g, drawX, drawY - raiseAmount, adjustedScale, currentRotation, (LivingEntity)this.dummySkeleton);
                    RenderSystem.disableScissor();
                }
            } else {
                int ph;
                scX = (int)((double)(drawX - 50) * guiScale);
                int scW = (int)(100.0 * guiScale);
                int scFeet = (int)((double)(this.f_96544_ - drawY) * guiScale);
                if (this.f_96541_.f_91074_ != null && (ph = modelH - scan) > 0) {
                    RenderSystem.enableScissor((int)scX, (int)scFeet, (int)scW, (int)((int)((double)ph * guiScale)));
                    RobosurgeonScreen.renderEntityWithRotation(g, drawX, drawY - raiseAmount, Pscale, currentRotation, (LivingEntity)this.f_96541_.f_91074_);
                    RenderSystem.disableScissor();
                }
                if (this.dummySkeleton != null && scan > 0) {
                    int sy = scFeet + (int)((double)(modelH - scan) * guiScale);
                    RenderSystem.enableScissor((int)scX, (int)sy, (int)scW, (int)((int)((double)scan * guiScale)));
                    RobosurgeonScreen.renderEntityWithRotation(g, drawX, drawY - raiseAmount, Sscale, currentRotation, (LivingEntity)this.dummySkeleton);
                    RenderSystem.disableScissor();
                }
            }
        }
        if (ease > 0.0f && ease < 1.0f) {
            int scanY = drawY - modelH + scan;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_(0.0f, 0.0f, 60.0f);
            g.m_280218_(TEXTURE, drawX - 40, scanY, 176, 110, 80, 1);
            g.m_280168_().m_85849_();
        }
        RenderSystem.disableBlend();
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        LazyOptional cap;
        int maxTolerance = 100;
        if (Objects.requireNonNull(this.f_96541_).f_91074_ != null && (cap = this.f_96541_.f_91074_.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY)).isPresent()) {
            maxTolerance = ((CyberwareUserData)cap.resolve().get()).getMaxTolerance();
        }
        int currentCost = 0;
        for (int i = 0; i < RobosurgeonBlockEntity.TOTAL_SLOTS && i < ((RobosurgeonMenu)this.f_97732_).f_38839_.size(); ++i) {
            Item item;
            ItemStack stack = ((RobosurgeonMenu)this.f_97732_).m_38853_(i).m_7993_();
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ICyberware)) continue;
            ICyberware cw = (ICyberware)item;
            currentCost += cw.getEssenceCost(stack) * stack.m_41613_();
        }
        int val = maxTolerance - currentCost;
        int color = val < 30 ? 0xFF0000 : 65535;
        pGuiGraphics.m_280056_(this.f_96547_, val + " / " + maxTolerance, 18, 6, color, true);
    }

    private void updateSlotPositions() {
        for (int i = 0; i < RobosurgeonBlockEntity.TOTAL_SLOTS; ++i) {
            if (i >= ((RobosurgeonMenu)this.f_97732_).f_38839_.size()) continue;
            Slot slot = (Slot)((RobosurgeonMenu)this.f_97732_).f_38839_.get(i);
            slot.f_40220_ = 20000;
            slot.f_40221_ = 20000;
        }
        if (this.selectedMarker != null) {
            int slotCount = this.selectedMarker.relatedSlots().length;
            int uiWidth = 18 * slotCount + 2 * (slotCount - 1);
            int uiX = (this.f_96543_ - uiWidth) / 2;
            int stagingY = (this.f_96544_ - this.f_97727_) / 2 + 105;
            int relativeX = uiX - this.f_97735_;
            int relativeY = stagingY - this.f_97736_;
            int[] targetSlots = this.selectedMarker.relatedSlots();
            for (int i = 0; i < targetSlots.length; ++i) {
                int slotId = targetSlots[i];
                if (slotId >= ((RobosurgeonMenu)this.f_97732_).f_38839_.size()) continue;
                Slot slot = (Slot)((RobosurgeonMenu)this.f_97732_).f_38839_.get(slotId);
                slot.f_40220_ = relativeX + i * 20;
                slot.f_40221_ = relativeY;
            }
        }
    }

    private void renderGhostConflict(GuiGraphics g, int slotCount, int uiX, int stagingY, int installedY) {
        LazyOptional cap;
        ItemStack carriedStack = ((RobosurgeonMenu)this.f_97732_).m_142621_();
        if (carriedStack.m_41619_()) {
            return;
        }
        Item item = carriedStack.m_41720_();
        if (!(item instanceof ICyberware)) {
            return;
        }
        ICyberware carriedItem = (ICyberware)item;
        Slot hover = this.f_97734_;
        if (hover == null || hover.f_40219_ >= RobosurgeonBlockEntity.TOTAL_SLOTS) {
            return;
        }
        ItemStackHandler installedHandler = null;
        if (this.f_96541_.f_91074_ != null && (cap = this.f_96541_.f_91074_.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY)).isPresent()) {
            installedHandler = ((CyberwareUserData)cap.resolve().get()).getInstalledCyberware();
        }
        if (installedHandler == null) {
            return;
        }
        int[] related = this.selectedMarker.relatedSlots();
        boolean isHoveringTarget = false;
        for (int id : related) {
            if (id != hover.f_40219_) continue;
            isHoveringTarget = true;
            break;
        }
        if (!isHoveringTarget) {
            return;
        }
        for (int j = 0; j < slotCount; ++j) {
            int targetId = related[j];
            if (targetId == hover.f_40219_) continue;
            ItemStack otherStack = ((RobosurgeonMenu)this.f_97732_).m_38853_(targetId).m_7993_();
            if (otherStack.m_41619_()) {
                otherStack = installedHandler.getStackInSlot(targetId);
            }
            if (otherStack.m_41619_() || !carriedItem.isIncompatible(carriedStack, otherStack)) continue;
            int x2 = uiX + j * 20;
            boolean isBlue = !((RobosurgeonMenu)this.f_97732_).m_38853_(targetId).m_7993_().m_41619_();
            int y2 = isBlue ? stagingY : installedY;
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
            g.m_280509_(x2, y2, x2 + 18, y2 + 18, -2130771968);
            g.m_280637_(x2 - 1, y2 - 1, 20, 20, -65536);
            g.m_280056_(this.f_96547_, "!", x2 + 6, y2 + 4, -65536, true);
            g.m_280168_().m_85849_();
        }
    }

    private void drawEssenceBar(GuiGraphics g, int essence, int maxEssence, int x, int y, int w, int h) {
        int dangerThreshold = (int)((float)maxEssence * 0.25f);
        if (essence < 0) {
            essence = 0;
        }
        int redEssence = Math.min(essence, dangerThreshold);
        int blueEssence = Math.max(0, essence - dangerThreshold);
        int redHeight = (int)((float)h * ((float)redEssence / (float)maxEssence));
        int blueHeight = (int)((float)h * ((float)blueEssence / (float)maxEssence));
        if (redHeight > 0) {
            int redDrawY = y + (h - redHeight);
            int redTextureV = 61 + (48 - redHeight);
            g.m_280411_(TEXTURE, x, redDrawY, w, redHeight, 220.0f, (float)redTextureV, w, redHeight, 256, 256);
        }
        if (blueHeight > 0) {
            int blueDrawY = y + (h - redHeight - blueHeight);
            int totalFilledHeight = redHeight + blueHeight;
            int blueTextureV = 61 + (48 - totalFilledHeight);
            g.m_280411_(TEXTURE, x, blueDrawY, w, blueHeight, 176.0f, (float)blueTextureV, w, blueHeight, 256, 256);
        }
    }

    private static enum BodyPart {
        HEAD(0, -80, 32, 32, 0, 160, 120.0f, List.of(new TargetMarker((Component)Component.m_237113_((String)"Left Eye"), 2.0f, 25.5f, -3.4f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_EYES)), new TargetMarker((Component)Component.m_237113_((String)"Right Eye"), -2.0f, 25.5f, -3.4f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_EYES)), new TargetMarker((Component)Component.m_237113_((String)"Brain"), -0.13f, 27.56f, 1.52f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_BRAIN)))),
        TORSO(0, -54, 26, 32, 0, 120, 120.0f, List.of(new TargetMarker((Component)Component.m_237113_((String)"Heart"), 0.0f, 21.0f, -0.5f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_HEART)), new TargetMarker((Component)Component.m_237113_((String)"Left Lung"), 2.3f, 20.0f, 0.0f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_LUNGS)), new TargetMarker((Component)Component.m_237113_((String)"Stomach"), 0.0f, 16.0f, -1.5f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_STOMACH)), new TargetMarker((Component)Component.m_237113_((String)"Right Lung"), -2.3f, 20.0f, 0.0f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_LUNGS)))),
        ARM_LEFT(18, -54, 12, 34, -60, 120, 120.0f, List.of(new TargetMarker((Component)Component.m_237113_((String)"Left Arm"), 4.7f, 21.0f, 0.0f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_ARMS)), new TargetMarker((Component)Component.m_237113_((String)"Left Hand"), 5.8f, 14.0f, 0.0f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_HANDS)))),
        ARM_RIGHT(-18, -54, 12, 34, 60, 120, 120.0f, List.of(new TargetMarker((Component)Component.m_237113_((String)"Right Arm"), -4.7f, 21.0f, 0.0f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_ARMS)), new TargetMarker((Component)Component.m_237113_((String)"Right Hand"), -5.8f, 14.0f, 0.0f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_HANDS)))),
        LEG_LEFT(5, -19, 12, 38, -50, 20, 120.0f, List.of(new TargetMarker((Component)Component.m_237113_((String)"Left Leg"), 2.0f, 10.0f, 0.0f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_LEGS)), new TargetMarker((Component)Component.m_237113_((String)"Left Boot"), 2.1f, 1.9f, 0.0f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_BOOTS)))),
        LEG_RIGHT(-5, -19, 12, 38, 50, 20, 120.0f, List.of(new TargetMarker((Component)Component.m_237113_((String)"Right Leg"), -2.0f, 10.0f, 0.0f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_LEGS)), new TargetMarker((Component)Component.m_237113_((String)"Right Boot"), -2.1f, 1.9f, 0.0f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_BOOTS)))),
        INTERNAL(0, 0, 40, 50, 48, 130, 150.0f, List.of(new TargetMarker((Component)Component.m_237113_((String)"Skin"), -3.0f, 24.6f, -5.5f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_SKIN)), new TargetMarker((Component)Component.m_237113_((String)"Muscle"), 0.0f, 22.7f, -5.5f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_MUSCLE)), new TargetMarker((Component)Component.m_237113_((String)"Bone"), 3.0f, 20.8f, -5.5f, RobosurgeonScreen.slots(RobosurgeonBlockEntity.SLOT_BONES)))),
        NONE(0, 0, 0, 0, 0, 0, 45.0f, List.of());

        final int hitX;
        final int hitY;
        final int hitW;
        final int hitH;
        final int zoomOffsetX;
        final int zoomOffsetY;
        final float zoomScale;
        final List<TargetMarker> markers;

        private BodyPart(int hitX, int hitY, int hitW, int hitH, int zoomOffsetX, int zoomOffsetY, float zoomScale, List<TargetMarker> markers) {
            this.hitX = hitX;
            this.hitY = hitY;
            this.hitW = hitW;
            this.hitH = hitH;
            this.zoomOffsetX = zoomOffsetX;
            this.zoomOffsetY = zoomOffsetY;
            this.zoomScale = zoomScale;
            this.markers = markers;
        }
    }

    public record TargetMarker(Component name, float modelX, float modelY, float modelZ, int[] relatedSlots) {
    }
}

