/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Client.Upgrades.CyberEye;

import com.Maxwell.cyber_ware_port.Common.Capability.CyberwareCapabilityProvider;
import com.Maxwell.cyber_ware_port.Common.Item.Base.ICyberware;
import com.Maxwell.cyber_ware_port.Init.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber(modid="cyber_ware_port", value={Dist.CLIENT})
public class EyeWareEvents {
    private static boolean isFeatureActive(Player player, Item item) {
        return player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).map(data -> {
            ItemStackHandler handler = data.getInstalledCyberware();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ICyberware cw;
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.m_41720_() != item) continue;
                if (item instanceof ICyberware && !(cw = (ICyberware)item).isActive(stack)) {
                    return false;
                }
                return data.getEnergyStored() > 0;
            }
            return false;
        }).orElse(false);
    }

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        if (event.getCamera().m_167685_() == FogType.WATER) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            if (EyeWareEvents.isFeatureActive((Player)player, (Item)ModItems.LIQUID_REFRACTION.get())) {
                event.setNearPlaneDistance(-8.0f);
                event.setFarPlaneDistance(200.0f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onComputeFov(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        if (EyeWareEvents.isFeatureActive(player, (Item)ModItems.DISTANCE_ENHANCER.get())) {
            event.setNewFovModifier(event.getNewFovModifier() * 0.5f);
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (EyeWareEvents.isFeatureActive((Player)player, (Item)ModItems.TARGETING_OVERLAY.get())) {
            PoseStack poseStack = event.getPoseStack();
            Vec3 cameraPos = event.getCamera().m_90583_();
            double range = 32.0;
            for (Entity e : mc.f_91073_.m_104735_()) {
                if (!(e instanceof LivingEntity) || e == player || !e.m_6084_() || !(e.m_20280_((Entity)player) < range * range)) continue;
                EyeWareEvents.renderEntityOutline(poseStack, e, cameraPos);
            }
        }
    }

    private static void renderEntityOutline(PoseStack poseStack, Entity entity, Vec3 cameraPos) {
        poseStack.m_85836_();
        poseStack.m_85837_(entity.m_20185_() - cameraPos.f_82479_, entity.m_20186_() - cameraPos.f_82480_, entity.m_20189_() - cameraPos.f_82481_);
        AABB aabb = entity.m_20191_().m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_());
        VertexConsumer consumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)aabb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        poseStack.m_85849_();
    }
}

