/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Capability;

import com.Maxwell.cyber_ware_port.Common.Block.Robosurgeon.RobosurgeonBlockEntity;
import com.Maxwell.cyber_ware_port.Common.Capability.CyberwareCapabilityProvider;
import com.Maxwell.cyber_ware_port.Common.Capability.CyberwareUserData;
import com.Maxwell.cyber_ware_port.Common.Item.Base.BodyPartType;
import com.Maxwell.cyber_ware_port.Common.Item.Base.ICyberware;
import com.Maxwell.cyber_ware_port.Config.CyberwareConfig;
import com.Maxwell.cyber_ware_port.Init.ModBlocks;
import com.Maxwell.cyber_ware_port.Init.ModItems;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber(modid="cyber_ware_port")
public class CapabilityEvents {
    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).isPresent()) {
            event.addCapability(new ResourceLocation("cyber_ware_port", "cyberware_data"), (ICapabilityProvider)new CyberwareCapabilityProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CapabilityEvents.syncData(serverPlayer);
            serverPlayer.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(cap -> {
                if (!cap.isInitialized()) {
                    cap.fillWithHumanParts();
                }
                cap.syncToClient(serverPlayer);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CapabilityEvents.syncData(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player;
        if (!event.getEntity().m_9236_().f_46443_ && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                data.recalculateCapacity(serverPlayer);
                data.syncToClient(serverPlayer);
                CapabilityEvents.syncData(serverPlayer);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player newPlayer = event.getEntity();
        original.reviveCaps();
        if (event.isWasDeath()) {
            original.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(oldData -> newPlayer.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(newData -> {
                newData.copyFrom((CyberwareUserData)oldData);
                newData.setRespawnGracePeriod(12000);
            }));
        }
        try {
            if (event.isWasDeath()) {
                if (((Boolean)CyberwareConfig.KEEP_CYBERWARE_ON_DEATH.get()).booleanValue()) {
                    original.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(oldData -> newPlayer.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(newData -> newData.copyFrom((CyberwareUserData)oldData)));
                } else {
                    DamageSource source = original.m_21225_();
                    newPlayer.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(CyberwareUserData::setInitialized);
                }
                newPlayer.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(CapabilityEvents::ensureEssentialParts);
            } else {
                original.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(oldData -> newPlayer.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(newData -> newData.copyFrom((CyberwareUserData)oldData)));
            }
        }
        finally {
            original.invalidateCaps();
        }
        if (newPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)newPlayer;
            serverPlayer.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                data.recalculateCapacity(serverPlayer);
                data.syncToClient(serverPlayer);
            });
        }
    }

    private static void ensureEssentialParts(CyberwareUserData userData) {
        ItemStackHandler handler = userData.getInstalledCyberware();
        if (handler.getStackInSlot(RobosurgeonBlockEntity.SLOT_BRAIN).m_41619_()) {
            handler.setStackInSlot(RobosurgeonBlockEntity.SLOT_BRAIN, new ItemStack((ItemLike)ModItems.HUMAN_BRAIN.get()));
        }
        if (handler.getStackInSlot(RobosurgeonBlockEntity.SLOT_HEART).m_41619_()) {
            handler.setStackInSlot(RobosurgeonBlockEntity.SLOT_HEART, new ItemStack((ItemLike)ModItems.HUMAN_HEART.get()));
        }
        if (handler.getStackInSlot(RobosurgeonBlockEntity.SLOT_MUSCLE).m_41619_()) {
            handler.setStackInSlot(RobosurgeonBlockEntity.SLOT_MUSCLE, new ItemStack((ItemLike)ModItems.HUMAN_MUSCLE.get()));
        }
        if (handler.getStackInSlot(RobosurgeonBlockEntity.SLOT_BONES).m_41619_()) {
            handler.setStackInSlot(RobosurgeonBlockEntity.SLOT_BONES, new ItemStack((ItemLike)ModItems.HUMAN_BONE.get()));
        }
    }

    private static void syncData(ServerPlayer player) {
        player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> data.syncToClient(player));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side.isServer() && event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(userData -> {
                userData.tick(serverPlayer);
                if (serverPlayer.f_19797_ % 20 == 0) {
                    userData.syncToClient(serverPlayer);
                }
            });
        }
    }

    private static boolean isHandFunctional(Player player, InteractionHand hand) {
        AtomicBoolean isFunctional = new AtomicBoolean(true);
        player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
            int slotIndex;
            ItemStackHandler handler = data.getInstalledCyberware();
            HumanoidArm mainArm = player.m_5737_();
            boolean isRightHand = hand == InteractionHand.MAIN_HAND ? mainArm == HumanoidArm.RIGHT : mainArm == HumanoidArm.LEFT;
            int n = slotIndex = isRightHand ? RobosurgeonBlockEntity.SLOT_ARMS : RobosurgeonBlockEntity.SLOT_ARMS + 1;
            if (handler.getStackInSlot(slotIndex).m_41619_()) {
                isFunctional.set(false);
            }
        });
        return isFunctional.get();
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!CapabilityEvents.isHandFunctional(event.getEntity(), InteractionHand.MAIN_HAND)) {
            event.setNewSpeed(0.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (state.m_60713_((Block)ModBlocks.ROBO_SURGEON.get()) || state.m_60713_((Block)ModBlocks.SURGERY_CHAMBER.get())) {
            return;
        }
        if (!CapabilityEvents.isHandFunctional(event.getEntity(), InteractionHand.MAIN_HAND)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!CapabilityEvents.isHandFunctional(event.getEntity(), event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (state.m_60713_((Block)ModBlocks.ROBO_SURGEON.get()) || state.m_60713_((Block)ModBlocks.SURGERY_CHAMBER.get())) {
            return;
        }
        if (!CapabilityEvents.isHandFunctional(event.getEntity(), event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!CapabilityEvents.isHandFunctional(event.getEntity(), event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakBlock(PlayerEvent.BreakSpeed event) {
        if (!CapabilityEvents.isHandFunctional(event.getEntity(), InteractionHand.MAIN_HAND)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                ItemStackHandler handler = data.getInstalledCyberware();
                boolean hasSkin = false;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ICyberware cw;
                    BodyPartType type;
                    Item patt10837$temp;
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.m_41619_() || !((patt10837$temp = stack.m_41720_()) instanceof ICyberware) || (type = (cw = (ICyberware)patt10837$temp).getBodyPartType(stack)) != BodyPartType.SKIN) continue;
                    hasSkin = true;
                }
                float multiplier = 1.0f;
                if (!hasSkin) {
                    multiplier += 0.5f;
                }
                if (multiplier > 1.0f) {
                    event.setAmount(event.getAmount() * multiplier);
                }
            });
        }
    }
}

