/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Entity;

import com.Maxwell.cyber_ware_port.Init.ModEntities;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cyber_ware_port", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MobSpawnerEvents {
    private static final int SPAWN_COOLDOWN = 600;
    private static long lastSpawnTime = 0L;
    private static final Random RANDOM = new Random();
    private static final List<Supplier<? extends EntityType<?>>> OVERWORLD_MOBS = List.of(ModEntities.CYBER_ZOMBIE, ModEntities.CYBER_SKELETON, ModEntities.CYBER_CREEPER);

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        Supplier<EntityType<?>> mobSupplier;
        EntityType<?> mobToSpawn;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = event.getServer();
        long currentTime = server.m_129921_();
        if (currentTime < lastSpawnTime + 600L) {
            return;
        }
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        if (overworld == null || !overworld.m_46462_()) {
            return;
        }
        if (overworld.m_6907_().isEmpty()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)overworld.m_6907_().get(RANDOM.nextInt(overworld.m_6907_().size()));
        if (MobSpawnerEvents.trySpawnMob(overworld, player, mobToSpawn = (mobSupplier = OVERWORLD_MOBS.get(RANDOM.nextInt(OVERWORLD_MOBS.size()))).get())) {
            lastSpawnTime = currentTime;
        }
    }

    private static boolean trySpawnMob(ServerLevel level, ServerPlayer player, EntityType<?> mobToSpawn) {
        for (int i = 0; i < 10; ++i) {
            Mob mob;
            int x = (int)player.m_20185_() + RANDOM.nextInt(48) - 24;
            int z = (int)player.m_20189_() + RANDOM.nextInt(48) - 24;
            int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
            BlockPos spawnPos = new BlockPos(x, y, z);
            if (!(player.m_20275_((double)x, (double)y, (double)z) > 576.0) || !level.m_45772_(mobToSpawn.m_20585_((double)x, (double)y, (double)z)) || (mob = (Mob)mobToSpawn.m_20615_((Level)level)) == null) continue;
            mob.m_6034_((double)x + 0.5, (double)y, (double)z + 0.5);
            level.m_7967_((Entity)mob);
            return true;
        }
        return false;
    }
}

