/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Item.CyberWare.Cranium;

import com.Maxwell.cyber_ware_port.Common.Block.Robosurgeon.RobosurgeonBlockEntity;
import com.Maxwell.cyber_ware_port.Common.Capability.CyberwareCapabilityProvider;
import com.Maxwell.cyber_ware_port.Common.Item.Base.CyberwareItem;
import com.Maxwell.cyber_ware_port.Common.Item.Base.ICyberware;
import com.Maxwell.cyber_ware_port.Init.ModEntities;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;

public class CranialBroadcasterItem
extends CyberwareItem {
    private static final List<Supplier<? extends EntityType<? extends Monster>>> CYBER_MOBS = Arrays.asList(ModEntities.CYBER_ZOMBIE, ModEntities.CYBER_SKELETON, ModEntities.CYBER_CREEPER);

    public CranialBroadcasterItem() {
        super(new CyberwareItem.Builder(5, RobosurgeonBlockEntity.SLOT_BRAIN).maxInstall(1).energy(2, 0, 0, ICyberware.StackingRule.STATIC));
    }

    @Override
    public int getEnergyConsumption(ItemStack stack) {
        return this.isActive(stack) ? 2 : 0;
    }

    @Override
    public boolean canToggle(ItemStack stack) {
        return true;
    }

    @Override
    public void onPlayerTick(TickEvent.PlayerTickEvent event, ItemStack stack, LivingEntity wearer) {
        if (wearer.m_9236_().m_46467_() % 20L != 0L) {
            return;
        }
        if (!(wearer instanceof Player)) {
            return;
        }
        Player player = (Player)wearer;
        player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
            int spawnCost;
            if (player.m_217043_().m_188503_(20) == 0 && data.extractEnergy(spawnCost = 200, false) == spawnCost) {
                this.spawnRandomCyberMob(player);
            }
        });
    }

    private void spawnRandomCyberMob(Player player) {
        Monster mob;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double angle = player.m_217043_().m_188500_() * Math.PI * 2.0;
        double distance = 20.0 + player.m_217043_().m_188500_() * 20.0;
        int x = Mth.m_14107_((double)(player.m_20185_() + Math.cos(angle) * distance));
        int z = Mth.m_14107_((double)(player.m_20189_() + Math.sin(angle) * distance));
        int y = serverLevel.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        BlockPos spawnPos = new BlockPos(x, y, z);
        EntityType<? extends Monster> mobType = CYBER_MOBS.get(player.m_217043_().m_188503_(CYBER_MOBS.size())).get();
        if (NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)serverLevel, (BlockPos)spawnPos, mobType) && (mob = (Monster)mobType.m_20615_((Level)serverLevel)) != null) {
            mob.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, player.m_217043_().m_188501_() * 360.0f, 0.0f);
            if (mob.m_5545_((LevelAccessor)serverLevel, MobSpawnType.EVENT)) {
                serverLevel.m_7967_((Entity)mob);
            }
        }
    }
}

