/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Item.CyberWare;

import com.Maxwell.cyber_ware_port.Common.Capability.CyberwareCapabilityProvider;
import com.Maxwell.cyber_ware_port.Common.Item.Base.ICyberware;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber(modid="cyber_ware_port")
public class ModCyberwareEvents {
    private static void dispatch(LivingEntity entity, BiConsumer<ICyberware, ItemStack> action) {
        if (entity == null) {
            return;
        }
        entity.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
            ItemStackHandler handler = data.getInstalledCyberware();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ICyberware cw;
                Item patt1494$temp;
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.m_41619_() || !((patt1494$temp = stack.m_41720_()) instanceof ICyberware) || !(cw = (ICyberware)patt1494$temp).isActive(stack)) continue;
                action.accept(cw, stack);
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isClient() || event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                data.tick(sp);
            }
        });
        ModCyberwareEvents.dispatch((LivingEntity)player, (cw, stack) -> cw.onPlayerTick(event, (ItemStack)stack, (LivingEntity)player));
    }

    @SubscribeEvent
    public static void onEntityTeleport(EntityTeleportEvent event) {
        double targetX = event.getTargetX();
        double targetY = event.getTargetY();
        double targetZ = event.getTargetZ();
        double range = 16.0;
        AABB searchArea = new AABB(targetX - range, targetY - range, targetZ - range, targetX + range, targetY + range, targetZ + range);
        List players = event.getEntity().m_9236_().m_45976_(Player.class, searchArea);
        for (Player player : players) {
            ModCyberwareEvents.dispatch((LivingEntity)player, (cw, stack) -> cw.onEntityTeleport(event, (ItemStack)stack, (LivingEntity)player));
            if (!event.isCanceled()) continue;
            return;
        }
    }

    @SubscribeEvent
    public static void onItemUseTick(LivingEntityUseItemEvent.Tick event) {
        ModCyberwareEvents.dispatch(event.getEntity(), (cw, stack) -> cw.onItemUseTick(event, (ItemStack)stack, event.getEntity()));
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ModCyberwareEvents.dispatch((LivingEntity)player, (cw, stack) -> {
                if (!event.isCanceled()) {
                    cw.onLivingAttack(event, (ItemStack)stack, (LivingEntity)player);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ModCyberwareEvents.dispatch((LivingEntity)event.getEntity(), (cw, stack) -> cw.onLeftClickBlock(event, (ItemStack)stack, (LivingEntity)event.getEntity()));
    }

    @SubscribeEvent
    public static void onPotionApplicable(MobEffectEvent.Applicable event) {
        ModCyberwareEvents.dispatch(event.getEntity(), (cw, stack) -> {
            if (event.getResult() != Event.Result.DENY) {
                cw.onPotionApplicable(event, (ItemStack)stack, event.getEntity());
            }
        });
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        ModCyberwareEvents.dispatch(event.getEntity(), (cw, stack) -> {
            if (!event.isCanceled()) {
                cw.onLivingDeath(event, (ItemStack)stack, event.getEntity());
            }
        });
    }

    @SubscribeEvent
    public static void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        ModCyberwareEvents.dispatch((LivingEntity)event.getEntity(), (cw, stack) -> cw.onHarvestCheck(event, (ItemStack)stack, (LivingEntity)event.getEntity()));
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ModCyberwareEvents.dispatch((LivingEntity)event.getEntity(), (cw, stack) -> cw.onBreakSpeed(event, (ItemStack)stack, (LivingEntity)event.getEntity()));
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        ModCyberwareEvents.dispatch(event.getEntity(), (cw, stack) -> cw.onLivingFall(event, (ItemStack)stack, event.getEntity()));
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        ModCyberwareEvents.dispatch(event.getEntity(), (cw, stack) -> cw.onLivingJump(event, (ItemStack)stack, event.getEntity()));
    }
}

