/*
 * Decompiled with CFR 0.152.
 */
package com.sirsquidly.veilings.common.entity;

import com.sirsquidly.veilings.client.model.ModelVeilingBase;
import com.sirsquidly.veilings.common.entity.ai.EntityAIVeilingBeg;
import com.sirsquidly.veilings.common.entity.ai.EntityAIVeilingCommandFollow;
import com.sirsquidly.veilings.common.entity.ai.EntityAIVeilingCommandSit;
import com.sirsquidly.veilings.common.entity.ai.EntityAIVeilingCommandWander;
import com.sirsquidly.veilings.common.entity.ai.EntityAIVeilingDanceParty;
import com.sirsquidly.veilings.common.entity.ai.EntityAIVeilingDislikeSunlight;
import com.sirsquidly.veilings.common.entity.ai.EntityAIVeilingFearMob;
import com.sirsquidly.veilings.common.entity.ai.EntityAIVeilingSnowballFight;
import com.sirsquidly.veilings.common.entity.ai.EntityAIVeilingUseItem;
import com.sirsquidly.veilings.common.entity.wicked.AbstractWickedVeiling;
import com.sirsquidly.veilings.common.item.ItemVeilingOutfit;
import com.sirsquidly.veilings.config.ConfigCache;
import com.sirsquidly.veilings.init.VeilingsSounds;
import com.sirsquidly.veilings.util.veilingItemUse.IVeilingItemUse;
import com.sirsquidly.veilings.util.veilingItemUse.VeilingItemUseRegistry;
import com.sirsquidly.veilings.util.veilingLogic.VeilingMultiplication;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbstractVeiling
extends EntityTameable {
    public final VeilingMultiplication multiplyLogic = new VeilingMultiplication();
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("0c234b6e-341a-43ba-b282-cc76af94e65c");
    private static final DataParameter<Integer> ARM_POSE = EntityDataManager.func_187226_a(AbstractVeiling.class, (DataSerializer)DataSerializers.field_187192_b);
    public int previousPose = 0;
    private static final DataParameter<Integer> COMMAND_MODE = EntityDataManager.func_187226_a(AbstractVeiling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DANCE_TYPE = EntityDataManager.func_187226_a(AbstractVeiling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> EYE_COLOR = EntityDataManager.func_187226_a(AbstractVeiling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MOOD = EntityDataManager.func_187226_a(AbstractVeiling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SIT_TYPE = EntityDataManager.func_187226_a(AbstractVeiling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> EAT_COOLDOWN = EntityDataManager.func_187226_a(AbstractVeiling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PLAY_COOLDOWN = EntityDataManager.func_187226_a(AbstractVeiling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> OUTFIT_ITEM_BODY = EntityDataManager.func_187226_a(AbstractVeiling.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Integer> SPAWN_COOLDOWN = EntityDataManager.func_187226_a(AbstractVeiling.class, (DataSerializer)DataSerializers.field_187192_b);
    public ItemStack favoriteFood = ItemStack.field_190927_a;
    private boolean dancing = false;
    public boolean snowballFighting = false;
    private float animTransSpeed = 0.4f;
    private float animationTime;
    private float prevAnimationTime;
    public int multiplyCooldown = 4000;
    private final Map<String, Float> attributeDifferences = new HashMap<String, Float>();

    public AbstractVeiling(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.2f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ARM_POSE, (Object)0);
        this.field_70180_af.func_187214_a(COMMAND_MODE, (Object)0);
        this.field_70180_af.func_187214_a(DANCE_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(EYE_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(MOOD, (Object)100);
        this.field_70180_af.func_187214_a(SIT_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(EAT_COOLDOWN, (Object)0);
        this.field_70180_af.func_187214_a(PLAY_COOLDOWN, (Object)0);
        this.field_70180_af.func_187214_a(OUTFIT_ITEM_BODY, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(SPAWN_COOLDOWN, (Object)3000);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.setupAttributeDifferences();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, new EntityAIVeilingFearMob<AbstractWickedVeiling>((EntityCreature)this, AbstractWickedVeiling.class, 2.0f, 1.2, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIVeilingCommandWander(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIVeilingCommandFollow(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIVeilingCommandSit(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIVeilingUseItem(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIVeilingSnowballFight(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIVeilingDanceParty(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIVeilingBeg(this, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{AbstractWickedVeiling.class}));
        this.setupAdditionalAI();
    }

    protected void setupAdditionalAI() {
        if (ConfigCache.mod_zomFerEnb) {
            this.field_70714_bg.func_75776_a(2, new EntityAIVeilingFearMob<EntityZombie>((EntityCreature)this, EntityZombie.class, 8.0f, 1.0, 1.0));
        }
        if (ConfigCache.mod_sunHatEnb) {
            this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIVeilingDislikeSunlight(this));
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public EntityAgeable func_90011_a(EntityAgeable thisVeiling) {
        return null;
    }

    public AbstractVeiling getInverse(AbstractVeiling thisVeiling) {
        return null;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    public int func_70627_aG() {
        return 480;
    }

    protected SoundEvent func_184639_G() {
        return this.getMood() > 75 ? VeilingsSounds.ENTITY_VEILING_AMBIENT_HAPPY : (this.getMood() < 25 ? VeilingsSounds.ENTITY_VEILING_AMBIENT_SAD : VeilingsSounds.ENTITY_VEILING_AMBIENT);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return VeilingsSounds.ENTITY_VEILING_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return VeilingsSounds.ENTITY_VEILING_DEATH;
    }

    public SoundEvent getEatSound() {
        return VeilingsSounds.ENTITY_VEILING_EAT;
    }

    public SoundEvent getPanicSound() {
        return VeilingsSounds.ENTITY_VEILING_PANIC;
    }

    public float getPublicSoundPitch() {
        return this.func_70647_i();
    }

    public void func_70636_d() {
        this.func_82168_bl();
        this.prevAnimationTime = this.animationTime;
        if (this.previousPose != this.getArmPose().ordinal()) {
            this.animationTime = Math.max(0.0f, this.animationTime - this.animTransSpeed);
            if (this.animationTime <= 0.0f) {
                this.previousPose = this.getArmPose().ordinal();
            }
        } else {
            this.animationTime = Math.min(1.0f, this.animationTime + this.animTransSpeed);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.multiplyLogic.tick(this);
            if (this.getMood() < 10) {
                this.tantrumUpdate();
            }
            if (this.getPlayCooldown() > 0) {
                this.setPlayCooldown(this.getPlayCooldown() - 1);
            }
            if (this.getEatCooldown() > 0) {
                this.setEatCooldown(this.getEatCooldown() - 1);
            }
        }
        super.func_70636_d();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        IVeilingItemUse use;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean isOwner = this.func_152114_e((EntityLivingBase)player);
        if (!itemstack.func_190926_b() && (use = VeilingItemUseRegistry.get(itemstack.func_77973_b())) != null && (isOwner || use.isSafeItem(this, itemstack))) {
            ItemStack oldHeldItem = this.func_184586_b(EnumHand.MAIN_HAND);
            ItemStack newHeld = itemstack.func_77946_l();
            newHeld.func_190920_e(1);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, newHeld);
            if (!this.field_70170_p.field_72995_K && !player.func_184812_l_()) {
                itemstack.func_190918_g(1);
                if (!oldHeldItem.func_190926_b()) {
                    if (itemstack.func_190926_b()) {
                        player.func_184611_a(EnumHand.MAIN_HAND, oldHeldItem);
                    } else if (!player.field_71071_by.func_70441_a(oldHeldItem)) {
                        player.func_71019_a(oldHeldItem, false);
                    }
                }
            }
            player.func_184609_a(hand);
            return true;
        }
        if (isOwner) {
            if (itemstack.func_77973_b() instanceof ItemVeilingOutfit) {
                this.func_184185_a(VeilingsSounds.ITEM_VEILING_OUTFIT_EQUIP, 0.5f, 1.0f);
                ItemStack oldOutfitStack = this.getBodyOutfit();
                this.setBodyOutfit(itemstack);
                if (!this.field_70170_p.field_72995_K && !player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                    if (!oldOutfitStack.func_190926_b()) {
                        if (itemstack.func_190926_b()) {
                            player.func_184611_a(EnumHand.MAIN_HAND, oldOutfitStack);
                        } else if (!player.field_71071_by.func_70441_a(oldOutfitStack)) {
                            player.func_71019_a(oldOutfitStack, false);
                        }
                    }
                }
                player.func_184609_a(hand);
                return true;
            }
            if (itemstack.func_77973_b() instanceof ItemShears && !this.getBodyOutfit().func_190926_b()) {
                this.func_184185_a(VeilingsSounds.ITEM_VEILING_OUTFIT_UNEQUIP_SHEARS, 0.5f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(this.getBodyOutfit(), 1.0f);
                }
                this.setBodyOutfit(ItemStack.field_190927_a);
                player.func_184609_a(hand);
                return true;
            }
            if (itemstack.func_77973_b() instanceof ItemNameTag && itemstack.func_82837_s()) {
                if (!this.func_145818_k_()) {
                    this.shiftHappiness(ConfigCache.mod_fstNamSft);
                    this.spawnOverheadParticle(EnumParticleTypes.HEART, 1 + this.field_70170_p.field_73012_v.nextInt(3));
                } else {
                    this.shiftHappiness(-5 + this.field_70170_p.field_73012_v.nextInt(20));
                }
                return super.func_184645_a(player, hand);
            }
            if (player.func_70093_af() && itemstack.func_190926_b() && !this.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
                player.func_184611_a(EnumHand.MAIN_HAND, this.func_184586_b(EnumHand.MAIN_HAND));
                this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                return true;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(VeilingsSounds.ENTITY_VEILING_AGREE, 0.25f, this.getPublicSoundPitch());
                int next = this.getCommandMode() == 2 ? 0 : this.getCommandMode() + 1;
                this.spawnOverheadParticle(EnumParticleTypes.CRIT_MAGIC, this.getCommandMode() + 1);
                this.setCommandMode(next);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.veilings.veiling.set_mode_" + next, new Object[]{this.func_70005_c_()}), true);
                if (this.getCommandMode() == 1) {
                    this.func_175449_a(this.func_180425_c(), 8);
                } else {
                    this.func_110177_bN();
                }
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                System.out.print("Max Health:" + this.func_110138_aP());
            }
            player.func_184609_a(hand);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.snowballFighting && source.func_76364_f() instanceof EntitySnowball) {
            BlockPos blockpos;
            IBlockState iblockstate;
            boolean trySnowballFight = false;
            if (this.getPlayCooldown() <= 0 && (source.func_76346_g() instanceof EntityPlayer && this.func_184614_ca().func_190926_b() || source.func_76346_g() instanceof AbstractVeiling)) {
                trySnowballFight = true;
            }
            if (trySnowballFight && (iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))).func_177230_c() == Blocks.field_150431_aC) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(this.func_184614_ca().func_77946_l(), 1.0f);
                }
                this.snowballFighting = true;
            }
        } else if (amount > 0.0f && source.func_76346_g() instanceof EntityPlayer && this.func_184753_b() == source.func_76346_g().func_110124_au()) {
            this.shiftHappiness(-10);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource cause) {
        this.func_184642_a(EntityEquipmentSlot.MAINHAND, 100.0f);
        for (AbstractVeiling veiling : this.field_70170_p.func_72872_a(AbstractVeiling.class, this.func_174813_aQ().func_186662_g(5.0))) {
            if (veiling.func_184753_b() != null && !veiling.func_184753_b().equals(this.func_184753_b()) || veiling.getMood() <= 10) continue;
            veiling.shiftHappiness(ConfigCache.mod_dthSft);
        }
        this.setArmPose(ModelVeilingBase.PoseBody.EMPTY);
        if (!this.field_70170_p.field_72995_K && !this.getBodyOutfit().func_190926_b()) {
            this.func_70099_a(this.getBodyOutfit(), 1.0f);
        }
        super.func_70645_a(cause);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
            this.func_184614_ca().func_77972_a(1, (EntityLivingBase)this);
        }
        return flag;
    }

    public void spawnOverheadParticle(EnumParticleTypes particle, int quantity) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ((WorldServer)this.field_70170_p).func_175739_a(particle, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O * 1.2, this.field_70161_v, quantity, 0.1, 0.05, 0.1, 0.05, new int[0]);
    }

    public void tantrumUpdate() {
        this.setArmPose(ModelVeilingBase.PoseBody.CRYING);
        ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 2, 0.1, 0.1, 0.1, 0.05, new int[0]);
        this.shiftHappiness(-1, false);
        if (this.field_70173_aa % 10 == 0) {
            this.func_184185_a(VeilingsSounds.ENTITY_VEILING_TANTRUM, 1.0f, 1.0f);
            this.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, 2, false, false));
            for (AbstractVeiling veiling : this.field_70170_p.func_72872_a(AbstractVeiling.class, this.func_174813_aQ().func_186662_g(5.0))) {
                if (veiling.getMood() <= 10) continue;
                veiling.shiftHappiness(-1);
            }
            if (this.getMood() <= -100) {
                if (ConfigCache.mod_trnWikEnb) {
                    this.multiplyLogic.transformVeiling(this.field_70170_p, this, this.getInverse(this));
                    this.func_184185_a(SoundEvents.field_187541_bC, 1.0f, 1.0f);
                } else {
                    this.setArmPose(ModelVeilingBase.PoseBody.EMPTY);
                    this.shiftHappiness(120);
                }
            }
        }
    }

    public void shiftHappiness(int shiftBy) {
        this.shiftHappiness(shiftBy, true);
    }

    public void shiftHappiness(int shiftBy, boolean clamped) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.spawnOverheadParticle(shiftBy > 0 ? EnumParticleTypes.VILLAGER_HAPPY : EnumParticleTypes.VILLAGER_ANGRY, Math.abs(shiftBy));
        if (this.field_70170_p.field_73012_v.nextFloat() < (float)Math.abs(shiftBy) * 0.05f) {
            this.func_184185_a(shiftBy > 0 ? VeilingsSounds.ENTITY_VEILING_MOOD_INCREASE : VeilingsSounds.ENTITY_VEILING_MOOD_DECREASE, Math.min((float)Math.abs(shiftBy) * 0.1f, 1.0f), 1.0f);
        }
        int adjustment = this.getMood() + shiftBy;
        this.setMood(clamped ? MathHelper.func_76125_a((int)adjustment, (int)0, (int)100) : adjustment);
    }

    @SideOnly(value=Side.CLIENT)
    public float getClientAnimationTime(float partialTick) {
        return this.prevAnimationTime + (this.animationTime - this.prevAnimationTime) * partialTick;
    }

    public void setArmPose(ModelVeilingBase.PoseBody pose) {
        int oldOrdinal;
        int newOrdinal = pose.ordinal();
        if (newOrdinal != (oldOrdinal = this.getArmPose().ordinal())) {
            this.previousPose = oldOrdinal;
            this.field_70180_af.func_187227_b(ARM_POSE, (Object)newOrdinal);
            this.animationTime = 0.0f;
        }
    }

    public ModelVeilingBase.PoseBody getArmPose() {
        return ModelVeilingBase.PoseBody.values()[(Integer)this.field_70180_af.func_187225_a(ARM_POSE)];
    }

    public int getCommandMode() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND_MODE);
    }

    public void setCommandMode(int state) {
        this.field_70180_af.func_187227_b(COMMAND_MODE, (Object)state);
    }

    public int getMood() {
        return (Integer)this.field_70180_af.func_187225_a(MOOD);
    }

    public void setMood(int state) {
        this.field_70180_af.func_187227_b(MOOD, (Object)state);
    }

    public int getEatCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(EAT_COOLDOWN);
    }

    public void setEatCooldown(int state) {
        this.field_70180_af.func_187227_b(EAT_COOLDOWN, (Object)state);
    }

    public int getEyeColor() {
        return (Integer)this.field_70180_af.func_187225_a(EYE_COLOR);
    }

    public void setEyeColor(int state) {
        this.field_70180_af.func_187227_b(EYE_COLOR, (Object)state);
    }

    public int getPlayCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(PLAY_COOLDOWN);
    }

    public void setPlayCooldown(int state) {
        this.field_70180_af.func_187227_b(PLAY_COOLDOWN, (Object)state);
    }

    public int getSpawnCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(SPAWN_COOLDOWN);
    }

    public void setSpawnCooldown(int state) {
        this.field_70180_af.func_187227_b(SPAWN_COOLDOWN, (Object)state);
    }

    public ItemStack getFavoriteFood() {
        return this.favoriteFood;
    }

    public void setDanceType(int state) {
        this.field_70180_af.func_187227_b(DANCE_TYPE, (Object)state);
    }

    public int getDanceType() {
        return (Integer)this.field_70180_af.func_187225_a(DANCE_TYPE);
    }

    public void setSitType(int state) {
        this.field_70180_af.func_187227_b(SIT_TYPE, (Object)state);
    }

    public int getSitType() {
        return (Integer)this.field_70180_af.func_187225_a(SIT_TYPE);
    }

    public void setAnimTransSpeed(float newSpeed) {
        this.animTransSpeed = newSpeed;
    }

    public ItemStack getBodyOutfit() {
        return (ItemStack)this.field_70180_af.func_187225_a(OUTFIT_ITEM_BODY);
    }

    public void setBodyOutfit(ItemStack stack) {
        if (!stack.func_190926_b()) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.updateEntityAttribute(SharedMonsterAttributes.field_188791_g, ARMOR_MODIFIER_UUID, "Body Outfit Armor bonus", stack.func_190926_b() ? 0.0 : 4.0, 0);
        }
        this.field_70180_af.func_187227_b(OUTFIT_ITEM_BODY, (Object)stack);
    }

    public void applyUpgrade(String key, float amount) {
        float newValue = this.getAttributeValue(key).floatValue() + amount;
        this.attributeDifferences.put(key, Float.valueOf(newValue));
        this.updateAttributeFromKey(key, newValue);
    }

    public Float getAttributeValue(String key) {
        return this.attributeDifferences.getOrDefault(key, Float.valueOf(0.0f));
    }

    private void setupAttributeDifferences() {
        if (this.attributeDifferences == null || this.attributeDifferences.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Float> entry : this.attributeDifferences.entrySet()) {
            this.updateAttributeFromKey(entry.getKey(), entry.getValue().floatValue());
        }
    }

    private void updateAttributeFromKey(String key, double value) {
        IAttribute attribute = null;
        UUID uuid = null;
        switch (key) {
            case "health_bonus": {
                attribute = SharedMonsterAttributes.field_111267_a;
                uuid = HEALTH_MODIFIER_UUID;
            }
        }
        if (attribute != null) {
            this.updateEntityAttribute(attribute, uuid, key, value, 0);
        }
    }

    public void updateEntityAttribute(IAttribute attribute, UUID uuid, String name, double value, int operation) {
        this.func_110148_a(attribute).func_188479_b(uuid);
        if (value != 0.0) {
            this.func_110148_a(attribute).func_111121_a(new AttributeModifier(uuid, name, value, operation));
        }
    }

    public void copyAttributesFrom(AbstractVeiling other) {
        this.attributeDifferences.clear();
        for (Map.Entry<String, Float> entry : other.attributeDifferences.entrySet()) {
            this.attributeDifferences.put(entry.getKey(), entry.getValue());
        }
        this.setupAttributeDifferences();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Mood", this.getMood());
        compound.func_74768_a("EyeColor", this.getEyeColor());
        compound.func_74768_a("CommandMode", this.getCommandMode());
        compound.func_74768_a("EatingCooldown", this.getEatCooldown());
        compound.func_74768_a("PlayCooldown", this.getPlayCooldown());
        compound.func_74768_a("SpawningCooldown", this.getSpawnCooldown());
        if (!this.getFavoriteFood().func_190926_b()) {
            compound.func_74782_a("FavoriteFood", (NBTBase)this.getFavoriteFood().func_77955_b(new NBTTagCompound()));
        }
        if (!this.getBodyOutfit().func_190926_b()) {
            compound.func_74782_a("OutfitBodyItemstack", (NBTBase)this.getBodyOutfit().func_77955_b(new NBTTagCompound()));
        }
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, Float> entry : this.attributeDifferences.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Key", entry.getKey());
            tag.func_74776_a("Value", entry.getValue().floatValue());
            list.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("VeilingUpgrades", (NBTBase)list);
        compound.func_74768_a("DanceType", this.getDanceType());
        compound.func_74768_a("SitType", this.getSitType());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setMood(compound.func_74762_e("Mood"));
        this.setEyeColor(compound.func_74762_e("EyeColor"));
        this.setCommandMode(compound.func_74762_e("CommandMode"));
        this.setEatCooldown(compound.func_74762_e("EatingCooldown"));
        this.setPlayCooldown(compound.func_74762_e("PlayCooldown"));
        this.setSpawnCooldown(compound.func_74762_e("SpawningCooldown"));
        if (!compound.func_74775_l("FavoriteFood").func_82582_d()) {
            this.favoriteFood = new ItemStack(compound.func_74775_l("FavoriteFood"));
        }
        if (!compound.func_74775_l("OutfitBodyItemstack").func_82582_d()) {
            this.setBodyOutfit(new ItemStack(compound.func_74775_l("OutfitBodyItemstack")));
        }
        this.attributeDifferences.clear();
        NBTTagList list = compound.func_150295_c("VeilingUpgrades", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            this.attributeDifferences.put(tag.func_74779_i("Key"), Float.valueOf(tag.func_74760_g("Value")));
        }
        this.setupAttributeDifferences();
        this.field_70180_af.func_187227_b(DANCE_TYPE, (Object)compound.func_74762_e("DanceType"));
        this.field_70180_af.func_187227_b(SIT_TYPE, (Object)compound.func_74762_e("SitType"));
    }
}

