/*
 * Decompiled with CFR 0.152.
 */
package com.sirsquidly.veilings.common.entity.ai;

import com.sirsquidly.veilings.client.model.ModelVeilingBase;
import com.sirsquidly.veilings.common.entity.AbstractVeiling;
import com.sirsquidly.veilings.util.veilingItemUse.IVeilingItemUse;
import com.sirsquidly.veilings.util.veilingItemUse.VeilingItemUseRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class EntityAIVeilingBeg
extends EntityAIBase {
    private final AbstractVeiling veiling;
    private EntityPlayer player;
    private final World world;
    private final float minPlayerDistance;
    private int timeoutCounter;

    public EntityAIVeilingBeg(AbstractVeiling veilingIn, float minDistance) {
        this.veiling = veilingIn;
        this.world = veilingIn.field_70170_p;
        this.minPlayerDistance = minDistance;
        this.func_75248_a(2);
    }

    public boolean func_75250_a() {
        this.player = this.world.func_72890_a((Entity)this.veiling, (double)this.minPlayerDistance);
        return this.player == null ? false : this.hasTemptationItemInHand(this.player) && this.veiling.getArmPose() == ModelVeilingBase.PoseBody.EMPTY;
    }

    public boolean func_75253_b() {
        if (this.player == null || !this.player.func_70089_S()) {
            return false;
        }
        if (this.veiling.func_70068_e((Entity)this.player) > (double)(this.minPlayerDistance * this.minPlayerDistance)) {
            return false;
        }
        return this.timeoutCounter > 0 && this.hasTemptationItemInHand(this.player);
    }

    public void func_75249_e() {
        this.veiling.setArmPose(ModelVeilingBase.PoseBody.BEGGING);
        this.timeoutCounter = 40 + this.veiling.func_70681_au().nextInt(40);
    }

    public void func_75251_c() {
        if (this.veiling.getArmPose() == ModelVeilingBase.PoseBody.BEGGING) {
            this.veiling.setArmPose(ModelVeilingBase.PoseBody.EMPTY);
        }
        this.player = null;
    }

    public void func_75246_d() {
        ItemStack held = this.veiling.func_184614_ca();
        if (!held.func_190926_b() && VeilingItemUseRegistry.get(held.func_77973_b()) != null) {
            this.func_75251_c();
            return;
        }
        this.veiling.func_70671_ap().func_75650_a(this.player.field_70165_t, this.player.field_70163_u + (double)this.player.func_70047_e(), this.player.field_70161_v, 10.0f, (float)this.veiling.func_70646_bf());
        --this.timeoutCounter;
    }

    private boolean hasTemptationItemInHand(EntityPlayer player) {
        for (EnumHand enumhand : EnumHand.values()) {
            ItemStack itemstack = player.func_184586_b(enumhand);
            if (itemstack.func_190926_b()) continue;
            IVeilingItemUse cachedBehavior = VeilingItemUseRegistry.get(itemstack.func_77973_b());
            if (cachedBehavior != null) {
                return cachedBehavior.canUseItem(this.veiling, itemstack);
            }
            return false;
        }
        return false;
    }
}

