/*
 * Decompiled with CFR 0.152.
 */
package com.sirsquidly.veilings.common.entity.ai;

import com.sirsquidly.veilings.client.model.ModelVeilingBase;
import com.sirsquidly.veilings.common.entity.AbstractVeiling;
import net.minecraft.block.BlockJukebox;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAIVeilingDanceParty
extends EntityAIBase {
    private final AbstractVeiling veiling;
    private final World world;
    private BlockPos jukeboxPosition = null;
    private int checkJukeboxRange = 4;
    protected int checkDelay;
    private int danceTimer;

    public EntityAIVeilingDanceParty(AbstractVeiling veilingIn) {
        this.veiling = veilingIn;
        this.world = veilingIn.field_70170_p;
    }

    public boolean func_75250_a() {
        if (this.veiling.snowballFighting) {
            return false;
        }
        if (this.jukeboxPosition != null) {
            return true;
        }
        if (this.checkDelay > 0) {
            --this.checkDelay;
            return false;
        }
        this.findNearbyJukebox();
        this.checkDelay = 20 + this.world.field_73012_v.nextInt(20);
        return this.jukeboxPosition != null;
    }

    public boolean func_75253_b() {
        return this.jukeboxPosition != null && this.veiling.func_174818_b(this.jukeboxPosition) < 40.0 && this.checkJukeboxHasDisc(this.jukeboxPosition);
    }

    public void func_75249_e() {
        this.danceTimer = 600 + this.world.field_73012_v.nextInt(400);
    }

    public void func_75251_c() {
        if (this.veiling.getArmPose() == ModelVeilingBase.PoseBody.DANCING) {
            this.veiling.setArmPose(ModelVeilingBase.PoseBody.EMPTY);
        }
        this.jukeboxPosition = null;
        this.checkDelay = 20 + this.world.field_73012_v.nextInt(20);
    }

    public void func_75246_d() {
        --this.checkDelay;
        --this.danceTimer;
        this.veiling.setArmPose(ModelVeilingBase.PoseBody.DANCING);
        if (this.checkDelay <= 0) {
            this.veiling.spawnOverheadParticle(EnumParticleTypes.NOTE, 1);
            if (!this.checkJukeboxHasDisc(this.jukeboxPosition)) {
                this.findNearbyJukebox();
            }
            this.checkDelay = 20 + this.world.field_73012_v.nextInt(20);
        }
        if (this.danceTimer <= 0) {
            if (this.veiling.getPlayCooldown() <= 0) {
                this.veiling.shiftHappiness(40);
                this.veiling.setPlayCooldown(6000);
            } else {
                this.danceTimer = 60 + this.world.field_73012_v.nextInt(300);
            }
        }
    }

    public void findNearbyJukebox() {
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)this.veiling.func_180425_c().func_177982_a(-this.checkJukeboxRange, -2, -this.checkJukeboxRange), (BlockPos)this.veiling.func_180425_c().func_177982_a(this.checkJukeboxRange, 2, this.checkJukeboxRange))) {
            if (this.world.func_180495_p(pos).func_177230_c() != Blocks.field_150421_aI || !this.checkJukeboxHasDisc(pos)) continue;
            this.jukeboxPosition = pos;
            return;
        }
        this.jukeboxPosition = null;
    }

    public boolean checkJukeboxHasDisc(BlockPos pos) {
        TileEntity tile = this.world.func_175625_s(pos);
        if (tile instanceof BlockJukebox.TileEntityJukebox) {
            BlockJukebox.TileEntityJukebox jukebox = (BlockJukebox.TileEntityJukebox)tile;
            return !jukebox.func_145856_a().func_190926_b();
        }
        return false;
    }
}

