/*
 * Decompiled with CFR 0.152.
 */
package com.sirsquidly.veilings.common.entity.ai;

import com.sirsquidly.veilings.common.entity.AbstractVeiling;
import com.sirsquidly.veilings.common.entity.ai.EntityAIVeilingUseItem;
import com.sirsquidly.veilings.util.veilingItemUse.IVeilingItemUse;
import com.sirsquidly.veilings.util.veilingItemUse.VeilingItemUseRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityAIVeilingSnowballFight
extends EntityAIVeilingUseItem {
    private final AbstractVeiling veiling;
    private final World world;
    private int snowballThrowTime;
    private int snowballQuantity;
    private Entity victim;

    public EntityAIVeilingSnowballFight(AbstractVeiling veilingIn) {
        super(veilingIn);
        this.veiling = veilingIn;
        this.world = veilingIn.field_70170_p;
    }

    @Override
    public boolean func_75250_a() {
        return this.veiling.snowballFighting;
    }

    public void func_75249_e() {
        this.snowballThrowTime = 5;
        this.snowballQuantity = this.world.field_73012_v.nextInt(60) + 6;
        this.victim = this.getNearbyRandomEntity(this.world, this.veiling, 5.0);
    }

    @Override
    public void func_75246_d() {
        --this.snowballThrowTime;
        ItemStack heldItem = this.veiling.func_184614_ca();
        if (this.victim != null) {
            this.veiling.func_70671_ap().func_75651_a(this.victim, 30.0f, 30.0f);
        }
        if (heldItem.func_77973_b() == Items.field_151126_ay) {
            if (this.snowballThrowTime > 0) {
                return;
            }
            if (this.victim != null) {
                IVeilingItemUse behavior = VeilingItemUseRegistry.get(heldItem.func_77973_b());
                if (behavior != null) {
                    behavior.onItemUseFinish(this.veiling, heldItem, 999999);
                }
                this.snowballThrowTime = this.world.field_73012_v.nextInt(10) + 5;
                --this.snowballQuantity;
                this.victim = this.getNearbyRandomEntity(this.world, this.veiling, 5.0);
            } else {
                this.victim = this.getNearbyRandomEntity(this.world, this.veiling, 5.0);
            }
        } else {
            BlockPos blockpos = new BlockPos(this.veiling.field_70165_t, this.veiling.field_70163_u, this.veiling.field_70161_v);
            IBlockState iblockstate = this.world.func_180495_p(blockpos);
            if (iblockstate.func_177230_c() == Blocks.field_150431_aC) {
                if (!this.world.field_72995_K) {
                    this.veiling.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151126_ay));
                }
                this.veiling.func_184185_a(SoundEvents.field_187807_fF, 1.0f, 1.0f);
                ((WorldServer)this.world).func_175739_a(EnumParticleTypes.BLOCK_CRACK, this.veiling.field_70165_t, this.veiling.field_70163_u, this.veiling.field_70161_v, 10, 0.2, 0.4, 0.2, 0.05, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
        }
        if (this.snowballQuantity <= 0) {
            this.veiling.shiftHappiness(40);
            this.veiling.snowballFighting = false;
            this.veiling.setPlayCooldown(6000);
        }
    }

    public Entity getNearbyRandomEntity(World world, AbstractVeiling veiling, double expandByRange) {
        List list = world.func_72872_a(Entity.class, veiling.func_174813_aQ().func_186662_g(expandByRange));
        list.remove((Object)veiling);
        if (list.isEmpty()) {
            return null;
        }
        return (Entity)list.get(world.field_73012_v.nextInt(list.size()));
    }
}

