/*
 * Decompiled with CFR 0.152.
 */
package com.sirsquidly.veilings.common.item;

import com.sirsquidly.veilings.common.entity.AbstractVeiling;
import com.sirsquidly.veilings.common.entity.EntityVeilingCustodian;
import com.sirsquidly.veilings.common.entity.EntityVeilingDeft;
import com.sirsquidly.veilings.common.entity.EntityVeilingDramatist;
import com.sirsquidly.veilings.init.VeilingsSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCommandSceptre
extends Item {
    public ItemCommandSceptre() {
        this.field_77777_bU = 1;
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_185043_a(new ResourceLocation("ControlType"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                NBTTagCompound tagCompound = stack.func_77978_p();
                if (tagCompound != null && tagCompound.func_74764_b("ControlType")) {
                    return tagCompound.func_74762_e("ControlType");
                }
                return -1.0f;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        List<AbstractVeiling> veilings2;
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            int current = ItemCommandSceptre.getControlType(stack);
            if (++current > 2) {
                current = -1;
            }
            ItemCommandSceptre.setControlType(stack, current);
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("message.veilings.attack_sceptre.set_mode_" + current, new Object[0]), true);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        Vec3d eyePosition = playerIn.func_174824_e(1.0f);
        Vec3d lookVector = playerIn.func_70676_i(1.0f);
        Vec3d traceEnd = eyePosition.func_72441_c(lookVector.field_72450_a * 30.0, lookVector.field_72448_b * 30.0, lookVector.field_72449_c * 30.0);
        RayTraceResult blockTrace = worldIn.func_147447_a(eyePosition, traceEnd, false, true, false);
        if (blockTrace != null) {
            traceEnd = blockTrace.field_72307_f;
        }
        boolean didAnything = !(veilings2 = this.getNearbyVeilings(playerIn, stack, 30)).isEmpty();
        EntityLivingBase entityTarget = this.getFirstSeenLivingEntity(playerIn, eyePosition, lookVector, traceEnd, 30.0);
        if (entityTarget != null) {
            this.preformAttackCommand(worldIn, veilings2, entityTarget, stack);
        } else if (blockTrace != null) {
            this.preformMoveCommand(worldIn, veilings2, blockTrace.func_178782_a(), stack);
        }
        if (didAnything) {
            playerIn.func_184609_a(handIn);
        }
        worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), VeilingsSounds.ITEM_ATTACK_SCEPTRE_USE, SoundCategory.PLAYERS, didAnything ? 0.5f : 0.1f, 1.0f);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public void preformAttackCommand(World worldIn, List<AbstractVeiling> veilings2, EntityLivingBase target, ItemStack heldStack) {
        int soundAmount = 0;
        System.out.print("RAN ATTACK COMMAND");
        for (AbstractVeiling v : veilings2) {
            if (!worldIn.field_72995_K) {
                if (v.func_70638_az() != null && ItemCommandSceptre.isRepeatTarget(heldStack, v.func_70638_az().func_180425_c(), 9.0)) {
                    v.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 20, 0));
                }
                v.setCommandMode(0);
                v.func_70624_b(target);
                v.func_110177_bN();
                if (soundAmount < 6) {
                    v.func_184185_a(VeilingsSounds.ENTITY_VEILING_AGREE, 0.5f, v.getPublicSoundPitch());
                    ++soundAmount;
                }
                ((WorldServer)worldIn).func_175739_a(EnumParticleTypes.CRIT_MAGIC, v.field_70165_t, v.field_70163_u + (double)v.field_70131_O * 0.5, v.field_70161_v, 10, 0.1, (double)v.field_70131_O * 0.25, 0.1, 0.05, new int[0]);
            }
            if (worldIn.field_72995_K) continue;
            ((WorldServer)worldIn).func_175739_a(EnumParticleTypes.SPELL_INSTANT, target.field_70165_t, target.field_70163_u + (double)target.field_70131_O * 0.5, target.field_70161_v, 20, 0.1, (double)target.field_70131_O * 0.25, 0.1, 0.05, new int[0]);
        }
    }

    public void preformMoveCommand(World worldIn, List<AbstractVeiling> veilings2, BlockPos pos, ItemStack heldStack) {
        int soundAmount = 0;
        for (AbstractVeiling v : veilings2) {
            if (worldIn.field_72995_K) continue;
            if (ItemCommandSceptre.isRepeatTarget(heldStack, pos, 9.0)) {
                v.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 20, 0));
            }
            v.func_110177_bN();
            v.func_70624_b(null);
            v.setCommandMode(2);
            if (soundAmount < 6) {
                v.func_184185_a(VeilingsSounds.ENTITY_VEILING_AGREE, 0.25f, v.getPublicSoundPitch());
                ++soundAmount;
            }
            v.func_70661_as().func_75492_a((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 1.0);
        }
        ItemCommandSceptre.setLastPos(heldStack, pos);
        if (!worldIn.field_72995_K) {
            ((WorldServer)worldIn).func_175739_a(EnumParticleTypes.SPELL_INSTANT, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 20, 0.1, 0.1, 0.1, 0.05, new int[0]);
        }
    }

    public static boolean isRepeatTarget(ItemStack stack, BlockPos newPos, double maxDistanceSq) {
        BlockPos old = ItemCommandSceptre.getLastPos(stack);
        if (newPos == null || old == null) {
            return false;
        }
        return old.func_177951_i((Vec3i)newPos) <= maxDistanceSq;
    }

    public static Integer getControlType(ItemStack stack) {
        NBTTagCompound tagCompound;
        if (stack.func_77942_o() && (tagCompound = stack.func_77978_p()) != null && tagCompound.func_74764_b("ControlType")) {
            return tagCompound.func_74762_e("ControlType");
        }
        return -1;
    }

    public static void setLastPos(ItemStack stack, BlockPos pos) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74772_a("LastPosition", pos.func_177986_g());
        stack.func_77982_d(nbt);
    }

    public static BlockPos getLastPos(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("LastPosition")) {
            long l = stack.func_77978_p().func_74763_f("LastPosition");
            return BlockPos.func_177969_a((long)l);
        }
        return null;
    }

    public static void setControlType(ItemStack stack, int type) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("ControlType", type);
        stack.func_77982_d(nbt);
    }

    public EntityLivingBase getFirstSeenLivingEntity(EntityPlayer player, Vec3d eyePosition, Vec3d lookVector, Vec3d traceEnd, double distance) {
        AxisAlignedBB aabb = player.func_174813_aQ().func_72321_a(lookVector.field_72450_a * distance, lookVector.field_72448_b * distance, lookVector.field_72449_c * distance).func_186662_g(1.0);
        EntityLivingBase best = null;
        double closest = distance;
        for (Entity entity : player.field_70170_p.func_72839_b((Entity)player, aabb)) {
            double hitDist;
            AxisAlignedBB box;
            RayTraceResult hit;
            if (!(entity instanceof EntityLivingBase) || !entity.func_70067_L()) continue;
            if (entity instanceof AbstractVeiling) {
                AbstractVeiling veiling = (AbstractVeiling)entity;
                if (player.func_110124_au().equals(veiling.func_184753_b())) continue;
            }
            if ((hit = (box = entity.func_174813_aQ().func_186662_g(0.3)).func_72327_a(eyePosition, traceEnd)) == null || !((hitDist = eyePosition.func_72438_d(hit.field_72307_f)) < closest)) continue;
            closest = hitDist;
            best = (EntityLivingBase)entity;
        }
        return best;
    }

    public List<AbstractVeiling> getNearbyVeilings(EntityPlayer player, ItemStack stack, int distance) {
        int type = ItemCommandSceptre.getControlType(stack);
        List veilings2 = player.field_70170_p.func_72872_a(AbstractVeiling.class, player.func_174813_aQ().func_186662_g((double)distance));
        veilings2.removeIf(thisEntity -> !player.func_110124_au().equals(thisEntity.func_184753_b()));
        veilings2.removeIf(thisEntity -> !this.typeMatchesSceptreSetting((AbstractVeiling)((Object)thisEntity), type));
        veilings2.removeIf(thisEntity -> thisEntity.getCommandMode() == 1);
        return veilings2;
    }

    private boolean typeMatchesSceptreSetting(AbstractVeiling veiling, int controlType) {
        if (controlType == -1) {
            return true;
        }
        switch (controlType) {
            case 0: {
                return veiling instanceof EntityVeilingDeft;
            }
            case 1: {
                return veiling instanceof EntityVeilingCustodian;
            }
            case 2: {
                return veiling instanceof EntityVeilingDramatist;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(TextFormatting.YELLOW + I18n.func_74837_a((String)("description.veilings.command_sceptre.veilingType" + ItemCommandSceptre.getControlType(stack)), (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_74837_a((String)"description.veilings.command_sceptre.desc1", (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_74837_a((String)"description.veilings.command_sceptre.desc2", (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_74837_a((String)"description.veilings.command_sceptre.desc3", (Object[])new Object[0]));
    }
}

