/*
 * Decompiled with CFR 0.152.
 */
package com.sirsquidly.veilings.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@net.minecraftforge.common.config.Config(modid="veilings", name="veilings")
@Config.LangKey(value="config.veilings.title")
@Mod.EventBusSubscriber(modid="veilings")
public class Config {
    @Config.LangKey(value="config.veilings.configVersion")
    @Config.Comment(value={"Config Versions help inform modpack makers/config users if changes have been made to the config between updates. These differ from main versioning, since the config file is static.", "Basically, you compare the current default of this value, to the default of when you generated it.", "", "The versioning follows:", "0.0.x - Default values have been slightly adjusted.", "0.x.0 - Config options have been added.", "x.0.0 - Previous Config Options have been completely overhauled and/or removed. Creating a fresh file is recommended."})
    public static String configVersion = "1.0.0";
    @Config.LangKey(value="config.veilings.veiling")
    @Config.Comment(value={"Config related to Veilings themselves"})
    public static configEntity entity = new configEntity();

    @Mod.EventBusSubscriber(modid="veilings")
    public static class ConfigSyncHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("veilings")) {
                ConfigManager.sync((String)"veilings", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class configEntity {
        @Config.RequiresMcRestart
        @Config.LangKey(value="config.veilings.veiling.veilingTreatList")
        @Config.Comment(value={"Items that Veiling will eat, and how much Happiness they give."})
        public String[] veilingTreatList = new String[]{"minecraft:cake=20", "minecraft:cookie=5", "minecraft:pumpkin_pie=10", "minecraft:sugar=2"};
        @Config.LangKey(value="config.veilings.veiling.custodian")
        @Config.Comment(value={"Config specific for Veiling Custodians"})
        public configVeilingCustodian custodian = new configVeilingCustodian();
        @Config.LangKey(value="config.veilings.veiling.deft")
        @Config.Comment(value={"Config specific for Veiling Defts"})
        public configVeilingDeft deft = new configVeilingDeft();
        @Config.LangKey(value="config.veilings.veiling.dramatist")
        @Config.Comment(value={"Config specific for Veiling Dramatists"})
        public configVeilingDramatist dramatist = new configVeilingDramatist();
        @Config.LangKey(value="config.veilings.veiling.mood")
        @Config.Comment(value={"All config for the Mood System"})
        public configVeilingMood mood = new configVeilingMood();
        @Config.LangKey(value="config.veilings.veiling.multiply")
        @Config.Comment(value={"All config for the Multiplying System"})
        public configVeilingMultiply multiply = new configVeilingMultiply();

        public static class configVeilingMultiply {
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.multiply.enableMultiplying")
            @Config.Comment(value={"Enables the Multiplying via Water System."})
            public boolean enableMultiplying = true;
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.multiply.spawnInheritsParentMood")
            @Config.Comment(value={"Child Veilings inherit the Mood of their Parent. Else they start with Max Mood."})
            public boolean spawnInheritsParentMood = true;
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.multiply.enableSpawnExplosion")
            @Config.Comment(value={"Cause a literal mini-explosion when multiplying. DOES damage terrain, only a little."})
            public boolean enableSpawnExplosion = false;
        }

        public static class configVeilingMood {
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.mood.enableTurningWicked")
            @Config.Comment(value={"Tantruming Veilings turn Wicked. If disabled, they rebound to a low mood after a tantrum."})
            public boolean enableTurningWicked = true;
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.mood.enableSunlightDislike")
            @Config.Comment(value={"Veilings slightly dislike Sunlight."})
            public boolean enableSunlightDislike = true;
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.mood.enableZombieFear")
            @Config.Comment(value={"If Veilings should fear (and flee from) Zombies."})
            public boolean enableZombieFear = true;
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.mood.veilingNewName")
            @Config.Comment(value={"The mood shift when a Veilings is given a new name (by their owner), for the first time only."})
            public int veilingNewName = 100;
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.mood.veilingSympathy")
            @Config.Comment(value={"The mood shift when a Veilings friends (ones of the same owner) die."})
            public int veilingSympathy = -5;
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.mood.veilingMultiply")
            @Config.Comment(value={"The mood shift when a Veilings Multiplies."})
            public int veilingMultiply = -20;
        }

        public static class configVeilingDramatist {
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.dramatist.baseHealth")
            @Config.Comment(value={"The mood shift when a Veilings is given a new name (by their owner), for the first time only."})
            public int baseHealth = 8;
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.dramatist.baseAttackDamage")
            @Config.Comment(value={"The mood shift when a Veilings is given a new name (by their owner), for the first time only."})
            public int baseAttackDamage = 4;
        }

        public static class configVeilingDeft {
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.deft.baseHealth")
            @Config.Comment(value={"The mood shift when a Veilings is given a new name (by their owner), for the first time only."})
            public int baseHealth = 8;
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.deft.baseAttackDamage")
            @Config.Comment(value={"The mood shift when a Veilings is given a new name (by their owner), for the first time only."})
            public int baseAttackDamage = 4;
        }

        public static class configVeilingCustodian {
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.custodian.baseHealth")
            @Config.Comment(value={"The mood shift when a Veilings is given a new name (by their owner), for the first time only."})
            public int baseHealth = 8;
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.veilings.veiling.custodian.baseAttackDamage")
            @Config.Comment(value={"The mood shift when a Veilings is given a new name (by their owner), for the first time only."})
            public int baseAttackDamage = 4;
        }
    }
}

