/*
 * Decompiled with CFR 0.152.
 */
package com.sirsquidly.veilings.init;

import com.sirsquidly.veilings.common.item.ItemCallingBell;
import com.sirsquidly.veilings.common.item.ItemCommandSceptre;
import com.sirsquidly.veilings.common.item.ItemSpiritDagger;
import com.sirsquidly.veilings.common.item.ItemVeilingEgg;
import com.sirsquidly.veilings.common.item.ItemVeilingMask;
import com.sirsquidly.veilings.common.item.ItemVeilingOutfit;
import com.sirsquidly.veilings.common.item.ItemVeilingTreat;
import com.sirsquidly.veilings.veilings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="veilings")
public class VeilingsItems {
    public static final List<Item> itemList = new ArrayList<Item>();
    public static Item VEILING_EGG = new ItemVeilingEgg();
    public static Item VEILING_ESSENCE = new Item().func_77637_a(CreativeTabs.field_78026_f);
    public static Item VEILING_WEAVE = new Item().func_77637_a(CreativeTabs.field_78026_f);
    public static Item VEILING_TIRAMISU = new ItemVeilingTreat(5, 0.6f, false).func_185070_a(new PotionEffect(MobEffects.field_76444_x, 600, 0), 1.0f);
    public static Item COMMAND_SCEPTRE = new ItemCommandSceptre();
    public static Item CALLING_BELL = new ItemCallingBell();
    public static Item VEILING_MASK_DEFT = new ItemVeilingMask(0);
    public static Item VEILING_MASK_CUSTODIAN = new ItemVeilingMask(1);
    public static Item VEILING_MASK_DRAMATIST = new ItemVeilingMask(2);
    public static Item SPIRIT_DAGGER = new ItemSpiritDagger();
    public static Item VEILING_ARMOR_OUTFIT = new ItemVeilingOutfit(0, "armor", true);
    public static Item VEILING_JESTER_OUTFIT = new ItemVeilingOutfit(0, "jester", true);
    public static Item VEILING_MAID_OUTFIT = new ItemVeilingOutfit(0, "maid", true);
    public static Item VEILING_PONCHO_OUTFIT = new ItemVeilingOutfit(0, "poncho", true);
    public static Item VEILING_VEST_OUTFIT = new ItemVeilingOutfit(0, "vest", false);
    public static Item VEILING_WRAPS_OUTFIT = new ItemVeilingOutfit(0, "wraps", true);

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        VeilingsItems.itemReadyForRegister(VEILING_EGG, "false_fetus");
        VeilingsItems.itemReadyForRegister(VEILING_ESSENCE, "veiling_essence");
        VeilingsItems.itemReadyForRegister(VEILING_WEAVE, "veiling_weave");
        VeilingsItems.itemReadyForRegister(CALLING_BELL, "calling_bell");
        VeilingsItems.itemReadyForRegister(VEILING_TIRAMISU, "veiling_tiramisu");
        VeilingsItems.itemReadyForRegister(COMMAND_SCEPTRE, "command_sceptre");
        VeilingsItems.itemReadyForRegister(SPIRIT_DAGGER, "spirit_dagger");
        VeilingsItems.itemReadyForRegister(VEILING_MASK_DEFT, "mask_deft");
        VeilingsItems.itemReadyForRegister(VEILING_MASK_CUSTODIAN, "mask_custodian");
        VeilingsItems.itemReadyForRegister(VEILING_MASK_DRAMATIST, "mask_dramatist");
        VeilingsItems.itemReadyForRegister(VEILING_ARMOR_OUTFIT, "veiling_outfit_armor");
        VeilingsItems.itemReadyForRegister(VEILING_JESTER_OUTFIT, "veiling_outfit_jester");
        VeilingsItems.itemReadyForRegister(VEILING_MAID_OUTFIT, "veiling_outfit_maid");
        VeilingsItems.itemReadyForRegister(VEILING_PONCHO_OUTFIT, "veiling_outfit_poncho");
        VeilingsItems.itemReadyForRegister(VEILING_VEST_OUTFIT, "veiling_outfit_vest");
        VeilingsItems.itemReadyForRegister(VEILING_WRAPS_OUTFIT, "veiling_outfit_wraps");
        for (Item items : itemList) {
            event.getRegistry().register((IForgeRegistryEntry)items);
        }
    }

    public static Item itemReadyForRegister(Item item, String name) {
        if (name != null) {
            item.func_77655_b("veilings." + name);
            item.setRegistryName(name);
        }
        itemList.add(item);
        return item;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item items : itemList) {
            veilings.proxy.registerItemRenderer(items, 0, "inventory");
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerItemColourHandlers(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        IItemColor veilingOutfitColor = (stack, tintIndex) -> {
            if (tintIndex == 0 && stack.func_77973_b() instanceof ItemVeilingOutfit) {
                return ((ItemVeilingOutfit)stack.func_77973_b()).getColor(stack);
            }
            return 0xFFFFFF;
        };
        itemColors.func_186730_a(veilingOutfitColor, new Item[]{VEILING_ARMOR_OUTFIT});
        itemColors.func_186730_a(veilingOutfitColor, new Item[]{VEILING_JESTER_OUTFIT});
        itemColors.func_186730_a(veilingOutfitColor, new Item[]{VEILING_MAID_OUTFIT});
        itemColors.func_186730_a(veilingOutfitColor, new Item[]{VEILING_PONCHO_OUTFIT});
        itemColors.func_186730_a(veilingOutfitColor, new Item[]{VEILING_VEST_OUTFIT});
        itemColors.func_186730_a(veilingOutfitColor, new Item[]{VEILING_WRAPS_OUTFIT});
    }
}

