/*
 * Decompiled with CFR 0.152.
 */
package com.sirsquidly.veilings.util.veilingLogic;

import com.sirsquidly.veilings.common.entity.AbstractVeiling;
import com.sirsquidly.veilings.common.entity.wicked.AbstractWickedVeiling;
import com.sirsquidly.veilings.config.ConfigCache;
import com.sirsquidly.veilings.config.ConfigParser;
import com.sirsquidly.veilings.init.VeilingsItems;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;

public class VeilingMultiplication {
    public void tick(AbstractVeiling veiling) {
        if (veiling.field_70170_p.field_72995_K || !ConfigCache.mlt_mltEnb) {
            return;
        }
        if (veiling instanceof AbstractWickedVeiling) {
            return;
        }
        if (veiling.getSpawnCooldown() > 0) {
            veiling.setSpawnCooldown(veiling.getSpawnCooldown() - 1);
        } else if (veiling.func_70026_G()) {
            if (ConfigCache.mlt_spnEpo) {
                boolean flag = ForgeEventFactory.getMobGriefingEvent((World)veiling.field_70170_p, (Entity)veiling);
                veiling.field_70170_p.func_72876_a((Entity)veiling, veiling.field_70165_t, veiling.field_70163_u, veiling.field_70161_v, 0.5f, flag);
            }
            ((WorldServer)veiling.field_70170_p).func_175739_a(EnumParticleTypes.EXPLOSION_NORMAL, veiling.field_70165_t, veiling.field_70163_u, veiling.field_70161_v, 200, 0.25, 0.25, 0.25, 0.05, new int[0]);
            AbstractVeiling newVeiling = veiling.multiplyLogic.generateNewVeiling(veiling.field_70170_p, veiling);
            veiling.shiftHappiness(ConfigCache.mod_mltSft);
            newVeiling.setMood(ConfigCache.mlt_irtPntMod ? veiling.getMood() : 100);
            newVeiling.func_70107_b(veiling.field_70165_t, veiling.field_70163_u, veiling.field_70161_v);
            veiling.field_70170_p.func_72838_d((Entity)newVeiling);
            if (!(veiling instanceof AbstractWickedVeiling)) {
                this.imprintOnNearestPlayer(newVeiling);
                veiling.func_145779_a(VeilingsItems.VEILING_ESSENCE, 1);
            }
            veiling.setSpawnCooldown(veiling.multiplyCooldown);
            veiling.func_184185_a(SoundEvents.field_187541_bC, 1.0f, 1.0f);
        }
    }

    public void imprintOnNearestPlayer(AbstractVeiling veiling) {
        boolean happyBaby = true;
        EntityPlayer player = veiling.field_70170_p.func_72890_a((Entity)veiling, 10.0);
        if (player == null) {
            happyBaby = false;
            player = veiling.field_70170_p.func_72890_a((Entity)veiling, 100.0);
        }
        if (player != null) {
            veiling.func_193101_c(player);
            if (happyBaby) {
                veiling.spawnOverheadParticle(EnumParticleTypes.HEART, 7);
                veiling.field_70170_p.func_72960_a((Entity)veiling, (byte)7);
            } else {
                veiling.shiftHappiness(-30);
            }
        }
    }

    public AbstractVeiling generateNewVeiling(World world, AbstractVeiling baseVeiling) {
        AbstractVeiling newVeiling = (AbstractVeiling)baseVeiling.func_90011_a((EntityAgeable)baseVeiling);
        newVeiling.setSpawnCooldown(3000);
        newVeiling.setEyeColor(world.field_73012_v.nextInt(5));
        newVeiling.favoriteFood = ConfigParser.veilingTreatItems.get(world.field_73012_v.nextInt(ConfigParser.veilingTreatItems.size()));
        newVeiling.setDanceType(world.field_73012_v.nextInt(8));
        newVeiling.setSitType(world.field_73012_v.nextInt(8));
        return newVeiling;
    }

    public void transformVeiling(World world, AbstractVeiling baseVeiling, AbstractVeiling transformInto) {
        UUID ownerUUID;
        ((WorldServer)world).func_175739_a(EnumParticleTypes.EXPLOSION_NORMAL, baseVeiling.field_70165_t, baseVeiling.field_70163_u + (double)baseVeiling.field_70131_O * 0.5, baseVeiling.field_70161_v, 200, 0.25, 0.5, 0.25, 0.05, new int[0]);
        transformInto.func_70012_b(baseVeiling.field_70165_t, baseVeiling.field_70163_u, baseVeiling.field_70161_v, baseVeiling.field_70177_z, baseVeiling.field_70125_A);
        transformInto.field_70126_B = baseVeiling.field_70126_B;
        transformInto.field_70758_at = baseVeiling.field_70758_at;
        transformInto.field_70127_C = baseVeiling.field_70127_C;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            transformInto.func_184201_a(slot, baseVeiling.func_184582_a(slot));
        }
        transformInto.func_184641_n(baseVeiling.func_184638_cS());
        transformInto.setMood(baseVeiling.getMood());
        transformInto.setPlayCooldown(baseVeiling.getPlayCooldown());
        transformInto.setSpawnCooldown(baseVeiling.getSpawnCooldown());
        transformInto.setEatCooldown(baseVeiling.getEatCooldown());
        transformInto.setEyeColor(baseVeiling.getEyeColor());
        transformInto.favoriteFood = baseVeiling.getFavoriteFood();
        transformInto.setDanceType(baseVeiling.getDanceType());
        transformInto.setBodyOutfit(baseVeiling.getBodyOutfit());
        transformInto.copyAttributesFrom(baseVeiling);
        boolean fromWicked = baseVeiling instanceof AbstractWickedVeiling;
        boolean toWicked = transformInto instanceof AbstractWickedVeiling;
        UUID uUID = ownerUUID = fromWicked ? ((AbstractWickedVeiling)baseVeiling).getOldOwnerId() : baseVeiling.func_184753_b();
        if (toWicked) {
            ((AbstractWickedVeiling)transformInto).setOldOwnerId(ownerUUID);
            transformInto.setMood(100);
        } else {
            transformInto.func_184754_b(ownerUUID);
        }
        if (baseVeiling.func_145818_k_()) {
            transformInto.func_96094_a(baseVeiling.func_95999_t());
            transformInto.func_174805_g(baseVeiling.func_174833_aM());
        }
        world.func_72838_d((Entity)transformInto);
        baseVeiling.func_70106_y();
    }
}

