/*
 * Decompiled with CFR 0.152.
 */
package com.swirlysys.gamepadhotbar.mixin.client;

import com.swirlysys.gamepadhotbar.GamepadHotbarClient;
import com.swirlysys.gamepadhotbar.config.GamepadHotbarClientConfig;
import com.swirlysys.gamepadhotbar.util.HotbarPos;
import com.swirlysys.gamepadhotbar.util.HotbarScale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4061;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_329.class})
public class HotbarMixin {
    @Unique
    private static final class_2960 HOTBAR_SPRITE = class_2960.method_60656((String)"hud/hotbar");
    @Unique
    private static final class_2960 HOTBAR_SELECTION_SPRITE = class_2960.method_60656((String)"hud/hotbar_selection");
    @Unique
    private static final class_2960 HOTBAR_OFFHAND_LEFT_SPRITE = class_2960.method_60656((String)"hud/hotbar_offhand_left");
    @Unique
    private static final class_2960 HOTBAR_OFFHAND_RIGHT_SPRITE = class_2960.method_60656((String)"hud/hotbar_offhand_right");
    @Unique
    private static final class_2960 TAP_HOTBAR_LEFT = class_2960.method_60655((String)"gamepadhotbar", (String)"hud/tap_hotbar_left");
    @Unique
    private static final class_2960 TAP_HOTBAR_UP = class_2960.method_60655((String)"gamepadhotbar", (String)"hud/tap_hotbar_up");
    @Unique
    private static final class_2960 TAP_HOTBAR_RIGHT = class_2960.method_60655((String)"gamepadhotbar", (String)"hud/tap_hotbar_right");
    @Unique
    private static final class_2960 TAP_HOTBAR_DOWN = class_2960.method_60655((String)"gamepadhotbar", (String)"hud/tap_hotbar_down");
    @Unique
    private static final class_2960 HOTBAR_ATTACK_INDICATOR_BACKGROUND_SPRITE = class_2960.method_60656((String)"hud/hotbar_attack_indicator_background");
    @Unique
    private static final class_2960 HOTBAR_ATTACK_INDICATOR_PROGRESS_SPRITE = class_2960.method_60656((String)"hud/hotbar_attack_indicator_progress");

    @Unique
    private static Vector2i iteratePos(int index, int scale, int arm) {
        Vector2i vec = new Vector2i(0, 0);
        switch (index) {
            case 1: {
                return vec.add(-41 + scale, -31);
            }
            case 2: {
                return vec.add(-20 + scale, -41);
            }
            case 3: {
                return vec.add(scale, -41);
            }
            case 4: {
                return vec.add(21 + scale, -31);
            }
            case 5: {
                return vec.add(21 + scale, -11);
            }
            case 6: {
                return vec.add(scale, 0);
            }
            case 7: {
                return vec.add(-20 + scale, 0);
            }
            case 8: {
                return vec.add(4 - arm - scale, -20);
            }
        }
        return vec.add(-41 + scale, -11);
    }

    @Unique
    private static void renderSlot(class_332 guiGraphics, int x, int y, class_9779 deltaTracker, class_1657 player, class_1799 stack, int seed) {
        if (!stack.method_7960()) {
            float f = (float)stack.method_7965() - deltaTracker.method_60637(false);
            if (f > 0.0f) {
                float f1 = 1.0f + f / 5.0f;
                guiGraphics.method_51448().pushMatrix();
                guiGraphics.method_51448().translate((float)(x + 8), (float)(y + 12));
                guiGraphics.method_51448().scale(1.0f / f1, (f1 + 1.0f) / 2.0f);
                guiGraphics.method_51448().translate((float)(-(x + 8)), (float)(-(y + 12)));
            }
            guiGraphics.method_51423((class_1309)player, stack, x, y, seed);
            if (f > 0.0f) {
                guiGraphics.method_51448().popMatrix();
            }
            guiGraphics.method_51431(class_310.method_1551().field_1772, stack, x, y);
        }
    }

    @Inject(method={"method_1759"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderItemHotbar(class_332 guiGfx, class_9779 parTick, CallbackInfo ci) {
        class_310 mc = class_310.method_1551();
        if (GamepadHotbarClientConfig.GAMEPAD_HOTBAR_TOGGLE.isFalse() || mc.field_1690.field_1842) {
            return;
        }
        class_1297 entity = mc.method_1560();
        if (entity instanceof class_1657) {
            float f;
            int itemX;
            int baseX;
            int yPos;
            int xPos;
            class_1657 player = (class_1657)entity;
            ci.cancel();
            class_1799 offHand = player.method_6079();
            class_1306 offArm = player.method_6068().method_5928();
            int screenLeft = 43;
            int screenRight = guiGfx.method_51421() - screenLeft;
            int flipVar1 = 1;
            int flipVar2 = 0;
            int scaleVar = (Integer)GamepadHotbarClientConfig.PAD_X.get();
            if (GamepadHotbarClientConfig.MIRROR_MODE.getAsBoolean()) {
                screenRight = screenLeft;
                screenLeft = guiGfx.method_51421() - screenRight;
                scaleVar *= -1;
                flipVar1 *= -1;
                flipVar2 = 100;
            }
            if (GamepadHotbarClientConfig.SCALE_X.get() == HotbarScale.TYPE2) {
                screenLeft = guiGfx.method_51421() / 2 - 140 * flipVar1;
                screenRight = guiGfx.method_51421() / 2 + 140 * flipVar1;
            }
            if (GamepadHotbarClientConfig.SCALE_X.get() == HotbarScale.TYPE3) {
                screenLeft = guiGfx.method_51421() / 2 - 50 * flipVar1;
                screenRight = guiGfx.method_51421() / 2 + 50 * flipVar1;
            }
            if (GamepadHotbarClientConfig.SCALE_X.get() == HotbarScale.TYPE4) {
                screenLeft = 43 + flipVar2;
                screenRight = 143 - flipVar2;
            }
            if (GamepadHotbarClientConfig.SCALE_X.get() == HotbarScale.TYPE5) {
                screenLeft = guiGfx.method_51421() - 143 + flipVar2;
                screenRight = guiGfx.method_51421() - 43 - flipVar2;
            }
            int baseY = GamepadHotbarClientConfig.POS_Y.get() == HotbarPos.TOP ? 64 + (Integer)GamepadHotbarClientConfig.PAD_Y.get() : guiGfx.method_51443() - (Integer)GamepadHotbarClientConfig.PAD_Y.get();
            int slotY = baseY - 22;
            int selectY = slotY - 1;
            int itemY = slotY + 3;
            int armVar = offArm == class_1306.field_6183 ? 28 : 0;
            for (int i = 0; i < 5; ++i) {
                int uPos;
                int uWidth;
                switch (i) {
                    case 1: {
                        uWidth = 40;
                        uPos = 41;
                        xPos = -20 + scaleVar;
                        yPos = -41;
                        baseX = screenLeft;
                        guiGfx.method_51448().rotateAbout((float)Math.toRadians(90.0), (float)baseX, (float)slotY);
                        guiGfx.method_70846(class_10799.field_56883, HOTBAR_SPRITE, 182, 22, 0, 0, baseX + xPos - 1, slotY + yPos, 1, 22);
                        guiGfx.method_70846(class_10799.field_56883, HOTBAR_SPRITE, 182, 22, 181, 0, baseX + xPos + uWidth, slotY + yPos, 1, 22);
                        break;
                    }
                    case 2: {
                        uWidth = 40;
                        uPos = 81;
                        xPos = -30;
                        yPos = -42 - scaleVar;
                        baseX = screenLeft;
                        guiGfx.method_51448().rotateAbout((float)Math.toRadians(90.0), (float)baseX, (float)slotY);
                        guiGfx.method_70846(class_10799.field_56883, HOTBAR_SPRITE, 182, 22, 0, 0, baseX + xPos - 1, slotY + yPos, 1, 22);
                        guiGfx.method_70846(class_10799.field_56883, HOTBAR_SPRITE, 182, 22, 181, 0, baseX + xPos + uWidth, slotY + yPos, 1, 22);
                        break;
                    }
                    case 3: {
                        uWidth = 40;
                        uPos = 121;
                        xPos = -20 + scaleVar;
                        yPos = 0;
                        baseX = screenLeft;
                        guiGfx.method_51448().rotateAbout((float)Math.toRadians(-90.0), (float)baseX, (float)slotY);
                        guiGfx.method_70846(class_10799.field_56883, HOTBAR_SPRITE, 182, 22, 0, 0, baseX + xPos - 1, slotY + yPos, 1, 22);
                        guiGfx.method_70846(class_10799.field_56883, HOTBAR_SPRITE, 182, 22, 181, 0, baseX + xPos + uWidth, slotY + yPos, 1, 22);
                        break;
                    }
                    case 4: {
                        uWidth = 21;
                        uPos = 161;
                        xPos = 4 - armVar - scaleVar;
                        yPos = -20;
                        baseX = screenRight;
                        guiGfx.method_70846(class_10799.field_56883, HOTBAR_SPRITE, 182, 22, 0, 0, baseX + xPos - 1, slotY + yPos, 1, 22);
                        break;
                    }
                    default: {
                        uPos = 0;
                        uWidth = 41;
                        xPos = -11;
                        yPos = -42 + scaleVar;
                        baseX = screenLeft;
                        guiGfx.method_51448().rotateAbout((float)Math.toRadians(-90.0), (float)baseX, (float)slotY);
                        guiGfx.method_70846(class_10799.field_56883, HOTBAR_SPRITE, 182, 22, 181, 0, baseX + xPos + uWidth, slotY + yPos, 1, 22);
                    }
                }
                guiGfx.method_70846(class_10799.field_56883, HOTBAR_SPRITE, 182, 22, uPos, 0, baseX + xPos, slotY + yPos, uWidth, 22);
            }
            int selected = player.method_31548().method_67532();
            baseX = selected >= 0 && selected < 8 ? screenLeft : screenRight;
            int selectX = baseX - 2;
            xPos = HotbarMixin.iteratePos((int)selected, (int)scaleVar, (int)armVar).x;
            yPos = HotbarMixin.iteratePos((int)selected, (int)scaleVar, (int)armVar).y;
            guiGfx.method_52706(class_10799.field_56883, HOTBAR_SELECTION_SPRITE, selectX + xPos, selectY + yPos, 24, 23);
            if (!offHand.method_7960()) {
                if (offArm == class_1306.field_6182) {
                    guiGfx.method_52706(class_10799.field_56883, HOTBAR_OFFHAND_LEFT_SPRITE, screenRight + 4 - 29 - scaleVar, slotY - 21, 29, 24);
                } else {
                    guiGfx.method_52706(class_10799.field_56883, HOTBAR_OFFHAND_RIGHT_SPRITE, screenRight + 4 - armVar + 20 - scaleVar, slotY - 21, 29, 24);
                }
            }
            class_2960 tap = null;
            int tapOffset = 8;
            int color = class_9848.method_61318((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (GamepadHotbarClient.getLeft().method_1434() || GamepadHotbarClient.getRight().method_1434() || GamepadHotbarClient.getUp().method_1434() || GamepadHotbarClient.getDown().method_1434()) {
                color = class_9848.method_61318((float)1.0f, (float)1.0f, (float)0.8f, (float)0.0f);
            }
            if (selected == 0 || selected == 1) {
                tap = TAP_HOTBAR_LEFT;
                tapOffset = 17;
            }
            if (selected == 2 || selected == 3) {
                tap = TAP_HOTBAR_UP;
            }
            if (selected == 4 || selected == 5) {
                tap = TAP_HOTBAR_RIGHT;
                tapOffset = -1;
            }
            if (selected == 6 || selected == 7) {
                tap = TAP_HOTBAR_DOWN;
            }
            if (selected >= 0 && selected < 8) {
                guiGfx.method_52707(class_10799.field_56883, tap, baseX - tapOffset + scaleVar, slotY - 18, 16, 16, color);
            }
            int l = 1;
            for (int j = 0; j < 9; ++j) {
                xPos = HotbarMixin.iteratePos((int)j, (int)scaleVar, (int)armVar).x;
                yPos = HotbarMixin.iteratePos((int)j, (int)scaleVar, (int)armVar).y;
                itemX = j < 8 ? screenLeft + 2 : screenRight + 2;
                HotbarMixin.renderSlot(guiGfx, itemX + xPos, itemY + yPos, parTick, player, player.method_31548().method_5438(j), l++);
            }
            if (!offHand.method_7960()) {
                itemX = screenRight + 2;
                HotbarMixin.renderSlot(guiGfx, itemX - 24 + armVar - scaleVar, itemY - 20, parTick, player, offHand, l);
            }
            if (mc.field_1690.method_42565().method_41753() == class_4061.field_18153 && (f = player.method_7261(0.0f)) < 1.0f) {
                int j2 = baseY - 62;
                int k2 = screenRight + 5 - armVar - scaleVar;
                int l1 = (int)(f * 19.0f);
                guiGfx.method_52706(class_10799.field_56883, HOTBAR_ATTACK_INDICATOR_BACKGROUND_SPRITE, k2, j2, 18, 18);
                guiGfx.method_70846(class_10799.field_56883, HOTBAR_ATTACK_INDICATOR_PROGRESS_SPRITE, 18, 18, 0, 18 - l1, k2, j2 + 18 - l1, 18, l1);
            }
        }
    }
}

