/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.mrfrostydev.welcomeplayer.blocks.entities.BeaconBlockEntity;
import xyz.mrfrostydev.welcomeplayer.data.PlayerObjective;
import xyz.mrfrostydev.welcomeplayer.data.datagen.providers.datapacks.PlayerObjectives;
import xyz.mrfrostydev.welcomeplayer.registries.BlockRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.ItemRegistry;
import xyz.mrfrostydev.welcomeplayer.utils.ObjectiveUtil;

public class BeaconBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<BeaconBlock> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)BlockBehaviour.Properties.CODEC.fieldOf("properties").forGetter(BlockBehaviour::properties)).apply((Applicative)in, BeaconBlock::new));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty ACTIVATED = BooleanProperty.create((String)"activated");
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    protected static final VoxelShape SHAPE_BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_BASE_2_N = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)20.0, (double)8.0);
    protected static final VoxelShape SHAPE_BASE_2_S = Block.box((double)0.0, (double)12.0, (double)8.0, (double)16.0, (double)20.0, (double)16.0);
    protected static final VoxelShape SHAPE_BASE_2_E = Block.box((double)8.0, (double)12.0, (double)0.0, (double)16.0, (double)20.0, (double)16.0);
    protected static final VoxelShape SHAPE_BASE_2_W = Block.box((double)0.0, (double)12.0, (double)0.0, (double)8.0, (double)20.0, (double)16.0);

    public BeaconBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).setValue((Property)TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (((Boolean)state.getValue((Property)ACTIVATED)).booleanValue()) {
            if (level.isClientSide) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.welcomeplayer.beacon.already_active"), false);
            }
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        PlayerObjective objective = ObjectiveUtil.getGoingObjective(level);
        if (objective.is(level, PlayerObjectives.EXPLORER) || objective.is(level, PlayerObjectives.SURVEYOR) || objective.is(level, PlayerObjectives.EXPEDITION)) {
            if (stack.is(ItemRegistry.BATTERY)) {
                if (level instanceof ServerLevel) {
                    ServerLevel svlevel = (ServerLevel)level;
                    ObjectiveUtil.addProgress(svlevel, 1);
                }
                stack.consume(1, (LivingEntity)player);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                return ItemInteractionResult.SUCCESS;
            }
            if (level.isClientSide) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.welcomeplayer.beacon.need_battery"), false);
            }
        } else if (level.isClientSide) {
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.welcomeplayer.beacon.no_event"), false);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ACTIVATED, TOP});
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            return false;
        }
        return super.canSurvive(state, level, pos);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (((Boolean)state.getValue((Property)TOP)).booleanValue() && level.getBlockState(pos.below()).isEmpty()) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPosUp;
        Level level = context.getLevel();
        return level.getBlockState(blockPosUp = context.getClickedPos().above()).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(blockPosUp) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection()) : null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide) {
            level.setBlock(pos, (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(false)), 3);
            level.setBlock(pos.above(), (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(true)), 3);
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    protected RenderShape getRenderShape(BlockState state) {
        if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            return RenderShape.INVISIBLE;
        }
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            return Shapes.empty();
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        VoxelShape shape_2 = switch (direction) {
            case Direction.SOUTH -> SHAPE_BASE_2_S;
            case Direction.EAST -> SHAPE_BASE_2_E;
            case Direction.WEST -> SHAPE_BASE_2_W;
            default -> SHAPE_BASE_2_N;
        };
        return Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape)shape_2);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)TOP) == false ? new BeaconBlockEntity(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == BlockRegistry.BEACON_ENTITY.get() ? BeaconBlockEntity::tick : null;
    }
}

