/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ButtonPanelBlock
extends ButtonBlock {
    protected static final VoxelShape CEILING_AABB = Block.box((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape FLOOR_AABB = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0);

    public ButtonPanelBlock(BlockSetType type, int ticksToStayPressed, BlockBehaviour.Properties properties) {
        super(type, ticksToStayPressed, properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch ((AttachFace)state.getValue((Property)FACE)) {
            case FLOOR: {
                return FLOOR_AABB;
            }
            case WALL: {
                return switch (direction) {
                    default -> throw new MatchException(null, null);
                    case Direction.EAST -> EAST_AABB;
                    case Direction.WEST -> WEST_AABB;
                    case Direction.SOUTH -> SOUTH_AABB;
                    case Direction.NORTH, Direction.UP, Direction.DOWN -> NORTH_AABB;
                };
            }
        }
        return CEILING_AABB;
    }
}

