/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.mrfrostydev.welcomeplayer.network.StartShowIntroductionPacket;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceUtil;

public class ShowActivatorBlock
extends HorizontalDirectionalBlock {
    public static final BooleanProperty ACTIVATED = BooleanProperty.create((String)"activated");

    public ShowActivatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        ServerLevel svlevel;
        if (level instanceof ServerLevel && AudienceUtil.isActive(svlevel = level) && !((Boolean)state.getValue((Property)ACTIVATED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        if (level instanceof ServerLevel) {
            ServerLevel svlevel = (ServerLevel)level;
            if (level.hasNeighborSignal(pos) && !((Boolean)state.getValue((Property)ACTIVATED)).booleanValue() && !AudienceUtil.isActive(svlevel)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new StartShowIntroductionPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVATED, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return ShowActivatorBlock.simpleCodec(ShowActivatorBlock::new);
    }
}

