/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import xyz.mrfrostydev.welcomeplayer.blocks.entities.VendorBlockEntity;
import xyz.mrfrostydev.welcomeplayer.network.ServerVendorMenuPacket;
import xyz.mrfrostydev.welcomeplayer.registries.BlockRegistry;
import xyz.mrfrostydev.welcomeplayer.utils.VendorUtil;

public class VendorBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<VendorBlock> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)BlockBehaviour.Properties.CODEC.fieldOf("properties").forGetter(BlockBehaviour::properties), (App)Codec.BOOL.fieldOf("top").forGetter(VendorBlock::isTop)).apply((Applicative)in, VendorBlock::new));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");

    public VendorBlock(BlockBehaviour.Properties properties, boolean isTop) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TOP, (Comparable)Boolean.valueOf(isTop)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TOP});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        super.useWithoutItem(state, level, pos, player, hitResult);
        if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            BlockPos neighbourBlockPos = pos.below();
            BlockEntity blockEntity = level.getBlockEntity(neighbourBlockPos);
            if (blockEntity instanceof VendorBlockEntity) {
                VendorBlockEntity neighbourBlockEntity = (VendorBlockEntity)blockEntity;
                if (!neighbourBlockEntity.isActive()) {
                    return InteractionResult.FAIL;
                }
                player.openMenu((MenuProvider)neighbourBlockEntity, neighbourBlockPos);
            }
        } else {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof VendorBlockEntity)) {
                return InteractionResult.FAIL;
            }
            VendorBlockEntity blockEntity2 = (VendorBlockEntity)blockEntity;
            if (!blockEntity2.isActive()) {
                return InteractionResult.FAIL;
            }
            player.openMenu((MenuProvider)blockEntity2, pos);
        }
        if (!level.isClientSide()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ServerVendorMenuPacket(VendorUtil.getVendorShopItems((ServerLevel)level)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        player.playSound(SoundEvents.AMETHYST_BLOCK_CHIME);
        return InteractionResult.CONSUME;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockPos topPos = pos.above();
        BlockPos belowPos = pos.below();
        if (level.getBlockState(topPos).is(BlockRegistry.VENDOR_TOP)) {
            level.destroyBlock(topPos, false);
        }
        if (level.getBlockState(belowPos).is(BlockRegistry.VENDOR_BOTTOM)) {
            level.destroyBlock(belowPos, false);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public boolean isTop() {
        return (Boolean)this.defaultBlockState().getValue((Property)TOP);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return !this.isTop() ? new VendorBlockEntity(pos, state) : null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == BlockRegistry.VENDOR_ENTITY.get() ? VendorBlockEntity::tick : null;
    }
}

