/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.blocks.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import xyz.mrfrostydev.welcomeplayer.registries.BlockRegistry;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceUtil;

public class HostScreenBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private boolean isActive = false;
    private final AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation INACTIVE_ANIM = RawAnimation.begin().thenPlay("host_screen.animation.inactive");
    private static final RawAnimation ACTIVE_ANIM = RawAnimation.begin().thenPlay("host_screen.animation.active");

    public HostScreenBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockRegistry.HOST_SCREEN_ENTITY.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity entity) {
        if (!(entity instanceof HostScreenBlockEntity)) {
            return;
        }
        HostScreenBlockEntity blockEntity = (HostScreenBlockEntity)entity;
        if (blockEntity.isActive()) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel svlevel = (ServerLevel)level;
            if (AudienceUtil.isActive(svlevel)) {
                blockEntity.isActive = true;
            }
            BlockState newState = level.getBlockState(pos);
            blockEntity.setChanged();
            level.setBlockAndUpdate(pos, state);
            level.sendBlockUpdated(pos, newState, newState, 3);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.isActive = tag.getBoolean("isActive");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("isActive", this.isActive);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(connection, packet, registries);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::handleAnimation));
    }

    private <T extends GeoBlockEntity> PlayState handleAnimation(AnimationState<T> state) {
        if (this.isActive) {
            return state.setAndContinue(ACTIVE_ANIM);
        }
        return state.setAndContinue(INACTIVE_ANIM);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }
}

