/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.blocks.entities;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import xyz.mrfrostydev.welcomeplayer.client.gui.menus.blocks.MaterialTransitMenu;
import xyz.mrfrostydev.welcomeplayer.data.PlayerObjective;
import xyz.mrfrostydev.welcomeplayer.data.datagen.providers.datapacks.PlayerObjectives;
import xyz.mrfrostydev.welcomeplayer.registries.BlockRegistry;
import xyz.mrfrostydev.welcomeplayer.utils.ObjectiveUtil;

public class MaterialTransitBlockEntity
extends BlockEntity
implements IItemHandler,
MenuProvider,
GeoBlockEntity {
    public static final int CONTAINER_SIZE = 3;
    public static final int TRANSFER_TIME = 240;
    public ItemStackHandler itemContainer;
    private int progress;
    private boolean opened;
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            return MaterialTransitBlockEntity.this.progress;
        }

        public void set(int index, int value) {
            MaterialTransitBlockEntity.this.progress = value;
        }

        public int getCount() {
            return 1;
        }
    };
    private final AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation OPEN_ANIM = RawAnimation.begin().thenPlay("material_transit.animation.open");
    private static final RawAnimation CLOSE_ANIM = RawAnimation.begin().thenPlay("material_transit.animation.close");

    public MaterialTransitBlockEntity(final BlockPos pos, BlockState blockState) {
        super(BlockRegistry.MATERIAL_TRANSIT_ENTITY.get(), pos, blockState);
        this.itemContainer = new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                if (MaterialTransitBlockEntity.this.level != null) {
                    MaterialTransitBlockEntity.this.progress = 0;
                    MaterialTransitBlockEntity.this.level.sendBlockUpdated(pos, MaterialTransitBlockEntity.this.getBlockState(), MaterialTransitBlockEntity.this.getBlockState(), 3);
                    MaterialTransitBlockEntity.this.setChanged();
                }
            }
        };
        this.progress = 0;
        this.opened = false;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity entity) {
        if (!(entity instanceof MaterialTransitBlockEntity)) {
            return;
        }
        MaterialTransitBlockEntity blockEntity = (MaterialTransitBlockEntity)entity;
        if (level.isClientSide()) {
            return;
        }
        PlayerObjective objective = ObjectiveUtil.getGoingObjective(level);
        ArrayList<ItemStack> targetStacks = new ArrayList<ItemStack>(3);
        for (int i = 0; i < blockEntity.getSlots(); ++i) {
            ItemStack stack = MaterialTransitBlockEntity.getStackIfObjectiveMatch(level, objective, blockEntity.itemContainer.getStackInSlot(i));
            if (stack.isEmpty()) continue;
            targetStacks.add(stack);
        }
        if (!targetStacks.isEmpty()) {
            ++blockEntity.progress;
            if (blockEntity.progress >= 240) {
                blockEntity.completeTransit(targetStacks);
                blockEntity.progress = 0;
                targetStacks.clear();
            }
            blockEntity.setChanged();
        }
    }

    public void setOpen() {
        this.opened = true;
    }

    public void setClose() {
        this.opened = false;
    }

    public void completeTransit(List<ItemStack> stacks) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel svlevel = (ServerLevel)level;
            int addedProgress = 0;
            PlayerObjective obj = ObjectiveUtil.getGoingObjective(svlevel);
            if (obj.is((Level)svlevel, PlayerObjectives.RATIONING) || obj.is((Level)svlevel, PlayerObjectives.CARNIFEROUS_CROWD)) {
                for (ItemStack stack : stacks) {
                    FoodProperties food = (FoodProperties)stack.getOrDefault(DataComponents.FOOD, (Object)new FoodProperties(0, 0.0f, false, 0.0f, Optional.empty(), (List)ImmutableList.of()));
                    addedProgress += food.nutrition() * stack.getCount();
                    stack.setCount(0);
                }
            } else {
                for (ItemStack stack : stacks) {
                    addedProgress += stack.getCount();
                    stack.setCount(0);
                }
            }
            ObjectiveUtil.addProgress(svlevel, addedProgress);
        }
    }

    private static ItemStack getStackIfObjectiveMatch(Level level, PlayerObjective obj, ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (ObjectiveUtil.compareStackWithObjective(level, obj, stack)) {
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public int getProgress() {
        return this.progress;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("progress", this.progress);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.progress = tag.getInt("progress");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(connection, packet, registries);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::handleAnimation));
    }

    private <T extends GeoBlockEntity> PlayState handleAnimation(AnimationState<T> state) {
        if (this.opened) {
            return state.setAndContinue(OPEN_ANIM);
        }
        return state.setAndContinue(CLOSE_ANIM);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.welcomeplayer.material_transit");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new MaterialTransitMenu(containerId, playerInventory, this, this.data, ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.worldPosition));
    }

    public int getSlots() {
        return 3;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.itemContainer.getStackInSlot(slot).copy();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack itemStack = stack.copy();
        return this.itemContainer.insertItem(slot, itemStack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack returnItem;
        ItemStack targetStack = this.itemContainer.getStackInSlot(slot);
        if (amount < targetStack.getCount()) {
            returnItem = targetStack.copy();
            returnItem.setCount(amount);
            targetStack.setCount(targetStack.getCount() - amount);
        } else {
            returnItem = targetStack.copy();
            this.itemContainer.setStackInSlot(slot, ItemStack.EMPTY);
        }
        return returnItem;
    }

    public int getSlotLimit(int slot) {
        return this.itemContainer.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }
}

