/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.blocks.entities;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import xyz.mrfrostydev.welcomeplayer.damages.ShockDamageSource;
import xyz.mrfrostydev.welcomeplayer.data.datagen.providers.datapacks.ModDamageTypes;
import xyz.mrfrostydev.welcomeplayer.entities.projectiles.ShockBoltProjectile;
import xyz.mrfrostydev.welcomeplayer.registries.BlockRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.SoundEventRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.TagRegistry;

public class TeslaBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private static final float COIL_RANGE = 3.2f;
    private static final float TICK_COOLDOWN = 30.0f;
    private final AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public TeslaBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockRegistry.RETRO_TESLA_COIL_ENTITY.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity entity) {
        if (!(entity instanceof TeslaBlockEntity)) {
            return;
        }
        TeslaBlockEntity blockEntity = (TeslaBlockEntity)entity;
        if (level instanceof ServerLevel) {
            int tick = ((ServerLevel)level).getServer().getTickCount();
            if ((float)tick % 30.0f == 0.0f) {
                AABB area = new AABB(pos.above()).inflate((double)3.2f);
                List entities = level.getEntities((Entity)null, area, e -> !e.getType().is(TagRegistry.HOST_ROBOT) && !e.isSpectator());
                for (Entity e2 : entities) {
                    if (!(e2 instanceof LivingEntity)) continue;
                    LivingEntity target = (LivingEntity)e2;
                    Vec3 shootPos = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 1.7, (double)pos.getZ() + 0.5);
                    ShockBoltProjectile shockBolt = new ShockBoltProjectile(level, null, shootPos, new Vec3(e2.getX(), e2.getEyeY() - 0.2, e2.getZ()));
                    level.addFreshEntity((Entity)shockBolt);
                    target.hurt((DamageSource)new ShockDamageSource((Holder<DamageType>)level.registryAccess().holderOrThrow(ModDamageTypes.SHOCK), null), 6.0f);
                    LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                    lightning.setDamage(0.0f);
                    target.thunderHit((ServerLevel)level, lightning);
                }
            }
            if (tick % 16 == 0) {
                level.playSound(null, pos.above(), (SoundEvent)SoundEventRegistry.SHOCK_HUM.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(connection, packet, registries);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }
}

