/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.blocks.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import xyz.mrfrostydev.welcomeplayer.client.gui.menus.blocks.VendorMenu;
import xyz.mrfrostydev.welcomeplayer.registries.BlockRegistry;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceUtil;
import xyz.mrfrostydev.welcomeplayer.utils.VendorUtil;

public class VendorBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int CONTAINER_SIZE = 16;
    private boolean isActive = true;
    private int interest = 0;
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            return VendorBlockEntity.this.interest;
        }

        public void set(int index, int value) {
        }

        public int getCount() {
            return 1;
        }
    };

    public VendorBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockRegistry.VENDOR_ENTITY.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity entity) {
        if (!(entity instanceof VendorBlockEntity)) {
            return;
        }
        VendorBlockEntity blockEntity = (VendorBlockEntity)entity;
        if (level instanceof ServerLevel) {
            ServerLevel svlevel = (ServerLevel)level;
            blockEntity.isActive = true;
            int global = AudienceUtil.getInterest(svlevel);
            if (global > blockEntity.interest) {
                blockEntity.interest = global;
            }
        }
        level.sendBlockUpdated(pos, state, state, 2);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.isActive = tag.getBoolean("isActive");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("isActive", this.isActive);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(connection, packet, registries);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.welcomeplayer.vendor");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel svlevel = (ServerLevel)level;
            return new VendorMenu(containerId, playerInventory, this, VendorUtil.getVendorShopItems(svlevel), this.data, ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.worldPosition));
        }
        return null;
    }
}

