/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.client.gui.menus.blocks;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import xyz.mrfrostydev.welcomeplayer.blocks.entities.MaterialTransitBlockEntity;
import xyz.mrfrostydev.welcomeplayer.registries.BlockRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.MenuRegistry;

public class MaterialTransitMenu
extends AbstractContainerMenu {
    public final MaterialTransitBlockEntity blockEntity;
    public final ContainerLevelAccess access;
    public final ContainerData data;

    public MaterialTransitMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, MaterialTransitMenu.getBlockEntity(inv, extraData), (ContainerData)new SimpleContainerData(3), ContainerLevelAccess.NULL);
    }

    public MaterialTransitMenu(int id, Inventory plyInventory, MaterialTransitBlockEntity blockEntity, ContainerData data, ContainerLevelAccess access) {
        super(MenuRegistry.MATERIAL_TRANSIT_MENU.get(), id);
        int i;
        this.blockEntity = blockEntity;
        MaterialTransitMenu.checkContainerDataCount((ContainerData)data, (int)1);
        this.data = data;
        this.access = access;
        for (i = 0; i < 3; ++i) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)blockEntity.itemContainer, i, 84 + i * 22, 56));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)plyInventory, j + i * 9 + 9, 34 + j * 18, 85 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)plyInventory, k, 34 + k * 18, 143));
        }
        this.addDataSlots(data);
        this.blockEntity.setOpen();
    }

    private static MaterialTransitBlockEntity getBlockEntity(Inventory plyInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(plyInventory, "plyInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockAtPos = plyInventory.player.level().getBlockEntity(data.readBlockPos());
        if (blockAtPos instanceof MaterialTransitBlockEntity) {
            return (MaterialTransitBlockEntity)blockAtPos;
        }
        throw new IllegalStateException("The block entity is not correct at MaterialTransit#getBlockEntity " + String.valueOf(blockAtPos));
    }

    public ItemStack quickMoveStack(Player player, int selectedSlotIndex) {
        ItemStack selectedStack = ItemStack.EMPTY;
        Slot selectedSlot = (Slot)this.slots.get(selectedSlotIndex);
        if (selectedSlot == null || !selectedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack rawStack = selectedSlot.getItem();
        selectedStack = rawStack.copy();
        if (selectedSlotIndex >= 0 && selectedSlotIndex < 3 ? !this.moveItemStackTo(rawStack, 3, 39, true) : selectedSlotIndex >= 3 && selectedSlotIndex < 39 && !this.moveItemStackTo(rawStack, 0, 3, false) && (selectedSlotIndex < 30 ? !this.moveItemStackTo(rawStack, 30, 39, false) : !this.moveItemStackTo(rawStack, 3, 30, false))) {
            return ItemStack.EMPTY;
        }
        if (rawStack.isEmpty()) {
            selectedSlot.set(ItemStack.EMPTY);
        } else {
            selectedSlot.setChanged();
        }
        if (rawStack.getCount() == selectedStack.getCount()) {
            return ItemStack.EMPTY;
        }
        selectedSlot.onTake(player, rawStack);
        return selectedStack;
    }

    public float getProgress() {
        int i = this.data.get(0);
        return i != 0 ? Mth.clamp((float)((float)i / 240.0f), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public void removed(Player player) {
        super.removed(player);
        this.blockEntity.setClose();
    }

    public boolean stillValid(Player player) {
        return MaterialTransitMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.MATERIAL_TRANSIT.get()));
    }
}

