/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.client.gui.menus.blocks;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import xyz.mrfrostydev.welcomeplayer.client.gui.menus.blocks.MaterialTransitMenu;

public class MaterialTransitScreen
extends AbstractContainerScreen<MaterialTransitMenu> {
    private static final ResourceLocation MENU_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"textures/gui/container/material_transit_menu.png");
    private static final ResourceLocation PROGRESS_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"container/material_transit/progress");
    public static final int PROGRESS_WIDTH = 40;
    public static final int PROGRESS_HEIGHT = 32;
    private final MaterialTransitMenu menu;
    private Inventory plyInventory;
    protected Player player;

    public MaterialTransitScreen(MaterialTransitMenu menu, Inventory plyInventory, Component title) {
        super((AbstractContainerMenu)menu, plyInventory, (Component)Component.empty());
        this.plyInventory = plyInventory;
        this.menu = menu;
        this.player = plyInventory.player;
        this.imageWidth = 228;
        this.imageHeight = 178;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int posX = (this.width - this.imageWidth) / 2;
        int posY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(MENU_RESOURCE, posX, posY, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int posX = Mth.ceil((float)(this.width - 40)) / 2;
        int posY = Mth.ceil((float)(this.height - 32)) / 2 - 28;
        int progressInPixels = Mth.ceil((float)(this.menu.getProgress() * 32.0f));
        guiGraphics.blitSprite(PROGRESS_RESOURCE, 40, 32, 0, 32 - progressInPixels, posX, posY - progressInPixels, 40, progressInPixels);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }
}

