/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.client.gui.menus.blocks;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.mrfrostydev.welcomeplayer.client.gui.menus.blocks.VendorMenu;
import xyz.mrfrostydev.welcomeplayer.data.VendorItem;
import xyz.mrfrostydev.welcomeplayer.network.ClientVendorUpdatePacket;
import xyz.mrfrostydev.welcomeplayer.utils.ClientUtil;
import xyz.mrfrostydev.welcomeplayer.utils.GraphicUtil;
import xyz.mrfrostydev.welcomeplayer.utils.VendorUtil;

public class VendorScreen
extends AbstractContainerScreen<VendorMenu> {
    private static final ResourceLocation MENU_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"textures/gui/container/vendor_menu.png");
    private static final ResourceLocation SPEECH_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"container/vendor/speech_bubble");
    private static final ResourceLocation UNLOCK_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"container/vendor/unlock");
    private static final ResourceLocation UNLOCK_HOVER_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"container/vendor/unlock_hover");
    private static final ResourceLocation VENDOR_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"container/vendor/vendor");
    private static final ResourceLocation VENDOR_OFFER_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"container/vendor/vendor_offer");
    private static final int[] VENDOR_ANIM = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65};
    private static final int UNLOCK_TEXTURE_WIDTH = 34;
    private static final int UNLOCK_TEXTURE_HEIGHT = 24;
    private static final int SPEECH_TEXTURE_WIDTH = 60;
    private static final int SPEECH_TEXTURE_HEIGHT = 39;
    private static final int VENDOR_TEXTURE_WIDTH = 74;
    private static final int VENDOR_TEXTURE_HEIGHT = 65;
    private final VendorMenu menu;
    private Inventory plyInventory;
    private boolean hoveringOption;
    protected Player player;

    public VendorScreen(VendorMenu menu, Inventory plyInventory, Component title) {
        super((AbstractContainerMenu)menu, plyInventory, (Component)Component.empty());
        this.plyInventory = plyInventory;
        this.menu = menu;
        this.player = plyInventory.player;
        this.hoveringOption = false;
        this.imageWidth = 228;
        this.imageHeight = 178;
    }

    protected void init() {
        super.init();
        int posX = this.width / 2 - 95;
        int posY = this.height / 2 - 72;
        for (int i = 0; i < 16; ++i) {
            if (i % 4 == 0 && i != 0) {
                posY += 29;
                posX = this.width / 2 - 95;
            }
            this.addRenderableWidget((GuiEventListener)new VendorOptionWidget(i, posX, posY, 34, 24, null));
            posX += 36;
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int posX = (this.width - this.imageWidth) / 2;
        int posY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(MENU_RESOURCE, posX, posY, 0, 0, this.imageWidth, this.imageHeight);
        int venderOffsetX = 162;
        int venderOffsetY = 80;
        if (this.hoveringOption) {
            guiGraphics.blitSprite(VENDOR_OFFER_SPRITE, 74, 130, 0, VENDOR_ANIM[ClientUtil.getRenderTick() % VENDOR_ANIM.length], posX + venderOffsetX, posY + venderOffsetY, 74, 65);
            this.hoveringOption = false;
        } else {
            guiGraphics.blitSprite(VENDOR_SPRITE, 74, 130, 0, VENDOR_ANIM[ClientUtil.getRenderTick() % VENDOR_ANIM.length], posX + venderOffsetX, posY + venderOffsetY, 74, 65);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        MutableComponent balanceComp = Component.translatable((String)"block.welcomeplayer.vendor.balance").append((Component)Component.literal((String)("" + VendorUtil.getBatteryBalance(this.plyInventory))));
        guiGraphics.drawString(this.font, (Component)balanceComp, guiGraphics.guiWidth() / 2 - 87, guiGraphics.guiHeight() / 2 + 56, 9115929, false);
    }

    private class VendorOptionWidget
    extends AbstractWidget {
        private int index;

        public VendorOptionWidget(int index, int x, int y, int width, int height, Component message) {
            super(x, y, width, height, message);
            this.index = index;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.shopItemAvailable()) {
                this.active = true;
                VendorItem shopItem = VendorScreen.this.menu.getShopItems().get(this.index);
                ItemStack focusStack = shopItem.getItem();
                if (this.isHovered) {
                    int posX = 56;
                    int posY = -55;
                    guiGraphics.blitSprite(UNLOCK_HOVER_SPRITE, this.getX(), this.getY(), 34, 24);
                    guiGraphics.blitSprite(SPEECH_SPRITE, guiGraphics.guiWidth() / 2 + posX, guiGraphics.guiHeight() / 2 + posY, 60, 39);
                    MutableComponent c = Component.translatable((String)focusStack.getDescriptionId()).withStyle(Style.EMPTY.withColor(9115929));
                    List formatted = VendorScreen.this.font.split((FormattedText)c, 52);
                    float scaleText = 1.0f;
                    Objects.requireNonNull(VendorScreen.this.font);
                    int yOffsetAmount = Mth.ceil((float)(9.0f * scaleText));
                    boolean xOffset = false;
                    int yOffset = 0;
                    for (FormattedCharSequence line : formatted) {
                        GraphicUtil.drawStringWithScale(guiGraphics, VendorScreen.this.font, line, (float)guiGraphics.guiWidth() / 2.0f + (float)posX + 4.0f + (float)xOffset, (float)guiGraphics.guiHeight() / 2.0f + (float)posY + 4.0f + (float)yOffset, scaleText, 0, false);
                        yOffset += yOffsetAmount;
                    }
                    MutableComponent priceComp = Component.literal((String)"$").withColor(9115929).append((Component)Component.literal((String)String.valueOf(shopItem.price())).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))).withColor(9115929));
                    guiGraphics.drawString(VendorScreen.this.font, (Component)priceComp, guiGraphics.guiWidth() / 2 + posX + 4, guiGraphics.guiHeight() / 2 + posY + 23, 0, false);
                    VendorScreen.this.hoveringOption = true;
                } else {
                    guiGraphics.blitSprite(UNLOCK_SPRITE, this.getX(), this.getY(), 34, 24);
                }
                int posXItem = this.getX() + 9;
                int posYItem = this.getY() + (this.height - 16) / 2 + 1;
                guiGraphics.renderItem(focusStack, posXItem, posYItem);
                guiGraphics.renderItemDecorations(VendorScreen.this.font, focusStack, posXItem, posYItem);
            } else {
                this.active = false;
            }
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void onClick(double mouseX, double mouseY, int button) {
            if (this.shopItemAvailable()) {
                ItemStack focusStack = VendorScreen.this.menu.getShopItems().get(this.index).getItem();
                int price = VendorScreen.this.menu.getShopItems().get(this.index).price();
                if (VendorUtil.tryPurchase(VendorScreen.this.plyInventory, price)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)ClientVendorUpdatePacket.create(focusStack, price), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        private boolean shopItemAvailable() {
            return VendorScreen.this.menu.getShopItems().size() > this.index && VendorScreen.this.menu.data.get(0) >= VendorScreen.this.menu.getShopItems().get(this.index).minInterest();
        }
    }
}

