/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.client.gui.overlays;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import xyz.mrfrostydev.welcomeplayer.data.AudienceData;
import xyz.mrfrostydev.welcomeplayer.data.AudienceEvent;
import xyz.mrfrostydev.welcomeplayer.data.ClientAudienceData;
import xyz.mrfrostydev.welcomeplayer.data.datagen.providers.datapacks.AudienceEvents;

public class CommercialOverlay
implements LayeredDraw.Layer {
    public static Random RANDOM = new Random();
    private static final int MAX_ADS = 6;
    private static final int MAX_DURATION = 2400;
    private static final ResourceLocation AD_0_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"advertisements/ad_0");
    private static final ResourceLocation AD_1_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"advertisements/ad_1");
    private static final ResourceLocation AD_2_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"advertisements/ad_2");
    private static final ResourceLocation AD_3_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"advertisements/ad_3");
    private static final ResourceLocation AD_4_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"advertisements/ad_4");
    private static final List<ResourceLocation> AVAILABLE_ADS = List.of(AD_0_SPRITE, AD_1_SPRITE, AD_2_SPRITE, AD_3_SPRITE, AD_4_SPRITE);
    private static final int AD_TEXTURE_WIDTH = 129;
    private static final int AD_TEXTURE_HEIGHT = 101;
    private Minecraft minecraft = Minecraft.getInstance();
    private static List<Ad> activeAds = new ArrayList<Ad>(6);
    private int cooldown = 0;

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LocalPlayer player = Minecraft.getInstance().player;
        AudienceData data = ClientAudienceData.get();
        AudienceEvent goingEvent = data.getEventManager().getGoingEvent();
        for (Ad ad : activeAds) {
            if (ad.duration <= 0) continue;
            --ad.duration;
        }
        if (!goingEvent.is(AudienceEvents.COMMERCIAL_BREAK)) {
            return;
        }
        if (player == null) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        for (int i = activeAds.size() - 1; i >= 0; --i) {
            Ad ad;
            ad = activeAds.get(i);
            ad.render(guiGraphics, deltaTracker);
            if (ad.duration > 0) continue;
            activeAds.remove(i);
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if ((int)(Math.random() * 20.0) == 0 && this.cooldown <= 0 && activeAds.size() <= 6) {
            this.cooldown = 600;
            ResourceLocation resource = AVAILABLE_ADS.get(RANDOM.nextInt(AVAILABLE_ADS.size()));
            int durationHalf = 1200;
            Ad in = new Ad(resource, (int)(Math.random() * (double)durationHalf + (double)durationHalf), (int)Math.clamp(Math.random() * (double)guiGraphics.guiWidth(), 20.0, (double)(guiGraphics.guiWidth() - 129 - 20)), (int)Math.clamp(Math.random() * (double)guiGraphics.guiHeight(), 20.0, (double)(guiGraphics.guiHeight() - 101 - 20)));
            activeAds.add(in);
        }
    }

    private static class Ad {
        ResourceLocation resource;
        int duration;
        int x;
        int y;

        public Ad(ResourceLocation resource, int duration, int x, int y) {
            this.resource = resource;
            this.duration = duration;
            this.x = x;
            this.y = y;
        }

        public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            float scale = (float)guiGraphics.guiWidth() / 480.0f;
            int posX = (int)((float)this.x / scale);
            int posY = (int)((float)this.y / scale);
            pose.scale(scale, scale, scale);
            guiGraphics.blitSprite(this.resource, 129, 101, 0, 0, posX, posY, 129, 101);
            pose.popPose();
        }
    }
}

