/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.client.gui.overlays;

import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import xyz.mrfrostydev.welcomeplayer.data.ClientObjectiveData;
import xyz.mrfrostydev.welcomeplayer.data.ObjectiveManagerData;
import xyz.mrfrostydev.welcomeplayer.data.PlayerObjective;
import xyz.mrfrostydev.welcomeplayer.utils.GraphicUtil;
import xyz.mrfrostydev.welcomeplayer.utils.TextReader;

public class ObjectiveTrackerOverlay
implements LayeredDraw.Layer {
    private static final ResourceLocation BACK_BAR_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"objective_back_bar");
    private static final ResourceLocation PROGRESS_BAR_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"objective_progress_bar");
    private static final int TIME_PER_CHAR = 6;
    private final int MAX_LINE_WIDTH = 180;
    private Minecraft minecraft;
    private Font font;
    private PlayerObjective objective;
    private TextReader textReader = new TextReader(6);
    private static final int BACK_BAR_WIDTH = 46;
    private static final int BACK_BAR_HEIGHT = 9;
    private static final int PROGRESS_BAR_WIDTH = 42;
    private static final int PROGRESS_BAR_HEIGHT = 5;

    public ObjectiveTrackerOverlay() {
        this.minecraft = Minecraft.getInstance();
        this.font = Minecraft.getInstance().font;
        this.objective = PlayerObjective.NOTHING;
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        ObjectiveManagerData data = ClientObjectiveData.get();
        if (data.getGoingObjective().is(PlayerObjective.NOTHING)) {
            this.objective = data.getGoingObjective();
            return;
        }
        if (!data.getGoingObjective().is(this.objective)) {
            this.objective = data.getGoingObjective();
            this.textReader.addPermenantText(Component.translatable((String)("objective.welcomeplayer." + this.objective.id()), (Object[])new Object[]{data.getMaxProgress()}).getString());
        }
        this.textReader.tick();
        this.renderBar(guiGraphics, data);
        this.renderText(guiGraphics);
    }

    public void renderText(GuiGraphics guiGraphics) {
        int posX = 15;
        int posY = guiGraphics.guiHeight() / 2 - 40;
        if (this.font.getSplitter().stringWidth(this.textReader.getDisplayText()) > 180.0f) {
            Objects.requireNonNull(this.font);
            posY -= 9;
        }
        int yOffset = 0;
        for (FormattedCharSequence displayTextSeparated : this.font.split((FormattedText)Component.literal((String)this.textReader.getDisplayText()), 180)) {
            GraphicUtil.drawStringWithScale(guiGraphics, this.font, displayTextSeparated, (float)posX, (float)(posY + yOffset), 0.8f, 16410922, true);
            Objects.requireNonNull(this.font);
            yOffset += 9;
        }
    }

    public void renderBar(GuiGraphics guiGraphics, ObjectiveManagerData data) {
        int progress = data.getProgress();
        int maxProgress = data.getMaxProgress();
        int progressBarWidth = Mth.ceil((double)(42.0 * Math.min((double)progress / Math.max(1.0, (double)maxProgress), 1.0)));
        int posX = 15;
        int posY = guiGraphics.guiHeight() / 2 - 30;
        guiGraphics.blitSprite(BACK_BAR_SPRITE, 46, 9, 0, 0, posX, posY, 46, 9);
        guiGraphics.blitSprite(PROGRESS_BAR_SPRITE, 46, 5, 0, 0, posX + 2, posY + 2, progressBarWidth, 5);
    }
}

