/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.client.gui.overlays;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayDeque;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import software.bernie.geckolib.util.RenderUtil;
import xyz.mrfrostydev.welcomeplayer.data.ClientAudienceData;
import xyz.mrfrostydev.welcomeplayer.network.StartShowIntroductionPacket;
import xyz.mrfrostydev.welcomeplayer.registries.SoundEventRegistry;
import xyz.mrfrostydev.welcomeplayer.utils.AnimatedImage;
import xyz.mrfrostydev.welcomeplayer.utils.TextReader;

public class ShowHostMessageOverlay
implements LayeredDraw.Layer {
    private static final ResourceLocation ANNOUNCER_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"textures/gui/overlays/announcer_talk.png");
    private static final int ANNOUNCER_WIDTH = 100;
    private static final int ANNOUNCER_HEIGHT = 272;
    private static final int TIME_PER_CHAR = 7;
    private final int MAX_LINE_WIDTH = 150;
    private final AnimatedImage announcerImage;
    private static ArrayDeque<String> dialogDeque;
    private static boolean isIntro;
    private TextReader textReader = new TextReader(7);
    private Minecraft minecraft;
    private Font font;

    public ShowHostMessageOverlay() {
        dialogDeque = new ArrayDeque();
        isIntro = false;
        this.minecraft = Minecraft.getInstance();
        this.font = Minecraft.getInstance().font;
        this.announcerImage = new AnimatedImage(ANNOUNCER_RESOURCE, 10, 100, 272, 4);
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!dialogDeque.isEmpty()) {
            this.textReader.addText(dialogDeque.pop(), !ClientAudienceData.get().isActive() ? 9 : 7);
        }
        if (isIntro && this.textReader.getDialogQueue().isEmpty()) {
            isIntro = false;
            PacketDistributor.sendToServer((CustomPacketPayload)new StartShowIntroductionPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.announcerImage.render(guiGraphics, (int)RenderUtil.getCurrentTick(), 1.0f);
        this.textReader.tick();
        if (this.textReader.getMessageTime() > 0) {
            int posX = (guiGraphics.guiWidth() - 100) / 2;
            int posY = (int)((double)guiGraphics.guiHeight() * 0.1);
            this.announcerImage.setPosition(posX, posY);
            this.announcerImage.playLoop();
            this.announcerImage.setVisible(true);
            this.renderAnimatedText(guiGraphics);
        } else {
            this.announcerImage.setVisible(false);
            this.announcerImage.stop();
        }
    }

    private void renderAnimatedText(GuiGraphics guiGraphics) {
        if (Minecraft.getInstance().options.hideGui || Minecraft.getInstance().player == null || Minecraft.getInstance().player.isSpectator()) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        LocalPlayer player = Minecraft.getInstance().player;
        int tick = player.tickCount;
        float scaleX = 2.0f;
        float scaleY = 2.5f;
        float halfWidth = (float)guiGraphics.guiWidth() / 2.0f;
        float halfHeight = (float)guiGraphics.guiHeight() / 2.0f;
        float scaledWidth = halfWidth * scaleX - halfWidth;
        float scaledHeight = halfHeight * scaleY - halfHeight;
        float rotDegrees = (float)(5.0 * Math.cos((double)tick / 9.0));
        float scaledOffsetX = -scaledWidth / scaleX;
        float scaledOffsetY = -scaledHeight / scaleY;
        poseStack.pushPose();
        poseStack.scale(scaleX, scaleY, 1.0f);
        poseStack.translate(scaledOffsetX, scaledOffsetY, 0.0f);
        int posX = guiGraphics.guiWidth() / 2;
        int posY = (int)((double)guiGraphics.guiHeight() / 2.2 - (double)guiGraphics.guiHeight() * (double)guiGraphics.guiHeight() / 280.0 * 0.1 * 0.25 * 0.9);
        poseStack.rotateAround(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, -1.0f, rotDegrees), (float)posX, (float)posY, 0.0f);
        int yOffset = 0;
        for (FormattedCharSequence displayTextSeparated : this.font.split((FormattedText)Component.literal((String)this.textReader.getDisplayText()), 150)) {
            guiGraphics.drawCenteredString(this.font, displayTextSeparated, posX, posY + yOffset, 16410922);
            Objects.requireNonNull(this.font);
            yOffset += 9;
        }
        poseStack.popPose();
        if (!this.textReader.isTextFullyDisplayed() && tick % 3 == 0) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEventRegistry.PHASE_BLINK_BEEP.get()), (float)1.2f));
        }
    }

    public static void addHostMessage(String text) {
        dialogDeque.add(text);
    }

    public static void triggerIntroMessage() {
        if (!isIntro) {
            isIntro = true;
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.0").getString());
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.1").getString());
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.2").getString());
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.3").getString());
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.4").getString());
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.5").getString());
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.6").getString());
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.7").getString());
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.8").getString());
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.9").getString());
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.10").getString());
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.11").getString());
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.12").getString());
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.13").getString());
            dialogDeque.add(Component.translatable((String)"dialog.welcomeplayer.intro.14").getString());
        }
    }
}

