/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.client.gui.screens;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import software.bernie.geckolib.util.RenderUtil;
import xyz.mrfrostydev.welcomeplayer.data.AudienceData;
import xyz.mrfrostydev.welcomeplayer.data.AudienceEvent;
import xyz.mrfrostydev.welcomeplayer.data.AudienceMood;
import xyz.mrfrostydev.welcomeplayer.data.AudiencePhase;
import xyz.mrfrostydev.welcomeplayer.utils.AnimatedImage;
import xyz.mrfrostydev.welcomeplayer.utils.GraphicUtil;
import xyz.mrfrostydev.welcomeplayer.utils.TextReader;

public class SurveillancePadScreen
extends Screen {
    private static final ResourceLocation SCREEN_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"textures/gui/screens/surveillance_neutral_screen.png");
    private static final ResourceLocation SCREEN_SAD_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"textures/gui/screens/surveillance_sad_screen.png");
    private static final ResourceLocation SCREEN_HAPPY_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"textures/gui/screens/surveillance_happy_screen.png");
    private static final ResourceLocation SCREEN_ANGRY_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"textures/gui/screens/surveillance_angry_screen.png");
    private static final ResourceLocation SCREEN_CRUEL_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"textures/gui/screens/surveillance_cruel_screen.png");
    private final TextReader phaseText = new TextReader(3);
    private final TextReader moodText = new TextReader(3);
    private final TextReader eventText = new TextReader(3);
    private final AnimatedImage animatedNeutral = new AnimatedImage(SCREEN_RESOURCE, 12, 256, 512, 2);
    private final AnimatedImage animatedSad = new AnimatedImage(SCREEN_SAD_RESOURCE, 12, 256, 512, 2);
    private final AnimatedImage animatedHappy = new AnimatedImage(SCREEN_HAPPY_RESOURCE, 12, 256, 512, 2);
    private final AnimatedImage animatedAngry = new AnimatedImage(SCREEN_ANGRY_RESOURCE, 12, 256, 512, 2);
    private final AnimatedImage animatedCruel = new AnimatedImage(SCREEN_CRUEL_RESOURCE, 12, 256, 512, 2);
    private AnimatedImage usedImage = this.animatedNeutral;
    private final int MAX_LINE_WIDTH_TOP = 170;
    private final int MAX_LINE_WIDTH_BOTTOM = 65;
    AudienceData data;
    int imageWidth;
    int imageHeight;

    public SurveillancePadScreen(AudienceData data) {
        super((Component)Component.empty());
        this.data = data;
        this.imageWidth = 228;
        this.imageHeight = 178;
    }

    public void tick() {
        this.moodText.tick();
        this.phaseText.tick();
        this.eventText.tick();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 69 || keyCode == 81) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void init() {
        super.init();
        this.animatedNeutral.setVisible(false);
        this.animatedSad.setVisible(false);
        this.animatedHappy.setVisible(false);
        this.animatedAngry.setVisible(false);
        this.animatedCruel.setVisible(false);
        AudienceMood mood = this.data.getMood();
        AudiencePhase phase = this.data.getPhase();
        AudienceEvent event = this.data.getEventManager().getGoingEvent();
        String phaseComponent = "item.welcomeplayer.surveillance.interest.neutral";
        String moodComponent = "item.welcomeplayer.surveillance.mood.neutral";
        String eventComponent = "item.welcomeplayer.surveillance.event";
        if (phase == AudiencePhase.FURIOUS) {
            phaseComponent = "item.welcomeplayer.surveillance.interest.furious";
        } else if (phase == AudiencePhase.BORED) {
            phaseComponent = "item.welcomeplayer.surveillance.interest.bored";
        } else if (phase == AudiencePhase.INTERESTED) {
            phaseComponent = "item.welcomeplayer.surveillance.interest.interested";
        } else if (phase == AudiencePhase.THRILLED) {
            phaseComponent = "item.welcomeplayer.surveillance.interest.thrilled";
        }
        if (mood.equals(AudienceMood.SAD)) {
            moodComponent = "item.welcomeplayer.surveillance.mood.sad";
            this.usedImage = this.animatedSad;
        } else if (mood.equals(AudienceMood.HAPPY)) {
            moodComponent = "item.welcomeplayer.surveillance.mood.happy";
            this.usedImage = this.animatedHappy;
        } else if (mood.equals(AudienceMood.ANGRY)) {
            moodComponent = "item.welcomeplayer.surveillance.mood.angry";
            this.usedImage = this.animatedAngry;
        } else if (mood.equals(AudienceMood.CRUEL)) {
            moodComponent = "item.welcomeplayer.surveillance.mood.cruel";
            this.usedImage = this.animatedCruel;
        }
        this.phaseText.addPermenantText(Component.translatable((String)phaseComponent).getString());
        this.moodText.addPermenantText(Component.translatable((String)moodComponent).getString());
        this.eventText.addPermenantText(Component.translatable((String)eventComponent).append(event.getName()).getString());
        this.usedImage.setPosition((this.width - this.imageWidth) / 2, (this.height - this.imageHeight) / 2);
        this.usedImage.setVisible(true);
        this.usedImage.playLoop();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        int tick = (int)RenderUtil.getCurrentTick();
        this.usedImage.render(guiGraphics, tick, partialTick);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        this.renderText(guiGraphics);
    }

    public void renderText(GuiGraphics guiGraphics) {
        int posX = guiGraphics.guiWidth() / 2 - 94;
        int posY = guiGraphics.guiHeight() / 2 - 68;
        int OffsetY = 0;
        for (FormattedCharSequence displayTextSeparated : this.font.split((FormattedText)Component.literal((String)this.phaseText.getDisplayText()), 170)) {
            GraphicUtil.drawStringWithScale(guiGraphics, this.font, displayTextSeparated, (float)posX, (float)(posY + OffsetY), 0.8f, 16410922, true);
            Objects.requireNonNull(this.font);
            OffsetY += 9;
        }
        for (FormattedCharSequence displayTextSeparated : this.font.split((FormattedText)Component.translatable((String)this.moodText.getDisplayText()), 170)) {
            GraphicUtil.drawStringWithScale(guiGraphics, this.font, displayTextSeparated, (float)posX, (float)(posY + 2 + OffsetY), 0.8f, 16410922, true);
            Objects.requireNonNull(this.font);
            OffsetY += 9;
        }
        int OffsetEventY = 0;
        for (FormattedCharSequence displayTextSeparated : this.font.split((FormattedText)Component.translatable((String)this.eventText.getDisplayText()), 65)) {
            GraphicUtil.drawStringWithScale(guiGraphics, this.font, displayTextSeparated, (float)posX, (float)(posY + 37 + OffsetEventY), 0.8f, 16410922, true);
            Objects.requireNonNull(this.font);
            OffsetEventY += 9;
        }
    }
}

