/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.client.renderers.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import xyz.mrfrostydev.welcomeplayer.entities.projectiles.ShockBoltProjectile;

public class ShockBoltEntityRenderer
extends GeoEntityRenderer<ShockBoltProjectile> {
    public ShockBoltEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new GeoModel<ShockBoltProjectile>(){

            public ResourceLocation getModelResource(ShockBoltProjectile animatable) {
                ResourceLocation basePath = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"shock_bolt_projectile");
                return basePath.withPath("geo/entity/" + basePath.getPath() + ".geo.json");
            }

            public ResourceLocation getAnimationResource(ShockBoltProjectile animatable) {
                ResourceLocation basePath = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"shock_bolt_projectile");
                return basePath.withPath("animations/entity/" + basePath.getPath() + ".animation.json");
            }

            public ResourceLocation getTextureResource(ShockBoltProjectile animatable) {
                ResourceLocation basePath = ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"shock_bolt_projectile");
                String str = switch (animatable.getLength()) {
                    case 2 -> "_short";
                    case 3 -> "_long";
                    default -> "_med";
                };
                return basePath.withPath("textures/entity/" + basePath.getPath() + str + ".png");
            }
        });
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
    }

    public void preRender(PoseStack poseStack, ShockBoltProjectile animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)animatable.yRotO, (float)animatable.getYRot()) / 2.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(-Mth.lerp((float)partialTick, (float)animatable.xRotO, (float)animatable.getXRot()) / 2.0f));
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }
}

