/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import xyz.mrfrostydev.welcomeplayer.data.AudienceData;
import xyz.mrfrostydev.welcomeplayer.data.AudienceEvent;
import xyz.mrfrostydev.welcomeplayer.data.AudienceEventManager;
import xyz.mrfrostydev.welcomeplayer.data.AudienceMood;
import xyz.mrfrostydev.welcomeplayer.data.PlayerObjective;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceEventUtil;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceUtil;
import xyz.mrfrostydev.welcomeplayer.utils.ObjectiveUtil;

public class WelcomeplayerCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode welcomeplayer = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wp").requires(p -> p.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"interest").then(Commands.literal((String)"add").then(Commands.argument((String)"add", (ArgumentType)IntegerArgumentType.integer()).executes(context -> WelcomeplayerCommands.audienceInterestCommand((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"add"), false, false))))).then(Commands.literal((String)"set").then(Commands.argument((String)"set", (ArgumentType)IntegerArgumentType.integer()).executes(context -> WelcomeplayerCommands.audienceInterestCommand((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"set"), false, true))))).then(Commands.literal((String)"get").executes(context -> WelcomeplayerCommands.audienceInterestCommand((CommandSourceStack)context.getSource(), 0, true, false))))).then(((LiteralArgumentBuilder)Commands.literal((String)"mood").then(Commands.literal((String)"set").then(Commands.argument((String)"0-4", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4)).executes(context -> WelcomeplayerCommands.moodCommand((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"0-4"), false))))).then(Commands.literal((String)"get").executes(context -> WelcomeplayerCommands.moodCommand((CommandSourceStack)context.getSource(), 0, true))))).then(((LiteralArgumentBuilder)Commands.literal((String)"objective").then(Commands.literal((String)"set").then(Commands.argument((String)"path", (ArgumentType)StringArgumentType.string()).executes(context -> WelcomeplayerCommands.objectiveCommand((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"path"), false))))).then(Commands.literal((String)"get").executes(context -> WelcomeplayerCommands.objectiveCommand((CommandSourceStack)context.getSource(), "", true))))).then(((LiteralArgumentBuilder)Commands.literal((String)"event").then(Commands.literal((String)"set").then(Commands.argument((String)"path", (ArgumentType)StringArgumentType.string()).executes(context -> WelcomeplayerCommands.eventCommand((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"path"), false))))).then(Commands.literal((String)"get").executes(context -> WelcomeplayerCommands.eventCommand((CommandSourceStack)context.getSource(), "", true)))));
    }

    private static int audienceInterestCommand(CommandSourceStack source, int value, boolean isGet, boolean isSet) {
        ServerLevel svlevel = source.getLevel();
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        if (isGet) {
            source.sendSuccess(() -> Component.translatable((String)"commands.welcomeplayer.interest.get", (Object[])new Object[]{data.getInterest()}), true);
        } else {
            String s;
            String string = s = isSet ? "set" : "add";
            if (isSet) {
                AudienceUtil.setInterestRaw(svlevel, value);
            } else {
                AudienceUtil.addInterestRaw(svlevel, value);
            }
            source.sendSuccess(() -> Component.translatable((String)("commands.welcomeplayer.interest." + s), (Object[])new Object[]{value, data.getInterest()}), true);
        }
        return value;
    }

    private static int moodCommand(CommandSourceStack source, int value, boolean isGet) {
        ServerLevel svlevel = source.getLevel();
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        if (isGet) {
            source.sendSuccess(() -> Component.translatable((String)"commands.welcomeplayer.mood.get", (Object[])new Object[]{data.getMood().toString()}), true);
        } else {
            AudienceMood mood = switch (value) {
                case 1 -> AudienceMood.HAPPY;
                case 2 -> AudienceMood.SAD;
                case 3 -> AudienceMood.ANGRY;
                case 4 -> AudienceMood.CRUEL;
                default -> AudienceMood.NEUTRAL;
            };
            AudienceUtil.setMood(svlevel, mood);
            AudienceUtil.syncToClients(svlevel);
            source.sendSuccess(() -> Component.translatable((String)"commands.welcomeplayer.mood.set", (Object[])new Object[]{AudienceUtil.getMood(svlevel).mood()}), true);
        }
        return value;
    }

    private static int objectiveCommand(CommandSourceStack source, String eventname, boolean isGet) {
        ServerLevel svlevel = source.getLevel();
        PlayerObjective event = PlayerObjective.NOTHING;
        if (isGet) {
            source.sendSuccess(() -> Component.translatable((String)"commands.welcomeplayer.objective.get", (Object[])new Object[]{ObjectiveUtil.getGoingObjective(svlevel).id(), ObjectiveUtil.getProgress(svlevel)}), true);
        } else {
            List<Holder.Reference<PlayerObjective>> allEvents = ObjectiveUtil.getAllObjectivesAsReference(svlevel);
            for (Holder.Reference<PlayerObjective> holder : allEvents) {
                if (!eventname.matches(holder.getKey().location().getPath())) continue;
                event = (PlayerObjective)holder.value();
            }
            ObjectiveUtil.setGoingObjective(svlevel, event);
            AudienceUtil.syncToClients(svlevel);
            source.sendSuccess(() -> Component.translatable((String)"commands.welcomeplayer.objective.set", (Object[])new Object[]{ObjectiveUtil.getGoingObjective(svlevel).id()}), true);
        }
        return 0;
    }

    private static int eventCommand(CommandSourceStack source, String eventname, boolean isGet) {
        ServerLevel svlevel = source.getLevel();
        AudienceEvent event = AudienceEvent.NOTHING;
        if (isGet) {
            source.sendSuccess(() -> Component.translatable((String)"commands.welcomeplayer.event.get", (Object[])new Object[]{AudienceEventUtil.getGoingEvent(svlevel).getName()}), true);
        } else {
            List<Holder.Reference<AudienceEvent>> allEvents = AudienceEventManager.getAllEventsAsReference(svlevel);
            for (Holder.Reference<AudienceEvent> holder : allEvents) {
                if (!eventname.matches(holder.getKey().location().getPath())) continue;
                event = (AudienceEvent)holder.value();
            }
            AudienceUtil.pickMood(svlevel);
            AudienceEventUtil.setGoingEvent(svlevel, event);
            AudienceUtil.restartPhaseShift(svlevel);
            AudienceUtil.syncToClients(svlevel);
            source.sendSuccess(() -> Component.translatable((String)"commands.welcomeplayer.event.set", (Object[])new Object[]{AudienceEventUtil.getGoingEvent(svlevel).getName()}), true);
        }
        return 0;
    }
}

