/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.SavedData;
import xyz.mrfrostydev.welcomeplayer.data.AudienceEvent;
import xyz.mrfrostydev.welcomeplayer.data.AudienceEventManager;
import xyz.mrfrostydev.welcomeplayer.data.AudienceMood;
import xyz.mrfrostydev.welcomeplayer.data.AudiencePhase;

public class AudienceData
extends SavedData {
    private static final int DEFAULT_CHANGE_COOLDOWN = 12000;
    public static final Codec<AudienceData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("active").forGetter(AudienceData::isActive), (App)Codec.INT.fieldOf("interest").forGetter(AudienceData::getInterest), (App)Codec.INT.fieldOf("changeCooldown").forGetter(AudienceData::getChangeCooldown), (App)Codec.BOOL.fieldOf("isPhaseShifting").forGetter(AudienceData::isPhaseShifting), (App)AudiencePhase.CODEC.fieldOf("phase").forGetter(AudienceData::getPhase), (App)AudienceMood.CODEC.fieldOf("mood").forGetter(AudienceData::getMood), (App)AudienceEventManager.CODEC.fieldOf("eventManager").forGetter(AudienceData::getEventManager)).apply((Applicative)instance, AudienceData::new));
    private AudienceDataSmall dataSmall;
    private AudienceDataLarge dataLarge;

    public AudienceData() {
        this.dataSmall = new AudienceDataSmall();
        this.dataLarge = new AudienceDataLarge();
    }

    public AudienceData(AudienceDataSmall dataSmall, AudienceDataLarge dataLarge) {
        this.dataSmall = dataSmall;
        this.dataLarge = dataLarge;
    }

    private AudienceData(boolean isActive, int interest, int changeCooldown, boolean isPhaseShifting, AudiencePhase phase, AudienceMood mood, AudienceEventManager eventManager) {
        this.dataSmall = new AudienceDataSmall(isActive, interest, changeCooldown, isPhaseShifting);
        this.dataLarge = new AudienceDataLarge(eventManager, phase, mood);
    }

    public static AudienceData create() {
        AudienceData data = new AudienceData();
        data.setDirty(true);
        return data;
    }

    public AudienceDataSmall getDataSmall() {
        return this.dataSmall;
    }

    public AudienceDataLarge getDataLarge() {
        return this.dataLarge;
    }

    public void setDataSmall(AudienceDataSmall dataSmall) {
        this.dataSmall = dataSmall;
    }

    public void setDataLarge(AudienceDataLarge dataLarge) {
        this.dataLarge = dataLarge;
    }

    public void setInterest(int value) {
        this.dataSmall.interest = value;
        this.setDirty(true);
    }

    public void addInterest(int add) {
        this.setInterest(this.dataSmall.interest + add);
    }

    public int getInterest() {
        return this.dataSmall.interest;
    }

    public void setMood(AudienceMood mood) {
        this.dataLarge.mood = mood;
        this.setDirty(true);
    }

    public AudienceMood getMood() {
        return this.dataLarge.mood;
    }

    public AudiencePhase getPhase() {
        int interest = this.getInterest();
        if (interest > 400) {
            return AudiencePhase.THRILLED;
        }
        if (interest > 100) {
            return AudiencePhase.INTERESTED;
        }
        if (interest > -100) {
            return AudiencePhase.NEUTRAL;
        }
        if (interest > -400) {
            return AudiencePhase.BORED;
        }
        return AudiencePhase.FURIOUS;
    }

    public AudienceEventManager getEventManager() {
        return this.dataLarge.eventManager;
    }

    public int getChangeCooldown() {
        return this.dataSmall.changeCooldown;
    }

    public void startChangeCooldown() {
        this.dataSmall.changeCooldown = 12000;
        this.setDirty(true);
    }

    public void setActive(boolean bool) {
        this.dataSmall.isActive = bool;
        this.setDirty(true);
    }

    public boolean isActive() {
        return this.dataSmall.isActive;
    }

    public boolean isPhaseShifting() {
        return this.dataSmall.isPhaseShifting;
    }

    public void restartPhaseShift() {
        this.dataSmall.isPhaseShifting = false;
        this.dataLarge.phase = this.getPhase();
        this.setDirty(true);
    }

    public void tickChangeCooldown() {
        if (this.dataSmall.changeCooldown > 0) {
            --this.dataSmall.changeCooldown;
            this.setDirty(true);
        }
    }

    public void tickCheckPhaseShift() {
        if (!this.dataSmall.isPhaseShifting && this.dataLarge.phase != this.getPhase()) {
            this.dataSmall.isPhaseShifting = true;
            this.setDirty(true);
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putBoolean("isActive", this.dataSmall.isActive);
        tag.putInt("interest", this.dataSmall.interest);
        tag.putInt("changeCooldown", this.dataSmall.changeCooldown);
        tag.putBoolean("isPhaseShifting", this.dataSmall.isPhaseShifting);
        tag.putString("phase", this.dataLarge.phase.phase());
        tag.putString("mood", this.dataLarge.mood.mood());
        tag.put("eventManager", (Tag)AudienceEventManager.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getEventManager()).getOrThrow());
        return tag;
    }

    public static AudienceData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        boolean isActive = tag.getBoolean("isActive");
        int interest = tag.getInt("interest");
        int changeCooldown = tag.getInt("changeCooldown");
        boolean isPhaseShifting = tag.getBoolean("isPhaseShifting");
        String phase = tag.getString("phase");
        String mood = tag.getString("mood");
        AudienceEventManager eventManager = (AudienceEventManager)AudienceEventManager.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("eventManager")).getOrThrow();
        AudienceData data = new AudienceData(isActive, interest, changeCooldown, isPhaseShifting, AudiencePhase.create(phase), AudienceMood.create(mood), eventManager);
        return data;
    }

    public static SavedData.Factory<AudienceData> factory() {
        return new SavedData.Factory(AudienceData::create, AudienceData::load);
    }

    public static class AudienceDataSmall {
        private boolean isActive;
        private int interest;
        private int changeCooldown;
        private boolean isPhaseShifting;
        public static final StreamCodec<RegistryFriendlyByteBuf, AudienceDataSmall> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, AudienceDataSmall>(){

            public AudienceDataSmall decode(RegistryFriendlyByteBuf buffer) {
                boolean t1 = (Boolean)ByteBufCodecs.BOOL.decode((Object)buffer);
                int t2 = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
                int t3 = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
                boolean t4 = (Boolean)ByteBufCodecs.BOOL.decode((Object)buffer);
                return new AudienceDataSmall(t1, t2, t3, t4);
            }

            public void encode(RegistryFriendlyByteBuf buffer, AudienceDataSmall value) {
                ByteBufCodecs.BOOL.encode((Object)buffer, (Object)value.isActive);
                ByteBufCodecs.INT.encode((Object)buffer, (Object)value.interest);
                ByteBufCodecs.INT.encode((Object)buffer, (Object)value.changeCooldown);
                ByteBufCodecs.BOOL.encode((Object)buffer, (Object)value.isPhaseShifting);
            }
        };

        private AudienceDataSmall() {
            this.isActive = false;
            this.interest = 100;
            this.changeCooldown = 0;
            this.isPhaseShifting = false;
        }

        public AudienceDataSmall(boolean isActive, int interest, int changeCooldown, boolean isPhaseShifting) {
            this.isActive = isActive;
            this.interest = interest;
            this.changeCooldown = changeCooldown;
            this.isPhaseShifting = isPhaseShifting;
        }
    }

    public static class AudienceDataLarge {
        private final AudienceEventManager eventManager;
        private AudiencePhase phase;
        private AudienceMood mood;
        private List<ResourceLocation> likedItems;
        private List<ResourceLocation> dislikedItems;
        public static final StreamCodec<RegistryFriendlyByteBuf, AudienceDataLarge> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, AudienceDataLarge>(){

            public AudienceDataLarge decode(RegistryFriendlyByteBuf buffer) {
                AudienceEventManager t1 = (AudienceEventManager)AudienceEventManager.STREAM_CODEC.decode((Object)buffer);
                AudiencePhase t2 = (AudiencePhase)AudiencePhase.STREAM_CODEC.decode((Object)buffer);
                AudienceMood t3 = (AudienceMood)AudienceMood.STREAM_CODEC.decode((Object)buffer);
                return new AudienceDataLarge(t1, t2, t3);
            }

            public void encode(RegistryFriendlyByteBuf buffer, AudienceDataLarge value) {
                AudienceEventManager.STREAM_CODEC.encode((Object)buffer, (Object)value.eventManager);
                AudiencePhase.STREAM_CODEC.encode((Object)buffer, (Object)value.phase);
                AudienceMood.STREAM_CODEC.encode((Object)buffer, (Object)value.mood);
            }
        };

        private AudienceDataLarge() {
            this.eventManager = new AudienceEventManager(new HashMap<AudiencePhase, List<AudienceEvent>>());
            this.mood = AudienceMood.NEUTRAL;
            this.phase = AudiencePhase.NEUTRAL;
        }

        public AudienceDataLarge(AudienceEventManager eventManager, AudiencePhase phase, AudienceMood mood) {
            this.eventManager = eventManager;
            this.phase = phase;
            this.mood = mood;
        }
    }
}

