/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.data;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import xyz.mrfrostydev.welcomeplayer.data.PlayerObjective;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceUtil;
import xyz.mrfrostydev.welcomeplayer.utils.ObjectiveUtil;

public class ObjectiveManagerData
extends SavedData {
    public static final StreamCodec<RegistryFriendlyByteBuf, ObjectiveManagerData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ObjectiveManagerData>(){

        public ObjectiveManagerData decode(RegistryFriendlyByteBuf buffer) {
            PlayerObjective t1 = (PlayerObjective)PlayerObjective.STREAM_CODEC.decode((Object)buffer);
            int t2 = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
            int t3 = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
            int t4 = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
            return new ObjectiveManagerData(t1, t2, t3, t4);
        }

        public void encode(RegistryFriendlyByteBuf buffer, ObjectiveManagerData value) {
            PlayerObjective.STREAM_CODEC.encode((Object)buffer, (Object)value.goingObjective);
            ByteBufCodecs.INT.encode((Object)buffer, (Object)value.progress);
            ByteBufCodecs.INT.encode((Object)buffer, (Object)value.maxProgress);
            ByteBufCodecs.INT.encode((Object)buffer, (Object)value.time);
        }
    };
    PlayerObjective goingObjective;
    int progress;
    int maxProgress;
    int time;

    public ObjectiveManagerData() {
        this.goingObjective = PlayerObjective.NOTHING;
        this.progress = 0;
        this.maxProgress = 1;
        this.time = 0;
    }

    public ObjectiveManagerData(PlayerObjective goingObjective, int progress, int maxProgress, int time) {
        this.goingObjective = goingObjective;
        this.progress = progress;
        this.maxProgress = maxProgress;
        this.time = time;
    }

    public static ObjectiveManagerData create() {
        ObjectiveManagerData data = new ObjectiveManagerData();
        data.setDirty();
        return data;
    }

    public void setGoingObjective(PlayerObjective goingObjective) {
        this.goingObjective = goingObjective;
        this.setDirty();
    }

    public void addProgress(int add) {
        this.setProgress(this.progress + add);
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.setDirty();
    }

    public PlayerObjective getGoingObjective() {
        return this.goingObjective;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void setTime(int value) {
        this.time = value;
    }

    public int getTime() {
        return this.time;
    }

    public void doTick(ServerLevel svlevel) {
        if (!AudienceUtil.isActive(svlevel) || ObjectiveUtil.getGoingObjective(svlevel).isNothing()) {
            return;
        }
        if (this.time > 0) {
            --this.time;
            if (this.time <= 0) {
                ObjectiveUtil.failObjective(svlevel);
            }
            this.setDirty();
        }
    }

    public static SavedData.Factory<ObjectiveManagerData> factory() {
        return new SavedData.Factory(ObjectiveManagerData::create, ObjectiveManagerData::load);
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("goingObjective", (Tag)PlayerObjective.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.goingObjective).getOrThrow());
        tag.putInt("progress", this.progress);
        tag.putInt("maxProgress", this.maxProgress);
        tag.putInt("time", this.time);
        return tag;
    }

    public static ObjectiveManagerData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        PlayerObjective goingObjective = (PlayerObjective)PlayerObjective.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("goingObjective")).getOrThrow();
        int progress = tag.getInt("progress");
        int maxProgress = tag.getInt("maxProgress");
        int time = tag.getInt("time");
        return new ObjectiveManagerData(goingObjective, progress, maxProgress, time);
    }
}

