/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xyz.mrfrostydev.welcomeplayer.data.AudiencePhase;
import xyz.mrfrostydev.welcomeplayer.registries.DatapackRegistry;

public record PlayerObjective(String id, AudiencePhase phase, int maxValue, boolean playerScaling, List<Component> dialog) {
    public static final PlayerObjective NOTHING = new PlayerObjective("nothing", AudiencePhase.NEUTRAL, 10, false, List.of(Component.literal((String)"nothing new")));
    public static final Codec<PlayerObjective> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(PlayerObjective::id), (App)AudiencePhase.CODEC.fieldOf("phase").forGetter(PlayerObjective::phase), (App)Codec.INT.fieldOf("maxValue").forGetter(PlayerObjective::maxValue), (App)Codec.BOOL.fieldOf("playerScaling").forGetter(PlayerObjective::playerScaling), (App)ComponentSerialization.CODEC.listOf().fieldOf("dialog").forGetter(PlayerObjective::dialog)).apply((Applicative)instance, PlayerObjective::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayerObjective> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PlayerObjective::id, AudiencePhase.STREAM_CODEC, PlayerObjective::phase, (StreamCodec)ByteBufCodecs.INT, PlayerObjective::maxValue, (StreamCodec)ByteBufCodecs.BOOL, PlayerObjective::playerScaling, (StreamCodec)ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs.list((int)32)), PlayerObjective::dialog, PlayerObjective::new);

    public static PlayerObjective create(String v, AudiencePhase phase, int maxValue, boolean playerScaling, List<Component> dialog) {
        return new PlayerObjective(v, phase, maxValue, playerScaling, dialog);
    }

    public boolean is(PlayerObjective obj) {
        return obj.equals(this);
    }

    public boolean is(Level level, ResourceKey<PlayerObjective> key) {
        return this.is(Objects.requireNonNull((PlayerObjective)level.registryAccess().registryOrThrow(DatapackRegistry.PLAYER_OBJECTIVES).get(key)));
    }

    public boolean isNothing() {
        return this.is(NOTHING);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PlayerObjective)) {
            return false;
        }
        PlayerObjective that = (PlayerObjective)o;
        return Objects.equals(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

