/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.data;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import xyz.mrfrostydev.welcomeplayer.data.VendorItem;
import xyz.mrfrostydev.welcomeplayer.registries.DatapackRegistry;

public class VendorShopData
extends SavedData {
    public static final int COMMON_MIN_FAVOUR = 0;
    public static final int UNCOMMON_MIN_FAVOUR = 400;
    public static final int RARE_MIN_FAVOUR = 1000;
    public static final int DEFAULT_RESTOCK_TIME = 48000;
    private final List<VendorItem> stockList;
    private int restockTime;
    private static final Comparator<VendorItem> FLESH_MERCHANT_COMPARATOR = new Comparator<VendorItem>(){

        @Override
        public int compare(VendorItem c1, VendorItem c2) {
            return Integer.compare(c1.minInterest(), c2.minInterest());
        }
    };

    private VendorShopData(int restockTime) {
        this.stockList = new ArrayList<VendorItem>(16);
        this.restockTime = restockTime;
    }

    public static VendorShopData create() {
        return new VendorShopData(0);
    }

    public VendorShopData(List<VendorItem> list, int restockTime) {
        this.stockList = list;
        this.restockTime = restockTime;
    }

    public List<VendorItem> getStockList() {
        return this.stockList.stream().toList();
    }

    public int getRestockTime() {
        return this.restockTime;
    }

    public boolean isEmpty() {
        return this.stockList.isEmpty();
    }

    public void restockTick(ServerLevel svlevel) {
        --this.restockTime;
        if (this.restockTime <= 0) {
            this.restockTime = 48000;
            this.randomizeSelection((Level)svlevel);
        }
        this.setDirty();
    }

    public void randomizeSelection(Level level) {
        List allMerchantItems = level.registryAccess().registryOrThrow(DatapackRegistry.VENDOR_ITEMS).stream().collect(Collectors.toList());
        ArrayList<VendorItem> commonItems = new ArrayList<VendorItem>(8);
        ArrayList<VendorItem> uncommonItems = new ArrayList<VendorItem>(5);
        ArrayList<VendorItem> rareItems = new ArrayList<VendorItem>(3);
        Collections.shuffle(allMerchantItems);
        for (VendorItem item : allMerchantItems) {
            boolean rareFull;
            boolean commonFull = commonItems.size() >= 8;
            boolean uncommonFull = uncommonItems.size() >= 5;
            boolean bl = rareFull = rareItems.size() >= 3;
            if (item.minInterest() >= 0 && item.minInterest() < 400 && !commonFull) {
                commonItems.add(item);
            } else if (item.minInterest() >= 400 && item.minInterest() < 1000 && !uncommonFull) {
                uncommonItems.add(item);
            } else if (item.minInterest() >= 1000 && !rareFull) {
                rareItems.add(item);
            }
            if (!commonFull || !uncommonFull || !rareFull) continue;
            break;
        }
        this.stockList.clear();
        this.stockList.addAll(commonItems);
        this.stockList.addAll(uncommonItems);
        this.stockList.addAll(rareItems);
        this.stockList.sort(FLESH_MERCHANT_COMPARATOR);
        this.setDirty();
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        VendorItem.CODEC.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, this.getStockList());
        tag.putInt("restockTime", this.restockTime);
        return tag;
    }

    public static VendorShopData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        DataResult stockList = VendorItem.CODEC.listOf().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag);
        int restockTime = tag.getInt("restockTime");
        return new VendorShopData((List)stockList.getOrThrow(), restockTime);
    }

    public static SavedData.Factory<VendorShopData> factory() {
        return new SavedData.Factory(VendorShopData::create, VendorShopData::load);
    }
}

