/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.data.datagen.providers.datapacks;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import xyz.mrfrostydev.welcomeplayer.data.AudiencePhase;
import xyz.mrfrostydev.welcomeplayer.data.PlayerObjective;
import xyz.mrfrostydev.welcomeplayer.registries.DatapackRegistry;

public class PlayerObjectives {
    private static final List<ObjectiveInfo> OBJECTIVES = new ArrayList<ObjectiveInfo>();
    public static final ResourceKey<PlayerObjective> FORCED_RESUPPLY = PlayerObjectives.registerEntry("furious_forced_resupply", 30, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.forced_resupply.0", "dialog.welcomeplayer.objective.forced_resupply.1", "dialog.welcomeplayer.objective.forced_resupply.2", "dialog.welcomeplayer.objective.forced_resupply.3"));
    public static final ResourceKey<PlayerObjective> CRUEL_SUFFERING = PlayerObjectives.registerEntry("furious_cruel_suffering", 200, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.cruel_suffering.0", "dialog.welcomeplayer.objective.cruel_suffering.1", "dialog.welcomeplayer.objective.cruel_suffering.2", "dialog.welcomeplayer.objective.cruel_suffering.3"));
    public static final ResourceKey<PlayerObjective> ENDLESS_VIOLENCE = PlayerObjectives.registerEntry("furious_endless_violence", 70, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.endless_violence.0", "dialog.welcomeplayer.objective.endless_violence.1", "dialog.welcomeplayer.objective.endless_violence.2"));
    public static final ResourceKey<PlayerObjective> DAY_LABOUR = PlayerObjectives.registerEntry("bored_day_labour", 6, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.day_labour.0", "dialog.welcomeplayer.objective.day_labour.1", "dialog.welcomeplayer.objective.day_labour.2", "dialog.welcomeplayer.objective.day_labour.3"));
    public static final ResourceKey<PlayerObjective> METAL_ROSES = PlayerObjectives.registerEntry("bored_metal_roses", 2, false, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.metal_roses.0", "dialog.welcomeplayer.objective.metal_roses.1", "dialog.welcomeplayer.objective.metal_roses.2", "dialog.welcomeplayer.objective.metal_roses.3"));
    public static final ResourceKey<PlayerObjective> DOG_PERSON = PlayerObjectives.registerEntry("bored_dog_person", 1, false, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.dog_person.0", "dialog.welcomeplayer.objective.dog_person.1", "dialog.welcomeplayer.objective.dog_person.2", "dialog.welcomeplayer.objective.dog_person.3"));
    public static final ResourceKey<PlayerObjective> CAT_PERSON = PlayerObjectives.registerEntry("bored_cat_person", 1, false, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.cat_person.0", "dialog.welcomeplayer.objective.cat_person.1", "dialog.welcomeplayer.objective.cat_person.2", "dialog.welcomeplayer.objective.cat_person.3"));
    public static final ResourceKey<PlayerObjective> SHORT_FUSE = PlayerObjectives.registerEntry("bored_short_fuse", 10, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.short_fuse.0", "dialog.welcomeplayer.objective.short_fuse.1", "dialog.welcomeplayer.objective.short_fuse.2"));
    public static final ResourceKey<PlayerObjective> DUCK_HUNT = PlayerObjectives.registerEntry("bored_duck_hunt", 12, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.duck_hunt.0", "dialog.welcomeplayer.objective.duck_hunt.1", "dialog.welcomeplayer.objective.duck_hunt.2", "dialog.welcomeplayer.objective.duck_hunt.3"));
    public static final ResourceKey<PlayerObjective> PAIN = PlayerObjectives.registerEntry("bored_pain", 80, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.pain.0", "dialog.welcomeplayer.objective.pain.1", "dialog.welcomeplayer.objective.pain.2", "dialog.welcomeplayer.objective.pain.3"));
    public static final ResourceKey<PlayerObjective> THE_SHEPHERD = PlayerObjectives.registerEntry("neutral_the_shepherd", 10, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.the_shepherd.0", "dialog.welcomeplayer.objective.the_shepherd.1", "dialog.welcomeplayer.objective.the_shepherd.2", "dialog.welcomeplayer.objective.the_shepherd.3", "dialog.welcomeplayer.objective.the_shepherd.4"));
    public static final ResourceKey<PlayerObjective> PEST_CONTROL = PlayerObjectives.registerEntry("neutral_pest_control", 10, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.pest_control.0", "dialog.welcomeplayer.objective.pest_control.1", "dialog.welcomeplayer.objective.pest_control.2", "dialog.welcomeplayer.objective.pest_control.3"));
    public static final ResourceKey<PlayerObjective> THE_BUTCHER = PlayerObjectives.registerEntry("neutral_the_butcher", 18, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.the_butcher.0", "dialog.welcomeplayer.objective.the_butcher.1", "dialog.welcomeplayer.objective.the_butcher.2"));
    public static final ResourceKey<PlayerObjective> EXPLORER = PlayerObjectives.registerEntry("neutral_explorer", 1, false, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.explorer.0", "dialog.welcomeplayer.objective.explorer.1", "dialog.welcomeplayer.objective.explorer.2", "dialog.welcomeplayer.objective.explorer.3"));
    public static final ResourceKey<PlayerObjective> DEMOLITION = PlayerObjectives.registerEntry("neutral_demolition", 12, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.demolition.0", "dialog.welcomeplayer.objective.demolition.1", "dialog.welcomeplayer.objective.demolition.2", "dialog.welcomeplayer.objective.demolition.3"));
    public static final ResourceKey<PlayerObjective> ZOMBIE_KILLER = PlayerObjectives.registerEntry("neutral_zombie_killer", 10, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.zombie_killer.0", "dialog.welcomeplayer.objective.zombie_killer.1", "dialog.welcomeplayer.objective.zombie_killer.2"));
    public static final ResourceKey<PlayerObjective> COAL_MINER = PlayerObjectives.registerEntry("neutral_coal_miner", 24, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.coal_miner.0", "dialog.welcomeplayer.objective.coal_miner.1", "dialog.welcomeplayer.objective.coal_miner.2", "dialog.welcomeplayer.objective.coal_miner.3"));
    public static final ResourceKey<PlayerObjective> COPPER_AGE = PlayerObjectives.registerEntry("neutral_copper_age", 20, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.copper_age.0", "dialog.welcomeplayer.objective.copper_age.1", "dialog.welcomeplayer.objective.copper_age.2"));
    public static final ResourceKey<PlayerObjective> FARMER = PlayerObjectives.registerEntry("neutral_farmer", 30, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.farmer.0", "dialog.welcomeplayer.objective.farmer.1", "dialog.welcomeplayer.objective.farmer.2", "dialog.welcomeplayer.objective.farmer.3"));
    public static final ResourceKey<PlayerObjective> RATIONING = PlayerObjectives.registerEntry("neutral_rationing", 50, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.rationing.0", "dialog.welcomeplayer.objective.rationing.1", "dialog.welcomeplayer.objective.rationing.2", "dialog.welcomeplayer.objective.rationing.3"));
    public static final ResourceKey<PlayerObjective> MONSTER_HUNTER = PlayerObjectives.registerEntry("interested_monster_hunter", 25, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.monster_hunter.0", "dialog.welcomeplayer.objective.monster_hunter.1", "dialog.welcomeplayer.objective.monster_hunter.2", "dialog.welcomeplayer.objective.monster_hunter.3"));
    public static final ResourceKey<PlayerObjective> SET_BATTLE = PlayerObjectives.registerEntry("interested_set_battle", 6, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.set_battle.0", "dialog.welcomeplayer.objective.set_battle.1", "dialog.welcomeplayer.objective.set_battle.2", "dialog.welcomeplayer.objective.set_battle.3", "dialog.welcomeplayer.objective.set_battle.4"));
    public static final ResourceKey<PlayerObjective> SURVEYOR = PlayerObjectives.registerEntry("interested_surveyor", 2, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.surveyor.0", "dialog.welcomeplayer.objective.surveyor.1", "dialog.welcomeplayer.objective.surveyor.2", "dialog.welcomeplayer.objective.surveyor.3", "dialog.welcomeplayer.objective.surveyor.4"));
    public static final ResourceKey<PlayerObjective> PURE_VIOLENCE = PlayerObjectives.registerEntry("interested_pure_violence", 40, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.pure_violence.0", "dialog.welcomeplayer.objective.pure_violence.1", "dialog.welcomeplayer.objective.pure_violence.2"));
    public static final ResourceKey<PlayerObjective> RICH_DISPLAY = PlayerObjectives.registerEntry("interested_rich_display", 16, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.rich_display.0", "dialog.welcomeplayer.objective.rich_display.1", "dialog.welcomeplayer.objective.rich_display.2", "dialog.welcomeplayer.objective.rich_display.3"));
    public static final ResourceKey<PlayerObjective> GOLD_RUSH = PlayerObjectives.registerEntry("interested_gold_rush", 20, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.gold_rush.0", "dialog.welcomeplayer.objective.gold_rush.1", "dialog.welcomeplayer.objective.gold_rush.2"));
    public static final ResourceKey<PlayerObjective> HUMAN_CHARGER = PlayerObjectives.registerEntry("interested_human_charger", 16, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.human_charger.0", "dialog.welcomeplayer.objective.human_charger.1", "dialog.welcomeplayer.objective.human_charger.2"));
    public static final ResourceKey<PlayerObjective> DESTRUCTION = PlayerObjectives.registerEntry("interested_destruction", 15, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.destruction.0", "dialog.welcomeplayer.objective.destruction.1", "dialog.welcomeplayer.objective.destruction.2"));
    public static final ResourceKey<PlayerObjective> CARNIFEROUS_CROWD = PlayerObjectives.registerEntry("interested_carniferous_crowd", 100, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.carniferous_crowd.0", "dialog.welcomeplayer.objective.carniferous_crowd.1", "dialog.welcomeplayer.objective.carniferous_crowd.2", "dialog.welcomeplayer.objective.carniferous_crowd.3"));
    public static final ResourceKey<PlayerObjective> DISCHARGE = PlayerObjectives.registerEntry("interested_discharge", 2, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.discharge.0", "dialog.welcomeplayer.objective.discharge.1", "dialog.welcomeplayer.objective.discharge.2", "dialog.welcomeplayer.objective.discharge.3"));
    public static final ResourceKey<PlayerObjective> EXPEDITION = PlayerObjectives.registerEntry("thrilled_expedition", 5, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.expedition.0", "dialog.welcomeplayer.objective.expedition.1", "dialog.welcomeplayer.objective.expedition.2", "dialog.welcomeplayer.objective.expedition.3"));
    public static final ResourceKey<PlayerObjective> SUFFERING = PlayerObjectives.registerEntry("thrilled_suffering", 200, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.suffering.0", "dialog.welcomeplayer.objective.suffering.1", "dialog.welcomeplayer.objective.suffering.2", "dialog.welcomeplayer.objective.suffering.3"));
    public static final ResourceKey<PlayerObjective> GOLIATH = PlayerObjectives.registerEntry("thrilled_goliath", 1, false, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.goliath.0", "dialog.welcomeplayer.objective.goliath.1", "dialog.welcomeplayer.objective.goliath.2", "dialog.welcomeplayer.objective.goliath.3"));
    public static final ResourceKey<PlayerObjective> NIGHT_KILLER = PlayerObjectives.registerEntry("thrilled_night_killer", 1, false, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.night_killer.0", "dialog.welcomeplayer.objective.night_killer.1", "dialog.welcomeplayer.objective.night_killer.2", "dialog.welcomeplayer.objective.night_killer.3"));
    public static final ResourceKey<PlayerObjective> WONDER_EGGS = PlayerObjectives.registerEntry("thrilled_wonder_eggs", 10, true, PlayerObjectives.createDialog("dialog.welcomeplayer.objective.wonder_eggs.0", "dialog.welcomeplayer.objective.wonder_eggs.1", "dialog.welcomeplayer.objective.wonder_eggs.2", "dialog.welcomeplayer.objective.wonder_eggs.3", "dialog.welcomeplayer.objective.wonder_eggs.4"));

    public static void bootstrap(BootstrapContext<PlayerObjective> context) {
        for (ObjectiveInfo i : OBJECTIVES) {
            context.register(i.key, (Object)new PlayerObjective(i.id, i.phase, i.maxValue, i.playerScaling, i.dialog));
        }
    }

    public static ResourceKey<PlayerObjective> registerEntry(String name, int maxValue, boolean playerScaling, List<Component> dialog) {
        ResourceKey event = ResourceKey.create(DatapackRegistry.PLAYER_OBJECTIVES, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)name));
        if (maxValue <= 0) {
            throw new RuntimeException("maxValue for a PlayerObjective cannot be less than 1");
        }
        OBJECTIVES.add(PlayerObjectives.getEventInfoByString(name, (ResourceKey<PlayerObjective>)event, maxValue, playerScaling, dialog));
        return event;
    }

    private static ObjectiveInfo getEventInfoByString(String name, ResourceKey<PlayerObjective> event, int maxValue, boolean playerScaling, List<Component> dialog) {
        String[] values = name.split("_");
        AudiencePhase phase = switch (values[0]) {
            case "thrilled" -> AudiencePhase.THRILLED;
            case "interested" -> AudiencePhase.INTERESTED;
            case "neutral" -> AudiencePhase.NEUTRAL;
            case "bored" -> AudiencePhase.BORED;
            case "furious" -> AudiencePhase.FURIOUS;
            default -> throw new IllegalArgumentException("Invalid phase name was entered for: " + name);
        };
        StringBuilder id = new StringBuilder(values[1]);
        for (int i = 2; i < values.length; ++i) {
            id.append("_").append(values[i]);
        }
        return new ObjectiveInfo(event, id.toString(), phase, maxValue, playerScaling, dialog);
    }

    public static List<Component> createDialog(String ... comp) {
        LinkedList<Component> compList = new LinkedList<Component>();
        for (String translation : comp) {
            compList.add((Component)Component.translatable((String)translation));
        }
        return compList;
    }

    private record ObjectiveInfo(ResourceKey<PlayerObjective> key, String id, AudiencePhase phase, int maxValue, boolean playerScaling, List<Component> dialog) {
    }
}

