/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.entities;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import xyz.mrfrostydev.welcomeplayer.entities.EntityHitbox;
import xyz.mrfrostydev.welcomeplayer.entities.EntityHitboxAction;

public class EntityHitboxSet {
    public static final int MAX_TARGETS = 32;
    public Predicate<Entity> predicate = new Predicate<Entity>(){

        @Override
        public boolean test(Entity entity) {
            return !EntityHitboxSet.this.hitUUIDList.contains(entity.getUUID());
        }
    };
    private final Entity entity;
    private final boolean damagePerBox;
    private boolean isActive;
    private final List<SequenceSet> sequenceSets;
    private List<UUID> hitUUIDList = new ArrayList<UUID>(32);
    private final int time;
    private int tick;

    private EntityHitboxSet(Entity entity, List<SequenceSet> sequenceSets, boolean damagePerBox) {
        this.entity = entity;
        this.isActive = false;
        this.sequenceSets = sequenceSets;
        this.damagePerBox = damagePerBox;
        int longestTime = 0;
        for (SequenceSet set : sequenceSets) {
            int timestamp = set.getLastTimestamp();
            if (timestamp <= longestTime) continue;
            longestTime = timestamp;
        }
        this.time = longestTime + 2;
        this.tick = 0;
    }

    public void start() {
        this.isActive = true;
        this.tick = 0;
        for (SequenceSet set : this.sequenceSets) {
            set.reset();
        }
        this.hitUUIDList.clear();
    }

    public void stop() {
        this.isActive = false;
        this.tick = 0;
        for (SequenceSet set : this.sequenceSets) {
            set.reset();
        }
        this.hitUUIDList.clear();
    }

    public void tick(ServerLevel level) {
        if (!this.isActive) {
            return;
        }
        if (this.tick >= this.time) {
            this.isActive = false;
            return;
        }
        for (SequenceSet set : this.sequenceSets) {
            int nextTimestamp = set.getNextTimestamp();
            if (nextTimestamp != -1 && nextTimestamp == this.tick) {
                set.increment();
                if (this.damagePerBox) {
                    this.hitUUIDList.clear();
                }
            }
            Sequence sequence = set.getActiveSequence();
            AABB relativeAABB = this.relativeAABB(this.entity, sequence);
            List entities = level.getEntities(this.entity, relativeAABB, this.predicate);
            entities.forEach(e -> this.hitUUIDList.add(e.getUUID()));
            set.getAction().applyOnHit(level, entities, this.entity);
        }
        ++this.tick;
    }

    public AABB relativeAABB(Entity entity, Sequence sequence) {
        double sizeX = sequence.sizeX / 2.0;
        double sizeY = sequence.sizeY / 2.0;
        double sizeZ = sequence.sizeZ / 2.0;
        Vec3 lookVec3 = entity.getViewVector(1.0f).scale(sequence.forwardOffset);
        Vec3 lookVec3PerpendicularOffset = new Vec3(-lookVec3.z, lookVec3.y, lookVec3.x).scale(sequence.rightOffset);
        Vec3 position = entity.getPosition(1.0f).add(lookVec3).add(lookVec3PerpendicularOffset).add(0.0, sequence.upOffset, 0.0);
        AABB newAABB = new AABB(position.x - sizeX, position.y - sizeY, position.z - sizeZ, position.x + sizeX, position.y + sizeY, position.z + sizeZ);
        return newAABB;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isFinished() {
        return this.tick >= this.time && !this.isActive;
    }

    public int getTime() {
        return this.time;
    }

    public CompoundTag saveData() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("isActive", this.isActive);
        ListTag uuidtaglist = new ListTag(32);
        for (UUID uuid : this.hitUUIDList) {
            CompoundTag uuidTag = new CompoundTag();
            uuidTag.putUUID("uuid", uuid);
            uuidtaglist.add((Object)uuidTag);
        }
        tag.put("uuidList", (Tag)uuidtaglist);
        ListTag sequenceNums = new ListTag();
        for (SequenceSet set : this.sequenceSets) {
            sequenceNums.add((Object)set.saveData());
        }
        tag.put("sequenceNums", (Tag)sequenceNums);
        tag.putInt("tick", this.tick);
        return tag;
    }

    public void loadData(CompoundTag tag) {
        this.isActive = tag.getBoolean("isActive");
        ListTag uuidtaglist = tag.getList("uuidList", (int)tag.getTagType("uuidList"));
        ArrayList<UUID> uuidList = new ArrayList<UUID>(32);
        for (int i = 0; i < uuidtaglist.size(); ++i) {
            CompoundTag t = uuidtaglist.getCompound(i);
            uuidList.add(t.getUUID("uuid"));
        }
        ListTag sequenceNums = tag.getList("sequenceNums", (int)tag.getTagType("sequenceNums"));
        for (int i = 0; i < sequenceNums.size(); ++i) {
            CompoundTag t = sequenceNums.getCompound(i);
            this.sequenceSets.get(i).loadData(t);
        }
        this.tick = tag.getInt("tick");
    }

    public static class SequenceSet {
        private int sequenceNum = 0;
        private final List<Sequence> sequences;
        private final EntityHitboxAction action;

        private SequenceSet(List<Sequence> sequences, EntityHitboxAction action) {
            this.sequences = sequences;
            this.action = action;
        }

        public Sequence getActiveSequence() {
            return this.sequences.get(this.sequenceNum);
        }

        public void increment() {
            ++this.sequenceNum;
        }

        public void reset() {
            this.sequenceNum = 0;
        }

        public EntityHitboxAction getAction() {
            return this.action;
        }

        public int getSequenceNum() {
            return this.sequenceNum;
        }

        public int getNextTimestamp() {
            return this.sequenceNum + 1 < this.sequences.size() ? this.sequences.get((int)(this.sequenceNum + 1)).timestamp : -1;
        }

        public int getLastTimestamp() {
            return this.sequences.getLast().timestamp;
        }

        public void loadData(CompoundTag tag) {
            this.sequenceNum = tag.getInt("sequenceNum");
        }

        public CompoundTag saveData() {
            CompoundTag tag = new CompoundTag();
            tag.putInt("sequenceNum", this.sequenceNum);
            return tag;
        }
    }

    public record Sequence(EntityHitbox hitbox, double forwardOffset, double upOffset, double rightOffset, double sizeX, double sizeY, double sizeZ, int timestamp) {
    }

    public static class Builder {
        List<SequenceSetBuilder> builders = new ArrayList<SequenceSetBuilder>();
        static boolean isDamagePerBox = false;

        public static Builder create() {
            isDamagePerBox = false;
            return new Builder();
        }

        public static Builder create(boolean damagePerBox) {
            isDamagePerBox = damagePerBox;
            return new Builder();
        }

        public Builder add(SequenceSetBuilder builder) {
            this.builders.add(builder);
            return this;
        }

        public EntityHitboxSet build(Entity entity) {
            return new EntityHitboxSet(entity, this.builders.stream().map(SequenceSetBuilder::build).toList(), isDamagePerBox);
        }
    }

    public static class SequenceSetBuilder {
        private double sizeX;
        private double sizeY;
        private double sizeZ;
        private EntityHitbox hitbox;
        private LinkedList<Sequence> sequences = new LinkedList();
        private EntityHitboxAction action;

        private SequenceSetBuilder(EntityHitbox hitbox, EntityHitboxAction action) {
            AABB aabb = hitbox.getAABB();
            Vec3 center = aabb.getCenter();
            this.sizeX = center.x;
            this.sizeY = center.y;
            this.sizeZ = center.z;
            this.hitbox = hitbox;
            this.sequences.clear();
            this.sequences.add(new Sequence(new EntityHitbox(0.0, 0.0, 0.0), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0));
            this.action = action;
        }

        private SequenceSetBuilder(double sizeX, double sizeY, double sizeZ, EntityHitboxAction action) {
            this.hitbox = new EntityHitbox(sizeX, sizeY, sizeZ);
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sequences.clear();
            this.sequences.add(new Sequence(new EntityHitbox(0.0, 0.0, 0.0), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0));
            this.action = action;
        }

        public static SequenceSetBuilder create(double sizeX, double sizeY, double sizeZ, EntityHitboxAction hitboxAction) {
            return new SequenceSetBuilder(sizeX, sizeY, sizeZ, hitboxAction);
        }

        public SequenceSetBuilder transition(double forwardOffset, double upOffset, double rightOffset, int timestamp) {
            this.sequences.add(new Sequence(this.hitbox, forwardOffset, upOffset, rightOffset, this.sizeX, this.sizeY, this.sizeZ, timestamp));
            return this;
        }

        public SequenceSetBuilder transition(double forwardOffset, double upOffset, double rightOffset, double sizeX, double sizeY, double sizeZ, int timestamp) {
            this.sequences.add(new Sequence(this.hitbox, forwardOffset, upOffset, rightOffset, sizeX, sizeY, sizeZ, timestamp));
            return this;
        }

        public SequenceSet build() {
            return new SequenceSet(this.sequences, this.action);
        }
    }
}

