/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.entities.ai;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import xyz.mrfrostydev.welcomeplayer.entities.EntityHitboxSet;

public class MeleeAttackWithHitbox
extends Behavior<Mob> {
    protected EntityHitboxSet hitboxSet;
    protected int cooldownBetweenAttacks;

    public MeleeAttackWithHitbox(int cooldownBetweenAttacks, EntityHitboxSet hitboxSet) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT), hitboxSet.getTime());
        this.hitboxSet = hitboxSet;
        this.cooldownBetweenAttacks = cooldownBetweenAttacks;
    }

    protected boolean checkExtraStartConditions(ServerLevel svlevel, Mob owner) {
        LivingEntity target = (LivingEntity)owner.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        List nearestLivingEntity = (List)owner.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).get();
        return owner.isWithinMeleeAttackRange(target) && nearestLivingEntity.contains(target) && !this.hitboxSet.isActive();
    }

    protected boolean canStillUse(ServerLevel level, Mob owner, long gameTime) {
        Brain brain = owner.getBrain();
        return brain.hasMemoryValue(MemoryModuleType.NEAREST_LIVING_ENTITIES) && brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET);
    }

    protected void start(ServerLevel level, Mob owner, long gameTime) {
        this.hitboxSet.start();
    }

    protected void tick(ServerLevel svlevel, Mob owner, long gameTime) {
        LivingEntity target = (LivingEntity)owner.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        owner.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        owner.swing(InteractionHand.MAIN_HAND);
        this.hitboxSet.tick(svlevel);
    }

    protected void stop(ServerLevel level, Mob owner, long gameTime) {
        owner.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (long)this.cooldownBetweenAttacks);
        this.hitboxSet.stop();
    }
}

