/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.entities.mobs.eradicator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import xyz.mrfrostydev.welcomeplayer.entities.ai.ChangeTargetIfCloser;
import xyz.mrfrostydev.welcomeplayer.entities.mobs.eradicator.EradicatorEntity;
import xyz.mrfrostydev.welcomeplayer.entities.mobs.eradicator.EradicatorHoverToTargetSink;
import xyz.mrfrostydev.welcomeplayer.entities.mobs.eradicator.EradicatorMeleeAttack;
import xyz.mrfrostydev.welcomeplayer.entities.mobs.eradicator.EradicatorShoot;
import xyz.mrfrostydev.welcomeplayer.registries.MemoryModuleRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.SensorRegistry;

public class EradicatorAI {
    protected static final ImmutableList<SensorType<? extends Sensor<? super EradicatorEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.HURT_BY, SensorRegistry.ERADICATOR_NEAREST_ATTACKABLE_SENSOR.get());
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleRegistry.ERADICATOR_SAWING.get(), MemoryModuleRegistry.ERADICATOR_SHOOT_CHARGING.get(), MemoryModuleRegistry.ERADICATOR_SHOOTING.get(), MemoryModuleRegistry.ERADICATOR_SHOOT_RECOVERING.get(), MemoryModuleRegistry.ERADICATOR_SHOOT_COOLDOWN.get(), (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object[])new MemoryModuleType[]{MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY});

    protected static Brain<?> makeBrain(EradicatorEntity entity, Brain<EradicatorEntity> brain) {
        EradicatorAI.initCoreActivity(entity, brain);
        EradicatorAI.initIdleActivity(entity, brain);
        EradicatorAI.initFightActivity(entity, brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(EradicatorEntity entity, Brain<EradicatorEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90)));
    }

    private static void initIdleActivity(EradicatorEntity entity, Brain<EradicatorEntity> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)StartAttacking.create(e -> e.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE))), (Object)Pair.of((Object)1, (Object)StartAttacking.create(EradicatorEntity::getHurtBy)), (Object)Pair.of((Object)2, (Object)((Object)new EradicatorHoverToTargetSink(20, 40))), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new DoNothing(20, 100), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)0.5f), (Object)2))))));
    }

    private static void initFightActivity(EradicatorEntity entity, Brain<EradicatorEntity> brain) {
        brain.addActivityWithConditions(Activity.FIGHT, ImmutableList.of((Object)Pair.of((Object)0, (Object)StopAttackingIfTargetInvalid.create((e, target) -> {})), (Object)Pair.of((Object)1, ChangeTargetIfCloser.create(0.7f, 20)), (Object)Pair.of((Object)2, (Object)((Object)new EradicatorMeleeAttack(40, entity.getHitboxSets().getFirst()))), (Object)Pair.of((Object)3, (Object)((Object)new EradicatorShoot())), (Object)Pair.of((Object)4, (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f))), Set.of(Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    protected static void updateActivity(EradicatorEntity entity) {
        Brain<EradicatorEntity> brain = entity.getBrain();
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
    }
}

