/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.entities.mobs.eradicator;

import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import xyz.mrfrostydev.welcomeplayer.damages.SawDamageSource;
import xyz.mrfrostydev.welcomeplayer.data.datagen.providers.datapacks.ModDamageTypes;
import xyz.mrfrostydev.welcomeplayer.entities.EntityHitboxSet;
import xyz.mrfrostydev.welcomeplayer.entities.ai.navigation.HoverPathNavigation;
import xyz.mrfrostydev.welcomeplayer.entities.mobs.eradicator.EradicatorAI;
import xyz.mrfrostydev.welcomeplayer.registries.EntityRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.TagRegistry;

public class EradicatorEntity
extends Monster
implements GeoEntity {
    public static final double TARGETING_RANGE = 32.0;
    public static final double SAW_ATTACK_RANGE = 2.0;
    public static final int SAW_ATTACK_COOLDOWN = 40;
    private List<EntityHitboxSet> hitboxSets;
    private final AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenPlay("eradicator.animation.idle");
    private static final RawAnimation MOVE_ANIM = RawAnimation.begin().thenPlay("eradicator.animation.move");
    private static final RawAnimation CANNON_ATTACK_ANIM = RawAnimation.begin().thenPlay("eradicator.animation.cannon_attack");
    private static final RawAnimation SAW_ATTACK_ANIM = RawAnimation.begin().thenPlay("eradicator.animation.saw_attack");

    public EradicatorEntity(EntityType<EradicatorEntity> entityType, Level level) {
        super((EntityType)EntityRegistry.ERADICATOR.get(), level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
    }

    protected PathNavigation createNavigation(Level level) {
        return new HoverPathNavigation((Mob)this, level);
    }

    public void tick() {
        super.tick();
        if (this.isPassenger()) {
            this.removeVehicle();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 250.0).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, (double)0.35f).add(Attributes.ATTACK_DAMAGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.9).add(Attributes.ARMOR, 25.0).add(Attributes.ARMOR_TOUGHNESS, 5.0).add(Attributes.FALL_DAMAGE_MULTIPLIER, 0.5);
    }

    protected Brain.Provider<EradicatorEntity> brainProvider() {
        return Brain.provider(EradicatorAI.MEMORY_TYPES, EradicatorAI.SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        this.hitboxSets = this.registerHitboxSets();
        return EradicatorAI.makeBrain(this, (Brain<EradicatorEntity>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<EradicatorEntity> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        EradicatorAI.updateActivity(this);
        super.customServerAiStep();
    }

    public Optional<LivingEntity> getHurtBy() {
        return this.getBrain().getMemory(MemoryModuleType.HURT_BY).map(DamageSource::getEntity).filter(e -> e instanceof LivingEntity).map(e -> (LivingEntity)e);
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.getTargetFromBrain();
    }

    public boolean canAttackType(EntityType<?> type) {
        return !type.is(TagRegistry.HOST_ROBOT);
    }

    public boolean isWithinMeleeAttackRange(LivingEntity entity) {
        return this.getBoundingBox().inflate(2.0).intersects(entity.getHitbox());
    }

    public List<EntityHitboxSet> registerHitboxSets() {
        EntityHitboxSet attackHitbox = EntityHitboxSet.Builder.create(true).add(EntityHitboxSet.SequenceSetBuilder.create(2.5, 0.5, 2.5, EradicatorEntity::onHit).transition(2.5, 1.5, 0.1, 15).transition(2.5, 1.5, 0.1, 20).transition(2.5, 1.5, 0.1, 25).transition(2.5, 1.5, 0.1, 30)).build((Entity)this);
        return List.of(attackHitbox);
    }

    public List<EntityHitboxSet> getHitboxSets() {
        return this.hitboxSets;
    }

    private static <T extends Entity> void onHit(ServerLevel serverLevel, List<Entity> entities, T inflictor) {
        if (!(inflictor instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)inflictor;
        for (Entity target : entities) {
            if (target.is((Entity)livingEntity)) continue;
            target.hurt((DamageSource)new SawDamageSource((Holder<DamageType>)serverLevel.registryAccess().holderOrThrow(ModDamageTypes.SAW), (Entity)livingEntity), (float)livingEntity.getAttributeValue(Attributes.ATTACK_DAMAGE) / 4.0f);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::handleAnimations));
    }

    private <T extends EradicatorEntity> PlayState handleAnimations(AnimationState<T> state) {
        EradicatorEntity entity = (EradicatorEntity)state.getAnimatable();
        if (entity.swinging) {
            state.setAnimation(SAW_ATTACK_ANIM);
        } else if (entity.getPose() == Pose.SHOOTING) {
            state.setAnimation(CANNON_ATTACK_ANIM);
        } else if (state.isMoving() || entity.getPose() == Pose.SLIDING) {
            state.setAnimation(MOVE_ANIM);
        } else {
            state.setAnimation(IDLE_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        ListTag hitboxesList = new ListTag();
        for (EntityHitboxSet set : this.hitboxSets) {
            hitboxesList.add((Object)set.saveData());
        }
        tag.put("hitboxSets", (Tag)hitboxesList);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        ListTag hitboxesList = tag.getList("hitboxSets", (int)tag.getTagType("hitboxSets"));
        for (int i = 0; i < this.hitboxSets.size(); ++i) {
            EntityHitboxSet set = this.hitboxSets.get(i);
            set.loadData(hitboxesList.getCompound(i));
        }
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    public int getMaxHeadYRot() {
        return 30;
    }

    public int getHeadRotSpeed() {
        return 25;
    }

    public int getCurrentSwingDuration() {
        return 40;
    }

    public boolean canStandOnFluid(FluidState fluidState) {
        return fluidState.is(FluidTags.LAVA) || fluidState.is(FluidTags.WATER);
    }

    public boolean fireImmune() {
        return true;
    }

    public void checkDespawn() {
    }
}

