/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.entities.mobs.eradicator;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Mob;
import xyz.mrfrostydev.welcomeplayer.entities.EntityHitboxSet;
import xyz.mrfrostydev.welcomeplayer.entities.ai.MeleeAttackWithHitbox;
import xyz.mrfrostydev.welcomeplayer.entities.mobs.eradicator.EradicatorEntity;
import xyz.mrfrostydev.welcomeplayer.registries.MemoryModuleRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.SoundEventRegistry;

public class EradicatorMeleeAttack
extends MeleeAttackWithHitbox {
    public EradicatorMeleeAttack(int cooldownBetweenAttacks, EntityHitboxSet hitboxSet) {
        super(cooldownBetweenAttacks, hitboxSet);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel svlevel, Mob owner) {
        return owner instanceof EradicatorEntity && super.checkExtraStartConditions(svlevel, owner) && !owner.getBrain().hasMemoryValue(MemoryModuleRegistry.ERADICATOR_SHOOTING.get());
    }

    @Override
    protected void start(ServerLevel svlevel, Mob owner, long gameTime) {
        super.start(svlevel, owner, gameTime);
        owner.getBrain().setMemoryWithExpiry(MemoryModuleRegistry.ERADICATOR_SAWING.get(), (Object)Unit.INSTANCE, (long)this.hitboxSet.getTime());
        owner.playSound((SoundEvent)SoundEventRegistry.BUZZ_SAW.get(), 3.0f, 0.8f + svlevel.random.nextFloat() * 0.2f);
    }

    @Override
    protected void stop(ServerLevel svlevel, Mob owner, long gameTime) {
        super.stop(svlevel, owner, gameTime);
        owner.getBrain().eraseMemory(MemoryModuleRegistry.ERADICATOR_SAWING.get());
    }
}

